<?php
// AShop
// Copyright 2002-2018 - All Rights Reserved Worldwide
// http://www.ashopsoftware.com
// This software is licensed per individual site.
// By installing or using this software, you agree to the licensing terms,
// which are located at http://www.ashopsoftware.com/license.htm
// Unauthorized use or distribution of this software 
// is a violation U.S. and international copyright laws.

include "admin/checklicense.inc.php";
include "admin/ashopconstants.inc.php";

if (empty($enablepartyplanner)) {
	header("Location: $ashopurl");
	exit;
}

// Validate variables...
if (!ashop_is_md5($_COOKIE["customersessionid"])) $_COOKIE["customersessionid"] = "";

if (empty($_COOKIE["customersessionid"]) && empty($_COOKIE["wssessionid"])) {
	header("Location: signupform.php");
	exit;
}

// Apply selected theme...
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none") include "themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "language/$lang/customerparties.inc.php";

// Get member template path if no theme is used...
if ($shop && $shop != "1" && $usethemetemplates != "true" && file_exists("$ashoppath/members/files/$ashopuser/catalogue.html")) $templatepath = "/members/files/$ashopuser";

// Read wholesale session cookie if this is a wholesale customer...
if (!empty($_COOKIE["wssessionid"])) $_COOKIE["customersessionid"] = $_COOKIE["wssessionid"];

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Get customer information from database...
$sql="SELECT * FROM customer WHERE sessionid='{$_COOKIE["customersessionid"]}'";
$result = @mysqli_query($db, "$sql");
if (@mysqli_num_rows($result) == 0) {
	header("Location: signupform.php");
	exit;
}

// Store customer information in variables...
$firstname = @mysqli_result($result, 0, "firstname");
$lastname = @mysqli_result($result, 0, "lastname");
$customerid = @mysqli_result($result, 0, "customerid");
$email = @mysqli_result($result, 0, "email");
$affiliateid = @mysqli_result($result, 0, "affiliateid");

// Make sure the customer is referred by an affiliate...
if (empty($affiliateid)) {
    if (!empty($affiliate) && is_numeric($affiliate)) $affiliateid = $affiliate;
    else {
        header("Location: affiliate.php");
        exit;
    }
}

// Print header from template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/partyplanner-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/partyplanner-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/partyplanner.html");

echo "<div class=\"span12\">\n";

if (!empty($inviteemail) && !ashop_is_email($inviteemail)) $inviteemail = "";

// Register accepted invitation...
if (!empty($inviteyes) && is_numeric($inviteyes)) {
	@mysqli_query($db, "UPDATE partyinvitations SET response='yes' WHERE invitationid='$inviteyes'");

	$partyinvitationresult = @mysqli_query($db, "SELECT partyid FROM partyinvitations WHERE invitationid='$inviteyes'");
	$partyid = @mysqli_result($partyinvitationresult, 0, "partyid");
	$partyresult = @mysqli_query($db, "SELECT location, date FROM party WHERE partyid='$partyid'");
	$partylocation = @mysqli_result($partyresult, 0, "location");
	$partydate = @mysqli_result($partyresult, 0, "date");

	echo "<h4 class=\"text-center\">".THANKYOU."</h4><p>".WELCOMETOTHEPARTY." $partylocation ".THEWORDON." $partydate.</p></div>";

	// Print footer using template...
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/partyplanner-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/partyplanner-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/partyplanner.html");
	exit;
}

// Register declined invitation
if (!empty($inviteno) && is_numeric($inviteno)) {
	@mysqli_query($db, "UPDATE partyinvitations SET response='no' WHERE invitationid='$inviteno'");

	echo "<h4 class=\"text-center\">".THANKYOUFORLETTINGUSKNOW."</h4></div>";

	// Print footer using template...
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/partyplanner-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/partyplanner-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/partyplanner.html");
	exit;
}

if (!empty($invite) && is_numeric($invite)) {
	$partyresult = @mysqli_query($db, "SELECT * FROM party WHERE partyid='$invite'");
	if (@mysqli_num_rows($partyresult)) {
		$partyrow = @mysqli_fetch_array($partyresult);
		if ($partyrow["customerid"] == $customerid) {
			if (!empty($inviteemail)) {
				$checkalreadysent = @mysqli_query($db, "SELECT invitationid FROM partyinvitations WHERE email='$inviteemail' AND partyid='$invite'");
				if (!@mysqli_num_rows($checkalreadysent)) {
					if (file_exists("$ashoppath/templates/messages/partyinvitation-$lang.html")) $messagefile = "$ashoppath/templates/messages/partyinvitation-$lang.html";
					else $messagefile = "$ashoppath/templates/messages/partyinvitation.html";
					$fp = @fopen("$messagefile","r");
					if ($fp) {
						// Register invitation in the database...
						$today = date("Y-m-d H:i:s", time()+$timezoneoffset);
						@mysqli_query($db, "INSERT INTO partyinvitations (email, date, partyid) VALUES ('$inviteemail', '$today', '$invite')");
						$invitationid = @mysqli_insert_id($db);

						// Read message template and send invitation by email...
						while (!feof ($fp)) $messagetemplate .= fgets($fp, 4096);
						fclose($fp);
						$partyaffiliateid = $partyrow["affiliateid"];
						$acceptpartyurl = $ashopurl."/affiliate.php?id=$partyaffiliateid&redirect=customerparties.php?inviteyes=$invitationid";
						$declinepartyurl = $ashopurl."/affiliate.php?id=$partyaffiliateid&redirect=customerparties.php?inviteno=$invitationid";
						$message = str_replace("%ashopname%",$ashopname,$messagetemplate);
						$message = str_replace("%yeslink%",$acceptpartyurl,$message);
						$message = str_replace("%nolink%",$declinepartyurl,$message);
						$message = str_replace("%inviterfirstname%",$firstname,$message);
						$message = str_replace("%inviterlastname%",$lastname,$message);
						$message = str_replace("%partylocation%",$partyrow["location"],$message);
						$message = str_replace("%partydate%",$partyrow["date"],$message);
						$subject="$ashopname - ".PARTYINVITATION;
						$headers = "From: $ashopname<$ashopemail>\nX-Sender: <$ashopemail>\nX-Mailer: PHP\nX-Priority: 3\nReturn-Path: <$ashopemail>\nMIME-Version: 1.0\nContent-Type: text/html; charset=iso-8859-1\n";
						@ashop_mail("$inviteemail","$subject","$message","$headers");
						$msg = INVITATIONSENT;
					}
				} else $msg = INVITATIONALREADYSENT;
			}

			echo "<h4 class=\"text-center\">".INVITATIONTOPARTYON." <b>".$partyrow["date"]."</b> ".AT." <b>".$partyrow["location"]."</b>...</h4>
            <p class=\"text-center\"><a href=\"customerparties.php";
			if (!empty($shop) && $shop > 1) echo "?shop=$shop";
			echo "\"><button class=\"btn\">".BACKTOPARTIES."</button></a></p>";
			if ($msg == INVITATIONSENT) echo "<p class=\"ashopcustomeralert2 text-center\">$msg</p>";
			else if ($msg == INVITATIONALREADYSENT) echo "<p class=\"ashopcustomeralert text-center\">$msg</p>";
			echo "
			<form method=\"post\" action=\"customerparties.php\" class=\"text-center\">
			<div class=\"control-group\">
                <label class=\"control-label\">".SENDTO.":</label>
                <div class=\"controls\"> 
                    <input type=\"text\" name=\"inviteemail\" id=\"email\" class=\"input-xlarge\">
                </div>
                <div class=\"controls\"> 
                    <button type=\"submit\" name=\"Submit\" class=\"btn btn-inverse\" value=\"".SUBMIT."\">".SUBMIT."</button>
                </div>
            </div>";
			if (!empty($shop) && $shop > 1) echo "
				<input type=\"hidden\" name=\"shop\" value=\"$shop\">";
			echo "
				<input type=\"hidden\" name=\"invite\" value=\"$invite\"></form>
				<h4 class=\"text-center\">".SENTINVITATIONS."</h4>
				<p><table class=\"table table-striped\"><thead>
				<tr><th>".INVITATIONDATE."</th><th>".EMAIL."<th>".RESPONSE."</th></tr></thead><tbody>";
			$invitationsresult = @mysqli_query($db, "SELECT * FROM partyinvitations WHERE partyid='$invite' ORDER BY date");
			while ($invitationrow = @mysqli_fetch_array($invitationsresult)) {
				if (empty($invitationrow["response"])) $invitationrow["response"] = PENDING;
				else if ($invitationrow["response"] == "yes") $invitationrow["response"] = ACCEPTED;
				else if ($invitationrow["response"] == "no") $invitationrow["response"] = DECLINED;
				echo "<tr>
				<td>".$invitationrow["date"]."</td><td>".$invitationrow["email"]."</td><td>".$invitationrow["response"]."</td></tr>";
			}
			echo "</tbody></table></p>";
			// Print footer using template...
			if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/partyplanner-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/partyplanner-$lang.html");
			else ashop_showtemplatefooter("$ashoppath$templatepath/partyplanner.html");
			exit;
		}
	}
}

echo "<h4 class=\"text-center\">".MANAGEPARTIES."</h4>
<p class=\"text-center\"><a href=\"customerprofile.php";
if (!empty($shop) && $shop > 1) echo "?shop=$shop";
echo "\"><button class=\"btn\">".VIEWPROFILE."</button></a></p>
<p class=\"text-center\"><a href=\"hostparty.php";
if (!empty($shop) && $shop > 1) echo "?shop=$shop";
echo "\"><button class=\"btn\">".HOSTAPARTY."</button></a></p>";

if ($msg) echo "<p class=\"ashopcustomeralert text-center\">$msg</p>";

echo "
<p><table class=\"table table-striped\"><thead>
	<tr><th>".WHEN."</th><th>".WHERE."<th>".COMMENT."</th><th>".RESULT."</th><th>&nbsp;</th></tr></thead><tbody>";

// Get statistics from database...
$total = 0;
$date = date("Y-m-d h:i A", time()+$timezoneoffset);
$sql="SELECT * FROM party WHERE customerid='$customerid' ORDER BY date ASC";
$result = @mysqli_query($db, "$sql");
if (@mysqli_num_rows($result) != 0) {
  for ($i = 0; $i < @mysqli_num_rows($result);$i++) {
	  $partyid = @mysqli_result($result, $i, "partyid");
	  $partydate = @mysqli_result($result, $i, "date");
	  $location = @mysqli_result($result, $i, "location");
	  $comment = @mysqli_result($result, $i, "description");
	  $approved = @mysqli_result($result, $i, "approved");
	  $ended = @mysqli_result($result, $i, "ended");
	  if ($approved != "1") $partyresult = AWAITINGAPPROVAL;
	  else if ($partydate >= $date) $partyresult = PENDING;
	  else {
		  $partyresult = 0;
		  $ordersresult = @mysqli_query($db, "SELECT price FROM orders WHERE partyid='$partyid' AND paid!='' AND paid IS NOT NULL");
		  while ($ordersrow = @mysqli_fetch_array($ordersresult)) $partyresult += $ordersrow["price"];
	  }
	  if ($partydate < $date && $approved == "1") {
		  $total += $partyresult;
		  $partyresult = $currencysymbols[$ashopcurrency]["pre"].number_format($partyresult,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"];
	  }
	  echo "<tr>
	  <td>$partydate</td><td>$location</td><td>$comment</td><td>$partyresult</td><td>";

	  if ($ended != "1" && $partydate > $date) echo "<a href=\"hostparty.php?edit=$partyid\"><img src=\"images/icon_edit.png\" alt=\"".EDITPARTY."\" title=\"".EDITPARTY."\" /></a>";

	  if ($approved == "1" && $ended != "1" && $partydate >= $date) echo " <a href=\"customerparties.php?invite=$partyid\"><img src=\"images/icon_email.png\" alt=\"".INVITE."\" title=\"".INVITE."\" /></a>";
	  
	  echo "</td></tr>";
  }
}
echo "<tr><td colspan=\"3\" style=\"background-color:$categorycolor;\" align=\"right\"><span class=\"ashopcustomerhistorytext1\">".TOTAL.":</span></td><td align=\"left\"><span class=\"ashopcustomertext3\">".$currencysymbols[$ashopcurrency]["pre"].number_format($total,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</span></td><td style=\"background-color:$categorycolor;\" colspan=\"2\">&nbsp;</td></tr></tbody></table><br><br><br><br></div>";

// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/partyplanner-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/partyplanner-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/partyplanner.html");

// Close database...
@mysqli_close($db);
?>