<?php
// AShop
// Copyright 2019 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "../admin/config.inc.php";
include "../admin/ashopfunc.inc.php";

// Validate confirmation code...
if (!empty($aid) && !preg_match("/^[2-9a-z]{7}$/", $aid)) $aid = "";

// Check for GD...
$checkgd = TRUE;
if (empty($recaptchakey)) include "../includes/captcha.inc.php";

// If GD is available generate random code for security check...
if (!$_GET["aid"] && function_exists('imagecreatefromjpeg') && function_exists('imagecreatefromgif') && function_exists('imagecreatetruecolor') && $gdversion == 2) {
	$activatesecuritycheck = TRUE;
	if ($action == "generatecode") {
		$checkcode = generatecode($random);
		$image = ImageCreateFromJPEG("$ashoppath/admin/images/codebg.jpg");
		$text_color = ImageColorAllocate($image, 80, 80, 80);
		Header("Content-type: image/jpeg");
		ImageString ($image, 5, 12, 2, $checkcode, $text_color);
		ImageJPEG($image, NULL, 75);
		ImageDestroy($image);
		exit;
	}
} else $activatesecuritycheck = FALSE;

// Apply selected theme...
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none" && file_exists("$ashoppath/themes/$ashoptheme/theme.cfg.php")) include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/af_signup.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Get pending affiliate information to confirm email...
$confirmed = FALSE;
if ($_GET["aid"]) {
	$pendingaffresult = @mysqli_query($db, "SELECT * FROM pendingaffiliate WHERE password='{$_GET["aid"]}'");
	if (@mysqli_num_rows($pendingaffresult)) {
		$pendingaffrow = @mysqli_fetch_array($pendingaffresult);
		$affuser = $pendingaffrow["user"];
		$business = $pendingaffrow["business"];
		$firstname = $pendingaffrow["firstname"];
		$lastname = $pendingaffrow["lastname"];
		$email = $pendingaffrow["email"];
		$paypalid = $pendingaffrow["paypalid"];
		$address = $pendingaffrow["address"];
		$state = $pendingaffrow["state"];
		$zip = $pendingaffrow["zip"];
		$city = $pendingaffrow["city"];
		$country = $pendingaffrow["country"];
		$url = $pendingaffrow["url"];
		$phone = $pendingaffrow["phone"];
		$affiliate = $pendingaffrow["referedby"];
		$extrainfo = $pendingaffrow["extrainfo"];
		@mysqli_query($db, "DELETE FROM pendingaffiliate WHERE password='{$_GET["aid"]}'");
		$confirmed = TRUE;
	} else {
		if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
		else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");
		echo "<div class=\"span12\"><h4 class=\"text-center\">".ERROR."</h4>
		<p class=\"text-center\">".AIDDOESNOTEXIST."</p><br><br><br><br><br><br><br><br><br><br></div>";
		if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
		else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");
		exit;
	}
}

// Check for spam injection...
$affuser = ashop_mailsafe($affuser);
$affuser = ashop_cleanfield($affuser);
if (strlen($affuser) < 2) $affuser = "";
$business = ashop_mailsafe($business);
$business = ashop_cleanfield($business);
if (strlen($business) < 2) $business = "";
$firstname = ashop_mailsafe($firstname);
$firstname = ashop_cleanfield($firstname);
if (strlen($firstname) < 2) $firstname = "";
$lastname = ashop_mailsafe($lastname);
$lastname = ashop_cleanfield($lastname);
if (strlen($lastname) < 2) $lastname = "";
$email = ashop_mailsafe($email);
$email = ashop_cleanfield($email);
if (strlen($email) < 2) $email = "";
$address = ashop_mailsafe($address);
$address = ashop_cleanfield($address);
if (strlen($address) < 2) $address = "";
$state = ashop_mailsafe($state);
$state = ashop_cleanfield($state);
if (strlen($state) < 2) $state = "";
$province = ashop_mailsafe($province);
$province = ashop_cleanfield($province);
if (strlen($province) < 2) $province = "";
if (empty($state) && !empty($province)) $state = $province;
$zip = ashop_mailsafe($zip);
$zip = ashop_cleanfield($zip);
if (strlen($zip) < 2) $zip = "";
$city = ashop_mailsafe($city);
$city = ashop_cleanfield($city);
if (strlen($city) < 2) $city = "";
$country = ashop_mailsafe($country);
$country = ashop_cleanfield($country);
if (strlen($country) < 2) $country = "";
$phone = ashop_mailsafe($phone);
$phone = ashop_cleanfield($phone);
if (strlen($phone) < 2) $phone = "";
$paypalid = ashop_mailsafe($paypalid);
$paypalid = ashop_cleanfield($paypalid);
if (strlen($paypalid) < 2) $paypalid = "";
$url = ashop_cleanfield($url);
if (substr($url,0,7) != "http://" && substr($url,0,8) != "https://") $url = "http://".$url;
if (strlen($url) < 11) $url = "";

// Check if all fields were filled in...
if (($affuser=="") || ($firstname=="") || ($lastname=="")
|| ($email=="") || ($address=="") || ($zip=="") || ($city=="") || ($country=="") || ($paypalid=="" && $requirepaypalid)) {
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".ERROR."</h4>
	<p class=\"text-center\">".YOUFORGOT."</p>
	<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");
	exit;
}


// Check if the username contains forbidden characters...
if (strstr($affuser, chr(32)) || strstr($affuser, chr(33)) || strstr($affuser, chr(44)) || strstr($affuser, chr(46)) || strstr($affuser, chr(63)) || (strlen($affuser) > 10)) {
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".ERROR."</h4>
	<p class=\"text-center\">".THEUSERNAME."</p>
	<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");
	exit;
}

// Check if the right security check code has been provided...
if (empty($recaptchakey) && $activatesecuritycheck && (!$securitycheck || $securitycheck != generatecode($random))) {
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".ERROR."</h4>
	<p class=\"text-center\">".INCORRECTSECURITYCODE."</p>
	<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");
	exit;
}

// Check if a correct ReCaptcha has been provided...
if (!empty($recaptchakey) && !ashop_recaptcha($_POST["g-recaptcha-response"])) {
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".ERROR."</h4>
	<p class=\"text-center\">".INCORRECTSECURITYCODE."</p>
	<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");
	exit;
}

// Check affiliate data...
$sql="SELECT user FROM affiliate WHERE user='$affuser'";
$result = @mysqli_query($db, "$sql");
if (@mysqli_num_rows($result) != 0) {
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".SORRY."</h4>
	<p class=\"text-center\">".ALREADYINUSE."</p>
	<p class=\"text-center\"><a href=\"javascript:history.back()\">".TRYAGAIN."</a></p><br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");
	exit;
}


// Generate a unique password...
function makePassword() {
   $alphaNum = array('2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z');
   srand ((double) microtime() * 1000000);
   $pwLength = "7"; // this sets the limit on how long the password is.
   for($i = 1; $i <=$pwLength; $i++) {
      $newPass .= $alphaNum[(rand(0,31))];
   }
   return ($newPass);
}
$affpassword = makePassword();
$unique = 0;
while (!$unique) {
   if ($affiliateconfirm && !$confirmed) $sql="SELECT password FROM pendingaffiliate WHERE password='$affpassword'";
   else $sql="SELECT password FROM affiliate WHERE password='$affpassword'";
   $result = @mysqli_query($db, "$sql");
   if (@mysqli_num_rows($result) == 0) $unique = 1;
   else $affpassword = makePassword();
}

// Generate a unique referral code for manual referral...
$referralcode = substr(strtolower($firstname),0,2).substr(strtolower($lastname),0,3);
$referralcode .= str_repeat("0",5-strlen($referralcode));
$refnumber = 1;
$newreferralcode = $referralcode;
$referralcodenumber = $referralcode.sprintf("%03d",$refnumber);
$unique = 0;
$n = 0;
$m = ord("a");
while(!$unique) {
	while(!$unique && $refnumber < 1000) {
		$result = @mysqli_query($db, "SELECT referralcode FROM affiliate WHERE referralcode='$referralcodenumber'");
		if(@mysqli_num_rows($result)) {
			$refnumber++;
			$referralcodenumber = $newreferralcode.sprintf("%03d",$refnumber);
		} else $unique = 1;
	} if(!$unique) {
		$refnumber = 1;
		$newreferralcode = substr_replace($referralcode, chr($m), $n, 1);
		$referralcodenumber = $newreferralcode.sprintf("%03d",$refnumber);
		if($m == ord("z")) {
			$n++;
			$m = ord("a");
		} else $m++;
	}
}

// Set current date and time...
$date = date("Y-m-d H:i:s", time()+$timezoneoffset);

// Set confirmation code if email confirmation is on...
if ($affiliateconfirm && !$confirmed) {
	$sql = "INSERT INTO pendingaffiliate (user, password, business, firstname, lastname,
	email, address, state, zip, city, country, phone, url, paypalid, extrainfo, referedby) VALUES ('$affuser', '$affpassword', '$business', '$firstname', '$lastname', '$email', '$address', '$state', '$zip', '$city', '$country', '$phone', '$url', '$paypalid', '$extrainfo', '$affiliate')";
	$result = @mysqli_query($db, "$sql");

	$message = "<html><head><title>".THANKYOUFORJOINING." $ashopname ".AFFILIATEPROGRAM."</title></head><body><font face=\"$font\"><p>".YOUARERECEIVING." $ashopname.</p>
	<p>".PLEASEVERIFY." <a href=\"$ashopurl/affiliate/signup.php?aid=$affpassword\">$ashopurl/affiliate/signup.php?aid=$affpassword</a></p></font></body></html>";

	$headers = "From: ".un_html($ashopname)."<$affiliaterecipient>\nX-Sender: <$affiliaterecipient>\nX-Mailer: PHP\nX-Priority: 3\nReturn-Path: <$affiliaterecipient>\nMIME-Version: 1.0\nContent-Type: text/html; charset=iso-8859-1\n";
	@ashop_mail("$email",un_html($ashopname)." ".AFFILIATEPROGRAM,"$message","$headers");
	@mysqli_close($db);

	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");
	echo "<div class=\"span12\"><h4 class=\"text-center\">".THANKYOUFORREGISTERING." $ashopname ".AFFILIATEPROGRAM."</h4>
	<p class=\"text-center\">".CHECKMAIL."</p>
	<br><br><br><br><br><br><br><br><br><br></div>";
	if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
	else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");

	exit;
}

// Store affiliate data...
if ($paypalid) $sql = "INSERT INTO affiliate (user, password, business, firstname, lastname,
email, address, state, zip, city, country, phone, url, paypalid, signedup, updated, referralcode, commissionlevel, extrainfo) VALUES ('$affuser', '$affpassword', '$business', '$firstname', '$lastname', '$email', '$address', '$state', '$zip', '$city', '$country', '$phone', '$url', '$paypalid', '$date', '$date', '$referralcodenumber', 1, '$extrainfo')";
else $sql = "INSERT INTO affiliate (user, password, business, firstname, lastname,
email, address, state, zip, city, country, phone, url, signedup, updated, referralcode, commissionlevel, extrainfo) VALUES ('$affuser', '$affpassword', '$business', '$firstname', '$lastname', '$email', '$address', '$state', '$zip', '$city', '$country', '$phone', '$url', '$date', '$date', '$referralcodenumber', 1, '$extrainfo')";
$result = @mysqli_query($db, "$sql");
$affiliateid = @mysqli_insert_id($db);
if ($affiliate && $secondtieractivated) {
	$sql = "UPDATE affiliate SET referedby=$affiliate WHERE affiliateid=$affiliateid";
	$result = @mysqli_query($db, "$sql");
}

// Send message to inform webmaster about the new affiliate...

$message="<html><head><title>New Affiliate</title></head><body><font face=\"$font\"><b>$affuser</b> has signed up with the affiliate program, check his/her website: <a href=\"$url\">$url</a></font></body></html>";
$headers = "From: ".un_html($ashopname)."<$affiliaterecipient>\nX-Sender: <$affiliaterecipient>\nX-Mailer: PHP\nX-Priority: 3\nReturn-Path: <$affiliaterecipient>\nMIME-Version: 1.0\nContent-Type: text/html; charset=iso-8859-1\n";
@ashop_mail("$affiliaterecipient","New Affiliate Signed Up","$message","$headers");

// Close database...

@mysqli_close($db);

// Send message with password to affiliate...

if (file_exists("$ashoppath/templates/messages/affiliatesignupmessage-$lang.html")) $messagefile = "$ashoppath/templates/messages/affiliatesignupmessage-$lang.html";
else $messagefile = "$ashoppath/templates/messages/affiliatesignupmessage.html";
$fp = @fopen("$messagefile","r");
if ($fp) {
	while (!feof ($fp)) $messagetemplate .= fgets($fp, 4096);
	fclose($fp);
} else {
	$messagetemplate="<html><head><title>".THANKYOUFORJOINING." $ashopname ".AFFILIATEPROGRAM."</title></head><body><font face=\"$font\"><p>".THANKYOUFORJOINING." $ashopname ".AFFILIATEPROGRAM."</p><p>".YOURUSERNAMEIS." <b>$affuser</b>".ANDYOURPASSWORD." <b>$affpassword</b></p><p>".TOMANUALLYREFER." $referralcodenumber</p><p>".LOGIN." <b><a href=\"$ashopurl/affiliate/login.php\">$ashopurl/affiliate/login.php</a></b></p></font></body></html>";
}
$message = str_replace("%ashopname%",$ashopname,$messagetemplate);
$message = str_replace("%username%",$affuser,$message);
$message = str_replace("%password%",$affpassword,$message);
$message = str_replace("%referralcode%",$referralcodenumber,$message);
$message = str_replace("%affiliateid%",$affiliateid,$message);
$message = str_replace("%affiliateurl%","$ashopurl/affiliate.php?id=$affiliateid",$message);
$message = str_replace("%business%",$business,$message);
$message = str_replace("%firstname%",$firstname,$message);
$message = str_replace("%lastname%",$lastname,$message);
$message = str_replace("%email%",$email,$message);
$message = str_replace("%address%",$address,$message);
$message = str_replace("%state%",$state,$message);
$message = str_replace("%zip%",$zip,$message);
$message = str_replace("%city%",$city,$message);
$message = str_replace("%country%",$country,$message);
$message = str_replace("%phone%",$phone,$message);
$message = str_replace("%url%",$url,$message);
$message = str_replace("%date%",$date,$message);
$message = str_replace("%loginlink%","<a href=\"$ashopurl/affiliate/login.php\">$ashopurl/affiliate/login.php</a>",$message);

$headers = "From: ".un_html($ashopname)."<$affiliaterecipient>\nX-Sender: <$affiliaterecipient>\nX-Mailer: PHP\nX-Priority: 3\nReturn-Path: <$affiliaterecipient>\nMIME-Version: 1.0\nContent-Type: text/html; charset=iso-8859-1\n";
@ashop_mail("$email",un_html($ashopname)." ".AFFILIATEPROGRAM,"$message","$headers");

// Show login form...
header("Location:login.php?newregistered=true");
?>