<?php
// AShop
// Copyright 2016 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "../admin/config.inc.php";
include "../admin/ashopfunc.inc.php";
include "../admin/ashopconstants.inc.php";
include "checklogin.inc.php";

// Apply selected theme...
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none") include "../themes/$ashoptheme/theme.cfg.php";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "../language/$lang/af_affiliate.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Get affiliate information from database...
$sql="SELECT * FROM affiliate WHERE sessionid='$affiliatesesid'";
$result = @mysqli_query($db, "$sql");

// Reset statistics...
$click = 0;
$provision = 0;
$ourdebt = 0;

// Store affiliate information in variables...
$firstname = @mysqli_result($result, 0, "firstname");
$lastname = @mysqli_result($result, 0, "lastname");
$affiliateid = @mysqli_result($result, 0, "affiliateid");
$correctpasswd = @mysqli_result($result, 0, "password");
$referralcode = @mysqli_result($result, 0, "referralcode");
$click = @mysqli_result($result, 0, "clicks");
$commissionlevel = @mysqli_result($result, 0, "commissionlevel");

// Get statistics from database...
$sql="SELECT * FROM affiliate WHERE referedby='$affiliateid'";
$result = @mysqli_query($db, "$sql");
$referrals = @mysqli_num_rows($result);
$sql="SELECT orderaffiliate.orderid FROM orders, orderaffiliate WHERE orderaffiliate.affiliateid='$affiliateid' AND orderaffiliate.orderid=orders.orderid AND (orderaffiliate.secondtier IS NULL OR orderaffiliate.secondtier='0')";
$result = @mysqli_query($db, "$sql");
$order = @mysqli_num_rows($result);
if (!$order) $order = "0";
$sql="SELECT orderaffiliate.paid, orderaffiliate.commission FROM orders, orderaffiliate WHERE orderaffiliate.affiliateid='$affiliateid' AND orderaffiliate.orderid=orders.orderid";
$result = @mysqli_query($db, "$sql");
if (@mysqli_num_rows($result)) {
  while ($row = @mysqli_fetch_array($result)) {
	  $paid = $row["paid"];
	  $commission = $row["commission"];
	  $provision += $commission;
	  if (!$paid) $ourdebt += $commission;
  }
}
$sql="SELECT orderaffiliate.orderid FROM orders, orderaffiliate WHERE orderaffiliate.affiliateid='$affiliateid' AND orderaffiliate.orderid=orders.orderid AND (orderaffiliate.secondtier>0 AND orderaffiliate.secondtier IS NOT NULL)";
$result = @mysqli_query($db, "$sql");
$secondtier = @mysqli_num_rows($result);
if (!$secondtier) $secondtier = "0";

// Get number of unread PMs...
$sql="SELECT * FROM affiliatepm WHERE toaffiliateid='$affiliateid' AND (hasbeenread='' OR hasbeenread='0' OR hasbeenread IS NULL)";
$unreadresult = @mysqli_query($db, "$sql");
$unreadcount = @mysqli_num_rows($unreadresult);

// Print header from template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/affiliate.html");

echo "<div class=\"span3 sidebar\">
<ul class=\"nav nav-sidebar\">
<li class=\"active\"><a href=\"#\">".STATISTICS."</a></li>
<li><a href=\"changeprofile.php\">".VIEWPROFILE."</a></li>
<li><a href=\"changepassword.php\">".CHANGEPASS."</a></li>";
if (file_exists("$ashoppath/customerparties.php") && $enablepartyplanner == "1") echo "<li><a href=\"parties.php\">".PARTIES."</a></li>";
echo "<li><a href=\"linkcodes.php\">".LINKCODES."</a></li>
<li><a href=\"orderhistory.php\">".ORDERHISTORY."</a></li>
<li><a href=\"downline.php\">".DOWNLINE."</a></li>";
if ($activateleads) echo "<li><a href=\"leads.php\">".LEADS."</a></li>";
echo "<li><a href=\"inbox.php\">".INBOX;
if ($unreadcount) echo " ($unreadcount)";
echo "</a></li>
<li><a href=\"login.php?logout\">".LOGOUT."</a></li>
</ul></div>";
$affiliatelink = "$ashopurl/affiliate.php?id=$affiliateid";
$affiliatelinklength = strlen($affiliatelink);
echo "<div class=\"span9\"><h4>".WELCOME." $firstname $lastname! ".AFFILIATEID.": $affiliateid</h4>$salesreplink	
	
	<div class=\"control-group\"> 
                  <label class=\"control-label\">".YOURLINK.":</label>
                  <div class=\"controls\"> 
                    <input id=\"affiliatelink\" type=\"text\" class=\"input-xxlarge\" value=\"$ashopurl/affiliate.php?id=$affiliateid\" onclick=\"document.getElementById('affiliatelink').select();\"></div>
              </div>";
if ($commissionlevel == "2") echo "<p><strong>".ACCOUNTLEVEL.":</strong> ".UPGRADED."</p>";
echo "
	<h5>".STATISTICS.":</h5>
	<p>".CLICKS.": <strong>$click</strong><br>".ORDERS.": <strong>$order</strong>";

if ($upgradeaffiliate && $commissionlevel != "2") {
	$ordersleft = $upgradeaffiliate - $order;
	echo "<br>".ORDERSLEFT.": <strong>$ordersleft</strong>";
}

if ($secondtieractivated) echo "<br>".RECRUITED.": <strong>$referrals</strong><br>".TWOTIERORDERS.": <strong>$secondtier</strong>";

echo "<br>".TOTALEARNINGS.": <strong>".$currencysymbols[$ashopcurrency]["pre"].number_format($provision,2,'.','')." ".$currencysymbols[$ashopcurrency]["post"]."</strong><br>".OWEYOU.": <strong>".$currencysymbols[$ashopcurrency]["pre"].number_format($ourdebt,2,'.','')." ".$currencysymbols[$ashopcurrency]["post"]."</strong></p>";

// Get top 5 referers...
$result = @mysqli_query($db, "SELECT * FROM affiliatereferer WHERE affiliateid='$affiliateid' ORDER BY clicks DESC LIMIT 5");
if (@mysqli_num_rows($result)) {
	echo "
	<h5>".TOPREFERERS.":</h5><ul>";
	while ($row = @mysqli_fetch_array($result)) {
		$referer = $row["referer"];
		$clicks = $row["clicks"];
		echo "<li>$referer - $clicks ".REFERERCLICKS."</li>";
	}
}
echo "</div>";

// Close database...

@mysqli_close($db);

// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/affiliate-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/affiliate-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/affiliate.html");
?>