<?php
// AShop
// Copyright 2019 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

@set_time_limit(0);
include "config.inc.php";
include "ashopfunc.inc.php";
include "checklogin.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/customers.inc.php";
include "ashopconstants.inc.php";

// Convert translated buttons...
if ($generate == "Redigera") $generate = "Edit";
if ($generate == "Visa") $generate = "View";
if ($generate == "Ladda ner") $generate = "Download";

// Only ashopadmin should be allowed to edit orders...
if ($generate == "View" && $userid == "1") $generate = "Edit";

// Convert double quote enclosure for CSV...
if ($defaultenclosure == "&quot;") $defaultenclosure = "\"";

// Get the correct userid...
if ($userid == "1" && $memberid > 1) $user = $memberid;
else $user = $userid;

// Get context help for this page...
$contexthelppage = "salesreport";
include "help.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Show report options...
if (!$generate) {
	
	// Get the oldest and newest order...
	$maxdate = date("Y-m-d H:i:s", time()+$timezoneoffset);
    $mindate = date("Y-m-d H:i:s", strtotime("1 month ago")+$timezoneoffset);
    /*
	if ($user > "1") $sql = "SELECT date FROM orders WHERE date != '' AND userid LIKE '%|$user|%' ORDER BY date LIMIT 1";
	else $sql = "SELECT date FROM orders WHERE date != '' ORDER BY date LIMIT 1";
	$result = @mysqli_query($db, "$sql");
	$mindate = @mysqli_result($result, 0, "date");
	if($wholesalecatalog && $userid == "1") {
		$sql = "SELECT date FROM orders WHERE date != '' AND wholesale='1' ORDER BY date LIMIT 1";
		$result = @mysqli_query($db, "$sql");
		$wsmindate = @mysqli_result($result, 0, "date");
		if($wsmindate && $wsmindate < $mindate) $mindate = $wsmindate;
	}*/

	echo "$header
    <section class=\"content-header\"><h1>".SALESREPORT;
	if ($userid == "1") echo " <a href=\"$help1\" target=\"_blank\"><img src=\"images/icon_helpsm.gif\" width=\"15\" height=\"15\" border=\"0\"></a>";
	echo "</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">";
	if ($msg == "deleted") echo "
              <div class=\"alert alert-success alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ORDERDELETED."
              </div>";
	if ($msg == "activated") echo "
              <div class=\"alert alert-success alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ORDERACTIVATIONSENT."
              </div>";
	if ($msg == "remindersent") echo "
              <div class=\"alert alert-success alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".REMINDERSENT."
              </div>";
    echo "
            <form action=\"salesreport.php\" method=\"post\" name=\"salesreportform\">
                <div class=\"box-body\">
                    <div class=\"form-group\"><label for=\"transtype\">".TRANSACTIONTYPE."</label>
                        <select class=\"form-control\" name=\"transtype\">";
	if ($userid == "1" && $wholesalecatalog) echo "<option value=\"retail\">".RETAIL."</option><option value=\"wholesale\">".WHOLESALE."</option><option value=\"auction\">".AUCTION."</option><option value=\"all\">".ALL."</option>";
	else echo "<option value=\"retail\">".RETAIL."</option><option value=\"auction\">".AUCTION."</option>";
	echo "</select>
                    </div>
                    <div class=\"form-group\"><label for=\"reporttype\">".PAYMENTSTATUS."</label>
                        <select class=\"form-control\" name=\"reporttype\">";
	if ($userid == "1") echo "<option value=\"paid\" selected>".PAID."</option><option value=\"unpaid\">".UNPAID."</option><option value=\"chargebacks\">".CHARGEBACKS."</option><option value=\"all\">".ALL."</option>";
	else echo "<option value=\"paid\" selected>".PAIDBYCUSTOMER."</option><option value=\"unpaid\">".UNPAIDBYCUSTOMER."</option><option value=\"chargebacks\">".CHARGEBACKS."</option>";
	echo "</select>
                    </div>
                    <div class=\"form-group\"><label for=\"shippingstatus\">".SHIPPINGSTATUS."</label>
                        <select class=\"form-control\" name=\"shippingstatus\"><option value=\"shipped\" selected>".SHIPPED."</option><option value=\"unshipped\">".UNSHIPPED."</option><option value=\"all\" selected>".ALL."</option></select>
                    </div>
                    <div class=\"form-group\"><label>".FROM."</label>
                        <div class=\"input-group date\">
                            <div class=\"input-group-addon\">
                                <i class=\"fa fa-calendar\"></i>
                            </div>
                            <input type=\"text\" class=\"form-control pull-right\" id=\"fromdate\" name=\"fromdate\" value=\"$mindate\">
                        </div>
                    </div>
                    <div class=\"form-group\"><label>".TO."</label>
                        <div class=\"input-group date\">
                            <div class=\"input-group-addon\">
                                <i class=\"fa fa-calendar\"></i>
                            </div>
                            <input type=\"text\" class=\"form-control pull-right\" id=\"todate\" name=\"todate\" value=\"$maxdate\">
                        </div>
                    </div>";
    $pagescript = "
                    <script>
                        $(function () {
                            $('#fromdate').daterangepicker({ singleDatePicker: true, timePicker: true, timePickerIncrement: 5, timePicker24Hour: true, locale: { format: 'YYYY-MM-DD HH:mm' }});
                            $('#todate').daterangepicker({ singleDatePicker: true, timePicker: true, timePickerIncrement: 5, timePicker24Hour: true, locale: { format: 'YYYY-MM-DD HH:mm' }});
                        })
                    </script>";    
    echo "
                    <div class=\"form-group\"><label for=\"orderby\">".ORDERBY."</label>
                        <div class=\"row\">
                        <div class=\"col-md-6\">
                        <select class=\"form-control\" name=\"orderby\"><option value=\"date\" selected>".THEWORDDATE."</option><option value=\"price\">".AMOUNT."</option><option value=\"customerid\">".CUSTOMERID."</option><option value=\"orderid\">".ORDERID."</option><option value=\"affiliate\">".AFFILIATE."</option>";
	if ($userid == "1") echo "<option value=\"productid\">".PRODUCT."</option><option value=\"dproductid\">".DOWNLOADABLEPRODUCT."</option><option value=\"pproductid\">".PHYSICALPRODUCT."</option>";
	echo "</select></div><div class=\"col-md-6\"><select class=\"form-control\" name=\"ascdesc\"><option value=\"asc\" selected>".ASCENDING."</option><option value=\"desc\">".DESCENDING."</option></select></div></div>
                    </div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"generate\" value=\"".VIEW."\">".VIEW."</button>
					<button type=\"submit\" class=\"btn btn-primary\" name=\"generate\" value=\"".DOWNLOAD."\">".DOWNLOAD."</button>
				</div>
            </form>
        </div>";
		
	if ($userid == "1") echo "
		<div class=\"box box-primary\">
            <form action=\"salesreport.php\" method=\"post\" name=\"lookupform\">
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".LOOKUPORDER."</h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => ORDERID, "name" => "orderid"))."</div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"submit\" value=\"".SEARCH."\">".SEARCH."</button>
				</div>
                <input type=\"hidden\" name=\"generate\" value=\"Edit\">
                <input type=\"hidden\" name=\"lookup\" value=\"true\">
            </form>
        </div>
		<div class=\"box box-primary\">
            <form action=\"editpreliminary.php\" method=\"post\" name=\"incompleteform\">
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".LOOKUPINCOMPLETEORDERS."</h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => ORDERID, "name" => "orderid"))."</div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"generate\" value=\"".SEARCH."\">".SEARCH."</button>
				</div>
                <input type=\"hidden\" name=\"action\" value=\"complete\">
            </form>
        </div>";
	echo "</div></div></section>";
    $footer = str_replace("<!-- pagescript -->", $pagescript, $footer);
    echo $footer;

// Generate downloadable reports...
} else if ($generate == "Download") {
	$ordertable = "orders";
	$customertable = "customer";
	$customeridfield = "customerid";
	$paidcheck = " AND paid != ''";
	if ($transtype == "wholesale") $ordertypesql = " AND wholesale = '1'";
	else if ($transtype == "auction") $ordertypesql = " AND source = 'Auction'";
	else if ($transtype == "retail") $ordertypesql = " AND (wholesale IS NULL OR wholesale != '1')";
	if (($memberid > 1 && $userid == "1") || $user > 1) {
		$ordertable = "memberorders";
		$usercheck = "=$user";
	} else $usercheck = "LIKE '%|$user|%'";
	if ($reporttype == "chargebacks") {
		$filename = "chargebacks";
		$orderafftable = "orderaffiliate";
	} else if ($reporttype == "unpaid") {
		$filename = "unpaid";
		$orderafftable = "pendingorderaff";
	} else if ($reporttype == "paid") {
		$filename = "sales";
		$orderafftable = "orderaffiliate";
	} else $filename = "transactions";
	header ("Content-Type: application/octet-stream");
	header ("Content-Disposition: attachment; filename=$filename.csv");
	if ($orderby == "productid") echo ORDERID2."{$defaultdelimiter}".THEWORDDATE."{$defaultdelimiter}".THEWORDTIME."{$defaultdelimiter}".QUANTITY."{$defaultdelimiter}".PRICE."{$defaultdelimiter}".PRODUCT."{$defaultdelimiter}".CUSTOMER."{$defaultdelimiter}";
	else echo ORDERID2."{$defaultdelimiter}".TRANSID."{$defaultdelimiter}".PAYMENTMETHOD."{$defaultdelimiter}".THEWORDDATE."{$defaultdelimiter}".THEWORDTIME."{$defaultdelimiter}".PRODUCTS."{$defaultdelimiter}".SUBTOTAL."{$defaultdelimiter}".SHIPPING."{$defaultdelimiter}".TAX."{$defaultdelimiter}".TOTAL."{$defaultdelimiter}".CUSTOMERID."{$defaultdelimiter}".FIRSTNAME."{$defaultdelimiter}".LASTNAME."{$defaultdelimiter}".EMAIL."{$defaultdelimiter}".ADDRESS."{$defaultdelimiter}".CITY."{$defaultdelimiter}".ZIP."{$defaultdelimiter}".STATE."{$defaultdelimiter}".COUNTRY."{$defaultdelimiter}".PHONE."{$defaultdelimiter}".IP."{$defaultdelimiter}";
	if ($reporttype == "chargebacks") echo COMMENT."\r\n";
	else echo REFERRED."\r\n";

	// Report ordered by product...
	if ($orderby == "productid" || $orderby == "dproductid" || $orderby == "pproductid") {
		if ($orderby == "productid" || $orderby == "pproductid") {
			if (($memberid > 1 && $userid == "1") || $user > 1) $result = @mysqli_query($db, "SELECT * FROM product WHERE userid='$user' ORDER BY name $ascdesc");
			else $result = @mysqli_query($db, "SELECT * FROM product ORDER BY name $ascdesc");
		} else if ($orderby == "dproductid") {
			if (($memberid > 1 && $userid == "1") || $user > 1) $result = @mysqli_query($db, "SELECT DISTINCT product.* FROM product, productfiles WHERE product.userid='$user' AND product.productid=productfiles.productid ORDER BY product.name $ascdesc");
			else $result = @mysqli_query($db, "SELECT DISTINCT product.* FROM product, productfiles WHERE product.productid=productfiles.productid ORDER BY product.name $ascdesc");
		}
		while($row=@mysqli_fetch_array($result)) {
			$productid=$row["productid"];
			$productname=trim($row["name"]);
			$productname = un_html($productname);
			if ($defaultenclosure == "\"" && strstr($productname,"\"")) $productname = str_replace("\"","\"\"",$productname);
			if ($orderby == "pproductid") {
				$checkfiles = @mysqli_query($db, "SELECT * FROM productfiles WHERE productid='$productid'");
				if (@mysqli_num_rows($checkfiles)) $failedfilescheck = TRUE;
				else $failedfilescheck = FALSE;
			}
			if($productid && $productname && !$failedfilescheck) {
				if ($reporttype == "paid") $paidstring = "$ordertable.paid != ''";
				else if ($reporttype == "unpaid") $paidstring = "$ordertable.paid = ''";
				$sql = "SELECT $customertable.*, $ordertable.* FROM $customertable, $ordertable WHERE ($ordertable.products LIKE '%b$productid"."a%' OR $ordertable.products LIKE '%b$productid"."d%') AND $ordertable.$customeridfield = $customertable.$customeridfield AND $ordertable.date >= '$fromdate' AND $ordertable.date <= '$todate'";
				if ($paidcheck && $paidstring) $sql .= " AND $paidstring";
				if ($ordertypesql) $sql .= $ordertypesql;
				if ($reporttype == "chargebacks") $sql .= " AND reference != '' AND reference IS NOT NULL AND $ordertable.price < 0";
				$result2 = @mysqli_query($db, $sql);
				if(@mysqli_num_rows($result2)) {
					$subtotal = 0;
					$totalqty = 0;
					while($row2=@mysqli_fetch_array($result2)) if ($thisquantity=ashop_checkproduct($productid,$row2["products"])) {
						$productprices = explode("|",$row2["paidproductprices"]);
						if ($row2["paidproductprices"] && is_array($productprices)) foreach ($productprices as $pricepart) {
							$thisproductprice = explode(":",$pricepart);
							if ($thisproductprice[0] == $productid) $productprice = $thisproductprice[1];
						} else if ($row2["wholesale"]) {
							$wspriceresult = @mysqli_query($db, "SELECT wholesaleprice FROM product WHERE productid='$productid'");
							$productprice = @mysqli_result($wspriceresult, 0, "wholesaleprice");
						} else $productprice = 0;
						$thisprice = $productprice;
						$totalqty += $thisquantity;
						$subtotal += $thisprice;
						$totalitems += $thisquantity;
						$totalamount += $thisprice;
						$orderid = $row2["orderid"];
						$invoiceid = $row2["invoiceid"];
						$paid = $row2["paid"];
						$timedate = explode(" ", $row2["date"]);
						$date = $timedate[0];
						$time = explode(":",$timedate[1]);
						$comment = trim($row2["comment"]);
						$comment = un_html($comment);
						if ($defaultenclosure == "\"" && strstr($comment,"\"")) $comment = str_replace("\"","\"\"",$comment);
						$thiscustomerid = $row2["$customeridfield"];
						$customername = $row2["firstname"]." ".$row2["lastname"];
						$customername = trim($customername);
						$customeremail = trim($row2["email"]);
						$sql = "SELECT affiliate.affiliateid, affiliate.firstname, affiliate.lastname, affiliate.email FROM $orderafftable, affiliate WHERE $orderafftable.orderid=$orderid AND $orderafftable.affiliateid=affiliate.affiliateid AND ($orderafftable.secondtier=0 OR $orderafftable.secondtier IS NULL)";
						$result3 = @mysqli_query($db, "$sql");
						$affiliatename = @mysqli_result($result3, 0, "firstname")." ".@mysqli_result($result3, 0, "lastname");
						$affiliatename = trim($affiliatename);
						$affiliateemail = @mysqli_result($result3, 0, "email");
						$affiliateid = @mysqli_result($result3, 0, "affiliateid");
						if ($row2["wholesale"]) $ws = " W";
						else if (!$paid && $reporttype != "unpaid") $ws = " U";
						else $ws = "";
						if (!empty($invoiceid)) $orderid = $invoiceid;
						echo "$orderid$ws{$defaultdelimiter}$date{$defaultdelimiter}{$defaultenclosure}$time[0]:$time[1]{$defaultenclosure}{$defaultdelimiter}$thisquantity{$defaultdelimiter}{$defaultenclosure}".number_format($thisprice,$showdecimals,$decimalchar,$thousandchar)."{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$productid:$productname{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$thiscustomerid:$customername [$customeremail]{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}";
						if ($reporttype != "chargebacks" && $affiliateid) echo "$affiliateid:$affiliatename";
						else echo "$comment";
						echo "{$defaultenclosure}\r\n";
					}
				}
			}
		}

	// Other downloadable report...
	} else {
		if ($reporttype == "paid") $paidstring = "paid != ''";
		else if ($reporttype == "unpaid") $paidstring = "paid = ''";
		$sql="SELECT * FROM $ordertable WHERE";
		if ($transtype != "wholesale" && $user > 1) $sql .= " userid $usercheck AND";
		$sql .= " date >= '$fromdate' AND date <= '$todate'";
		if ($ordertypesql && $ordertable != "memberorders") $sql .= $ordertypesql;
		if ($paidcheck && $paidstring) $sql .= " AND $paidstring";
		if ($reporttype == "chargebacks") $sql .= " AND reference != '' AND reference IS NOT NULL AND price < 0";
		$sql .= " ORDER BY $orderby $ascdesc";
		$result = @mysqli_query($db, "$sql");
		for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
			$orderid = @mysqli_result($result, $i, "orderid");
			$invoiceid = @mysqli_result($result, $i, "invoiceid");
			$ipnumber = @mysqli_result($result, $i, "ip");
			$transactionid = @mysqli_result($result, $i, "remoteorderid");
			$payoptionid = @mysqli_result($result, $i, "payoptionid");
			$price = @mysqli_result($result, $i, "price");
			$discount = @mysqli_result($result, $i, "discount");
			$virtualcash = @mysqli_result($result, $i, "virtualcash");
			$discount += $virtualcash;
			$tax = @mysqli_result($result, $i, "tax");
			$wholesale = @mysqli_result($result, $i, "wholesale");
			$paid = @mysqli_result($result, $i, "paid");
			if (substr($tax,0,1) == "c") {
				$taxarray = explode("|",$tax);
				$gst = $taxarray[1];
				$pst = $taxarray[2];
				$tax = "";
			} else {
				$gst = "";
				$pst = "";
			}
			$shipping = @mysqli_result($result, $i, "shipping");
			if (empty($shipping)) $shipping = 0.00;
			$reference = @mysqli_result($result, $i, "reference");
			$subtotal += $price;
			$timedate = explode(" ", @mysqli_result($result, $i, "date"));
			$date = $timedate[0];
			$time = explode(":",$timedate[1]);
			$descriptionstring = trim(@mysqli_result($result, $i, "description"));
			$descriptionstring = un_html($descriptionstring);
			$descriptionstring = str_replace("\r\n",",",$descriptionstring);
			$descriptionstring = str_replace("\n",",",$descriptionstring);
			if ($defaultenclosure == "\"" && strstr($descriptionstring,"\"")) $descriptionstring = str_replace("\"","\"\"",$descriptionstring);
			if ($reference && $price < 0) {
				$referenceresult = @mysqli_query($db, "SELECT invoiceid FROM orders WHERE orderid='$reference'");
				$referenceid = @mysqli_result($referenceresult, 0, "invoiceid");
				if (empty($referenceid)) $referenceid = $reference;
				$descriptionstring = CHARGEBACKFOR." $referenceid, $descriptionstring";
			}
			$handlingarray = ashop_gethandlingcost(@mysqli_result($result, $i, "products"));
			$totalhandling = $handlingarray["shipping"] + $handlingarray["salestax"] - $handlingarray["discount"];
			$comment = @mysqli_result($result, $i, "comment");
			$thiscustomerid = @mysqli_result($result, $i, "$customeridfield");
			$sql = "SELECT * FROM $customertable WHERE $customeridfield=$thiscustomerid";
			$result3 = @mysqli_query($db, "$sql");
			$customerfirstname = trim(@mysqli_result($result3, 0, "firstname"));
			$customerlastname = trim(@mysqli_result($result3, 0, "lastname"));
			$customeremail = trim(@mysqli_result($result3, 0, "email"));
			$customeraddress = trim(@mysqli_result($result3, 0, "address"));
			$customeraddress = un_html($customeraddress);
			$customeraddress = str_replace("\r\n",",",$customeraddress);
			$customeraddress = str_replace("\n",",",$customeraddress);
			if ($defaultenclosure == "\"" && strstr($customeraddress,"\"")) $customeraddress = str_replace("\"","\"\"",$customeraddress);
			$customercity = trim(@mysqli_result($result3, 0, "city"));
			$customerzip = trim(@mysqli_result($result3, 0, "zip"));
			$customerstate = trim(@mysqli_result($result3, 0, "state"));
			$customercountry = trim(@mysqli_result($result3, 0, "country"));
			$customerphone = trim(@mysqli_result($result3, 0, "phone"));
			$sql = "SELECT affiliate.affiliateid, affiliate.firstname, affiliate.lastname, affiliate.email FROM $orderafftable, affiliate WHERE $orderafftable.orderid=$orderid AND $orderafftable.affiliateid=affiliate.affiliateid AND ($orderafftable.secondtier=0 OR $orderafftable.secondtier IS NULL)";
			$result4 = @mysqli_query($db, "$sql");
			$affiliatename = @mysqli_result($result4, 0, "firstname")." ".@mysqli_result($result4, 0, "lastname");
			$affiliatename = trim($affiliatename);
			$affiliateemail = trim(@mysqli_result($result4, 0, "email"));
			$affiliateid = @mysqli_result($result4, 0, "affiliateid");
			$result5 = @mysqli_query($db, "SELECT name FROM payoptions WHERE payoptionid='$payoptionid'");
			$paymentmethod = trim(@mysqli_result($result5, 0, "name"));
			if ($wholesale) $ws = " W";
			else if (!$paid && $reporttype != "unpaid") $ws = " U";
			else $ws = "";
			if (!empty($invoiceid)) $orderid = $invoiceid;
			echo "$orderid$ws{$defaultdelimiter}{$defaultenclosure}$transactionid{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$paymentmethod{$defaultenclosure}{$defaultdelimiter}$date{$defaultdelimiter}{$defaultenclosure}$time[0]:$time[1]{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$descriptionstring{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}".number_format($price+$discount-$shipping-$tax-$gst-$pst,$showdecimals,$decimalchar,$thousandchar).$defaultenclosure.$defaultdelimiter.$defaultenclosure.number_format($shipping,$showdecimals,$decimalchar,$thousandchar).$defaultenclosure.$defaultdelimiter.$defaultenclosure;
			if ($tax) echo number_format($tax,$showdecimals,$decimalchar,$thousandchar);
			else if ($gst || $pst) {
				if ($gst) echo number_format($gst,$showdecimals,$decimalchar,$thousandchar)." GST";
				if ($pst) echo " ".number_format($pst,$showdecimals,$decimalchar,$thousandchar)." PST";
			} else echo "0{$decimalchar}00";
			echo $defaultenclosure.$defaultdelimiter.$defaultenclosure.number_format($price,$showdecimals,$decimalchar,$thousandchar)."{$defaultenclosure}{$defaultdelimiter}$thiscustomerid{$defaultdelimiter}{$defaultenclosure}$customerfirstname{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$customerlastname{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$customeremail{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$customeraddress{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$customercity{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$customerzip{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$customerstate{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$customercountry{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$customerphone{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}$ipnumber{$defaultenclosure}{$defaultdelimiter}{$defaultenclosure}";
			if ($reporttype != "chargebacks" && $affiliateid) echo "$affiliateid: $affiliatename";
			else echo "$comment";
			echo "{$defaultenclosure}\r\n";
		}
	}

// Show "Please wait" page while completing the search...
} else if (!$showresult) {
	echo "$header
    <section class=\"content-header\"><h1>".GENERATINGREPORT."</h1></section>";
	foreach ($_POST as $field => $value) $getquerystring .= "&$field=$value";
	foreach ($_GET as $field => $value) $getquerystring .= "&$field=$value";
	echo "<meta http-equiv=\"Refresh\" content=\"0; URL=salesreport.php?showresult=true$getquerystring\">$footer";
	exit;
}


// Show report in browser...	
else if ($orderby != "productid" && $orderby != "dproductid" && $orderby != "pproductid") {
	ob_start();
	$ordertable = "orders";
	$customertable = "customer";
	$customeridfield = "customerid";
	$paidcheck = " AND paid != ''";
	if ($transtype == "wholesale") $ordertypesql = " AND wholesale = '1' AND (source != 'Auction' OR source IS NULL)";
	else if ($transtype == "auction") $ordertypesql = " AND source = 'Auction'";
	else if ($transtype == "retail") $ordertypesql = " AND (wholesale IS NULL OR wholesale != '1') AND (source != 'Auction' OR source IS NULL)";
	if ($shippingstatus == "shipped") $shippingstatussql = " AND NOT EXISTS (SELECT * FROM shippingstatus WHERE shippingstatus.orderid=$ordertable.orderid AND status='0' LIMIT 1)";
	else if ($shippingstatus == "unshipped") $shippingstatussql = " AND EXISTS (SELECT * FROM shippingstatus WHERE shippingstatus.orderid=$ordertable.orderid AND status='0' LIMIT 1)";
	else $shippingstatussql = "";
	if ($customerid) {
		$sql="SELECT * FROM $customertable WHERE $customeridfield=$customerid";
		$result = @mysqli_query($db, "$sql");
		$customername = @mysqli_result($result, 0, "firstname")." ".@mysqli_result($result, 0, "lastname");
		$customeremail = @mysqli_result($result, 0, "email");
		$customerstring = " ".THEWORDFOR." $customername, ".CUSTOMERID." $customerid ";
	}
	if (($memberid > 1 && ($userid == "1" || $userid == $memberid)) || $user > 1) {
		$ordertable = "memberorders";
		$usercheck = "='$user'";
		$sql="SELECT * FROM user WHERE userid='$user'";
		$result = @mysqli_query($db, $sql);
		$membername = @mysqli_result($result, 0, "shopname");
		$memberemail = @mysqli_result($result, 0, "email");
		$memberstring = " ".THEWORDFOR." $membername, ".MEMBERID." $user";
		$commissionlevel = @mysqli_result($result, 0, "commissionlevel");
		if (!$commissionlevel) $commissionlevel = $memberpercent;
	} else $usercheck = "LIKE '%|$user|%'";
	if ($reporttype == "paid" || $reporttype == "chargebacks" || $reporttype == "all") $orderafftable = "orderaffiliate";
	else $orderafftable = "pendingorderaff";
	echo "$header
    <section class=\"content-header\"><h1>".SALESREPORT;
	if ($userid == "1") echo " <a href=\"$help1\" target=\"_blank\"><img src=\"images/icon_helpsm.gif\" width=\"15\" height=\"15\" border=\"0\"></a>";
	echo "</h1></section>
    <section class=\"content\">
        <div class=\"row\">
        <div class=\"col-xs-12\">
          <div class=\"box\">
            <div class=\"box-body\">";
	if ($customerstring) {
		if ($reporttype == "wholesale") $editcustomer = "edituser";
		else $editcustomer = "editcustomer";
		echo "
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">$customerstring <a href=\"$editcustomer.php?customerid=$customerid\"><img src=\"images/icon_profile.gif\" alt=\"".PROFILEFOR." $customerid\" title=\"".PROFILEFOR." $customerid\" border=\"0\"></a>";
		if ($userid == "1") echo " <a href=\"$editcustomer.php?customerid=$customerid&remove=True\"><img src=\"images/icon_trash.gif\" alt=\"".DELETECUSTOMER." $customerid ".FROMDB."\" title=\"".DELETECUSTOMER." $customerid ".FROMDB."\" border=\"0\"></a>";
		echo "</h3>
                </div>";
	} else if ($memberstring) {
		echo "
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">$memberstring <a href=\"editmember.php?memberid=$user\"><img src=\"images/icon_profile.gif\" alt=\"".MEMBERPROFILEFOR." $user\" title=\"".MEMBERPROFILEFOR." $user\" border=\"0\"></a>";
		if ($userid == "1") echo "&nbsp;<a href=\"editmember.php?memberid=$user&remove=True\"><img src=\"images/icon_trash.gif\" alt=\"".DELETEMEMBER." $user ".FROMDB."\" title=\"".DELETEMEMBER." $user ".FROMDB."\" border=\"0\"></a>";
		echo "</h3>
                </div>";
	}
	if ($msg == "deleted") echo "
              <div class=\"alert alert-success alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ORDERDELETED."
              </div>";
	else if ($msg == "activated") echo "
              <div class=\"alert alert-success alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ORDERACTIVATIONSENT."
              </div>";
	if ($msg == "remindersent") echo "
              <div class=\"alert alert-success alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".REMINDERSENT."
              </div>";
	echo "
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">";
	if ($transtype == "wholesale") $ordertoptext = WHOLESALE." ";
	else $ordertoptext = "";
	if ($transtype == "auction") $ordertoptext2 = AUCTIONS;
	else $ordertoptext2 = ORDERS;
	if ($shippingstatus == "shipped") $ordertoptext = SHIPPED." {$ordertoptext}";
	else if ($shippingstatus == "unshipped") $ordertoptext = UNSHIPPED." {$ordertoptext}";
	if ($reporttype == "paid") echo PAID." {$ordertoptext}".$ordertoptext2;
	else if ($reporttype == "unpaid") echo UNPAID." {$ordertoptext}".$ordertoptext2;
	else if ($reporttype == "chargebacks") echo "{$ordertoptext}".CHARGEBACKS;
	else echo "{$ordertoptext}".TRANSACTIONS;
	$subtotal = 0;
	if (!$customerid && !$orderid && $memberid <= "1") echo " - ".SMALLFROM." $fromdate ".TO." $todate, ".ORDEREDBY,": ";
	if ($orderby == "date") echo THEWORDDATE;
	else if ($orderby == "price") echo AMOUNT;
	else if ($orderby == "customerid") echo CUSTOMERID;
	else if ($orderby == "orderid") echo ORDERID;
	echo "</h3>
                </div>
              <table class=\"table table-bordered\">
                <thead><tr><th>".THEWORDDATE."</th>
	<th>".ORDERID."</th>
	<th>".PRODUCTS."</th><th>".AMT."</th>";
	if (($memberid > 1 && $userid == "1") || $user > 1) echo "<th>".DISC."</th><th>".SHOPFEE."</th><th>".TOTAL."</th>";
	else echo "<th>".SHP."</th><th>".TAX1."</th><th>".TAX2."</th><th>".DISC."</th><th>".TOTAL."</th>";
	if (!$customerid) echo "<th>".CUSTOMER."</th>";
	if ($userid == "1" && ($transtype != "wholesale" || $wholesaleaffiliate) || ($transtype == "wholesale" && $generate == "Edit")) echo "<th>";
	if ($generate != "Edit" && $userid == "1" && ($transtype != "wholesale" || $wholesaleaffiliate)) echo REFERRED;
	else echo "&nbsp;";
	if ($userid == "1" && ($transtype != "wholesale" || $wholesaleaffiliate) || ($transtype == "wholesale" && $generate == "Edit")) echo "</th>";
	if ($customerid && ($transtype != "wholesale" || $wholesaleaffiliate)) echo "<th>&nbsp;</th>";
	if (($reporttype == "unpaid" || $reporttype == "all") && $generate != "Edit") echo "<th>&nbsp;</th>";
	echo "</tr>
                </thead>
                <tbody>";

	// Get order information from database...
	if ($customerid) {
		$sql="SELECT * FROM $ordertable WHERE $customeridfield='$customerid'";
		if ($transtype != "wholesale" && $user > 1) $sql .= " AND userid $usercheck";
		if ($ordertypesql) $sql .= $ordertypesql;
		if ($shippingstatussql) $sql .= $shippingstatussql;
		$sql .= " AND date != '' ORDER BY date";
	} else if ($orderid) {
		if ($lookup == "true") {
			if ($userid == "1") $sql="SELECT * FROM $ordertable WHERE invoiceid='$orderid'";
			else $sql= "SELECT * FROM $ordertable WHERE invoiceid='$orderid' AND userid $usercheck";
		} else {
			if ($userid == "1") $sql="SELECT * FROM $ordertable WHERE orderid='$orderid'";
			else $sql= "SELECT * FROM $ordertable WHERE orderid='$orderid' AND userid $usercheck";
		}
	}
	else if ($memberid > 1 && ($userid == "1" || $userid == $memberid)) $sql="SELECT * FROM $ordertable WHERE userid $usercheck AND date !=''$paidcheck ORDER BY date";
	else if ($orderby == "affiliate") {
		if ($reporttype == "paid") $paidstring = "$ordertable.paid != ''";
		else if ($reporttype == "unpaid") $paidstring = "$ordertable.paid = ''";
		$sql="SELECT * FROM $ordertable, $orderafftable, affiliate WHERE $ordertable.orderid=$orderafftable.orderid AND $orderafftable.affiliateid=affiliate.affiliateid AND";
		if ($transtype != "wholesale" && $user > 1) $sql .= " $ordertable.userid $usercheck AND";
		$sql .= " $ordertable.date >= '$fromdate' AND $ordertable.date <= '$todate'";
		if ($paidcheck && $paidstring) $sql .= " AND $paidstring";
		if ($reporttype == "chargebacks") $sql .= " AND $ordertable.reference != '' AND $ordertable.reference IS NOT NULL AND $ordertable.price < 0";
		if ($ordertypesql && $userid == "1") $sql .= $ordertypesql;
		if ($shippingstatussql) $sql .= $shippingstatussql;
		if ($userid > "1") {
			if ($transtype == "auction") $sql .= " AND auction='1'";
			else $sql .= " AND (auction='0' OR auction IS NULL)";
		}
		$sql .= " ORDER BY affiliate.lastname, $ordertable.date, $ordertable.orderid $ascdesc";
	}
	else {
		if ($reporttype == "paid") $paidstring = "paid != ''";
		else if ($reporttype == "unpaid") $paidstring = "paid = ''";
		$sql="SELECT * FROM $ordertable WHERE";
		if ($transtype != "wholesale" && $user > 1) $sql .= " userid $usercheck AND";
		$sql .= " date >= '$fromdate' AND date <= '$todate'";
		if ($paidcheck && $paidstring) $sql .= " AND $paidstring";
		if ($reporttype == "chargebacks") $sql .= " AND reference != '' AND reference IS NOT NULL AND price < 0";
		if ($ordertypesql && $userid == "1") $sql .= $ordertypesql;
		if ($shippingstatussql) $sql .= $shippingstatussql;
		if ($userid > "1") {
			if ($transtype == "auction") $sql .= " AND auction='1'";
			else $sql .= " AND (auction='0' OR auction IS NULL)";
		}
		$sql .= " ORDER BY $orderby $ascdesc";
	}
	$result = @mysqli_query($db, "$sql");
	$affiliatecommission = 0.00;
	$paidaffiliatecommission = 0.00;
	for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
		$orderid = @mysqli_result($result, $i, "orderid");
		$invoiceid = @mysqli_result($result, $i, "invoiceid");
		$source = @mysqli_result($result, $i, "source");
		$remoteorderid = @mysqli_result($result, $i, "remoteorderid");
		$paid = @mysqli_result($result, $i, "paid");
		$reference = @mysqli_result($result, $i, "reference");
		if ($paid && !$reference) $ordertype = "paid";
		else if (!$reference) $ordertype = "unpaid";
		else $ordertype = "chargebacks";
		$price = @mysqli_result($result, $i, "price");
		$tax = @mysqli_result($result, $i, "tax");
		$wholesale = @mysqli_result($result, $i, "wholesale");
		$purchaseorder = @mysqli_result($result, $i, "purchaseorder");
		$payoptionid = @mysqli_result($result, $i, "payoptionid");
        $status = @mysqli_result($result, $i, "status");
		$gcorderid = "";
		$paidbystring = "";
		$checkpayoptionresult = @mysqli_query($db, "SELECT gateway FROM payoptions WHERE payoptionid='$payoptionid'");
		$paidby = @mysqli_result($checkpayoptionresult,0,"gateway");
		if ($paidby == "googleco" && !empty($remoteorderid)) $gcorderid = "<br>Google Order:<br><a href=\"https://checkout.google.com/sell/multiOrder?order=$remoteorderid\" target=\"_blank\">$remoteorderid</a>";
		else {
			$gcorderid = "";
			if ($paidby == "stripe" || $paidby == "stripecheckout") {
				$checkifstripe = 1;
				$paidbystring = "<br>Stripe";
				if ($status == "FAILEDCAPTURE") $paidbystring .= "<br><font color=\"red\">Failed capture!</font>";
			} else if ($paidby == "paypalec") {
				$checkifstripe = 0;
				$paidbystring = "<br>PayPal";
			} else {
				$checkifstripe = 0;
				if ($paidby) $paidbystring = "<br>Paid by: $paidby";
			}
		}
		if (substr($tax,0,1) == "c") {
			$taxarray = explode("|",$tax);
			$gst = $taxarray[1];
			$pst = $taxarray[2];
			$tax = "";
		} else {
			$gst = "";
			$pst = "";
		}
		$discount = @mysqli_result($result, $i, "discount");
		$storediscount = @mysqli_result($result, $i, "storediscount");
		$storediscountresult = @mysqli_query($db, "SELECT code FROM storediscounts WHERE discountid='$storediscount'");
		$storediscountcode = @mysqli_result($storediscountresult, 0, "code");
		$virtualcash = @mysqli_result($result, $i, "virtualcash");
		$discount += $virtualcash;
		$discounttotal += $discount;
		$shipping = @mysqli_result($result, $i, "shipping");
		if ($memberid > 1 || $user > 1) {
			$baseprice = $price;
			$membercommission = $baseprice * ($commissionlevel/100);
			$totalcommission += $membercommission;
			$shopfee = $price - $membercommission;
			$totalshopfee += $shopfee;
			if (@mysqli_result($result, $i, "paidtoshop")) $totalpaidtoshop += $membercommission;
			else $totalowedtoshop += $membercommission;
		}
		$checkchargebackresult = @mysqli_query($db, "SELECT * FROM orders WHERE reference='$orderid' AND price < 0");
		if (@mysqli_num_rows($checkchargebackresult)) $checkchargeback = TRUE;
		else $checkchargeback = FALSE;
		$totalamt += $price+$discount-floatval($tax)-floatval($gst)-floatval($pst)-floatval($shipping);
		$subtotal += $price;
		$tax1total += floatval($tax);
		$tax1total += floatval($gst);
		$tax2total += floatval($pst);
		$shiptotal += floatval($shipping);
		$timedate = explode(" ", @mysqli_result($result, $i, "date"));
		$date = $timedate[0];
		$time = explode(":",$timedate[1]);
		$descriptionstring = @mysqli_result($result, $i, "description");
		if ($reference) {
			$referenceresult = @mysqli_query($db, "SELECT invoiceid FROM orders WHERE orderid='$reference'");
			$referenceid = @mysqli_result($referenceresult, 0, "invoiceid");
			if (empty($referenceid)) $referenceid = $reference;
			$comment = str_replace("\r\n", " ", @mysqli_result($result, $i, "comment"));
			$comment = str_replace("\n", " ", $comment);
			$comment = str_replace("\r", " ", $comment);
			$comment = str_replace("'", "&#039;", $comment);
			if ($comment) $descriptionstring = "<a href=\"javascript: void(0)\" onMouseOver=\"window.status='$comment'; return true;\" onMouseOut=\"window.status=window.defaultStatus;\"><img src=\"images/icon_info.gif\" alt=\"$comment\" title=\"$comment\" border=\"0\"></a> <span class=\"text-red\">".CHARGEBACKFOR." $referenceid</span><br>$descriptionstring";
			else $descriptionstring = "<span class=\"text-red\">".CHARGEBACKFOR." $referenceid</span><br>$descriptionstring";
		}
		$displaydescr = "";
		$descrarray = array();
		if (strpos($descriptionstring,",")) $descrarray = explode(",", $descriptionstring);
		else if (strpos($descriptionstring,"\r\n")) $descrarray = explode("\r\n", $descriptionstring);
		else $displaydescr = $descriptionstring;
		if (is_array($descrarray)) foreach ($descrarray as $linenumber=>$line) {
			if (substr($line,0,1) == "-") $line = "<span class=\"text-red\">$line</span>";
			$displaydescr .= $line;
			if ($linenumber < count($descrarray)) $displaydescr .= "<br>";
		}
		$handlingarray = ashop_gethandlingcost(@mysqli_result($result, $i, "products"));
		$totalhandling = $handlingarray["shipping"] + $handlingarray["salestax"] - $handlingarray["discount"];
		$thiscustomerid = @mysqli_result($result, $i, "$customeridfield");
		$sql = "SELECT * FROM $customertable WHERE $customeridfield=$thiscustomerid";
		$result3 = @mysqli_query($db, "$sql");
		$customername = @mysqli_result($result3, 0, "firstname")." ".@mysqli_result($result3, 0, "lastname");
		$customeremail = @mysqli_result($result3, 0, "email");
		if ($generate != "Edit") {
			$sql = "SELECT affiliate.affiliateid, affiliate.firstname, affiliate.lastname, affiliate.email, $orderafftable.commission";
			if ($reporttype != "unpaid") $sql .= ", $orderafftable.paid";
			$sql .= " FROM $orderafftable, affiliate WHERE $orderafftable.orderid=$orderid AND $orderafftable.affiliateid=affiliate.affiliateid AND ($orderafftable.secondtier=0 OR $orderafftable.secondtier IS NULL)";
			$result4 = @mysqli_query($db, "$sql");
			$affiliatename = @mysqli_result($result4, 0, "firstname")." ".@mysqli_result($result4, 0, "lastname");
			$affiliateemail = @mysqli_result($result4, 0, "email");
			$affiliateid = @mysqli_result($result4, 0, "affiliateid");
			$sql = "SELECT commission";
			if ($reporttype != "unpaid") $sql .= ", paid";
			$sql .= " FROM $orderafftable WHERE orderid='$orderid'";
			$result4 = @mysqli_query($db, "$sql");
			while ($affiliatecommissionrow = @mysqli_fetch_array($result4)) {
				$affiliatecommission += $affiliatecommissionrow["commission"];
				if ($affiliatecommissionrow["paid"]) $paidaffiliatecommission += $affiliatecommissionrow["commission"];
			}
		}
		// Check download stats...
		$totaldownloads = 0;
		$downloadsresult = @mysqli_query($db, "SELECT SUM(downloads) AS totaldownloads FROM orderdownloads WHERE orderid='$orderid'");
		$downloadsresult2 = @mysqli_query($db, "SELECT fileid FROM downloadslog WHERE orderid='$orderid'");
		if (@mysqli_num_rows($downloadsresult)) $totaldownloads = @mysqli_result($downloadsresult,0,"totaldownloads");
		if (empty($totaldownloads)) $totaldownloads = 0;
		if ((!empty($totaldownloads) && $totaldownloads > 0) || @mysqli_num_rows($downloadsresult2)) {
			$downloadsstring = " <a href=\"downloadsreport.php?orderid=$orderid\"><img src=\"images/icon_downloadable.gif\" alt=\"$totaldownloads Downloads\" title=\"$totaldownloads Downloads\" style=\"vertical-align: middle;\" /></a>";
		} else $downloadsstring = "";

		echo "<tr><td>$date<br>{$time[0]}:{$time[1]}</td><td>";
		if ($wholesale) {
			$editcustomer = "edituser";
			$ws = "&nbsp;".WHOLESALELETTER;
			if ($purchaseorder) $ws .= "</a> <a href=\"javascript: void(0)\" onMouseOver=\"window.status='$purchaseorder'; return true;\" onMouseOut=\"window.status=window.defaultStatus;\"><img src=\"images/icon_info.gif\" alt=\"$purchaseorder\" title=\"$purchaseorder\" border=\"0\">";
		} else {
			$editcustomer = "editcustomer";
			$ws = "";
		}
		if (empty($invoiceid)) {
			if ($ordertable == "memberorders") {
				$invoiceidresult = @mysqli_query($db, "SELECT invoiceid FROM orders WHERE orderid='$orderid'");
				if (@mysqli_num_rows($invoiceidresult)) $invoiceid = @mysqli_result($invoiceidresult,0,"invoiceid");
				if (empty($invoiceid)) $invoiceid = $orderid;
			} else $invoiceid = $orderid;
		}
		if ($userid == "1" && file_exists("$ashoppath/emerchant/invoices/$orderid") && $source == "eM: Invoice") echo "<a href=\"getinvoice.php?orderid=$orderid\" target=\"_blank\">$invoiceid$ws</a>$gcorderid$paidbystring$downloadsstring";
		else if ($reporttype == "unpaid" && $userid == "1" && file_exists("$ashoppath/emerchant/invoices/$orderid") && $source == "Auction") echo "<a href=\"getinvoice.php?orderid=$orderid\" target=\"_blank\">$invoiceid$ws</a>$gcorderid$paidbystring$downloadsstring";
		else if ($userid == "1" && file_exists("$ashoppath/admin/receipts/$orderid")) echo "<a href=\"getreceipt.php?orderid=$orderid\" target=\"_blank\">$invoiceid$ws</a>$gcorderid$paidbystring$downloadsstring";
		else echo "$invoiceid$ws$gcorderid$paidbystring$downloadsstring";
		echo "</td><td>$displaydescr</td><td>";
		if ($price < 0) echo "<span class=\"text-red\">";
		if ($ordertable == "memberorders") echo number_format($price,$showdecimals,$decimalchar,$thousandchar);
		else echo number_format($price+$discount-floatval($shipping)-floatval($tax)-floatval($gst)-floatval($pst),$showdecimals,$decimalchar,$thousandchar);
		if ($price < 0) echo "</span>";
		echo "</td>";
		if ($ordertable == "memberorders") {
			echo "<td align=\"right\">";
			if ($reference && $price < 0) echo "<span class=\"text-red\">";
			echo "-".number_format($discount,$showdecimals,$decimalchar,$thousandchar);
			if ($reference && $price < 0) echo "</span>";
			echo "</td><td align=\"right\">";
			if ($shopfee < 0 || ($reference && $price < 0)) echo "<span class=\"text-red\">-".number_format($shopfee,$showdecimals,$decimalchar,$thousandchar)."</span>";
			else echo "-".number_format($shopfee,$showdecimals,$decimalchar,$thousandchar);
			echo "</td><td align=\"right\">";
			if ($reference && $price < 0) echo "<span class=\"text-red\">".number_format($membercommission,$showdecimals,$decimalchar,$thousandchar)."</span>";
			else echo number_format($membercommission,$showdecimals,$decimalchar,$thousandchar);
			echo "</td>";
		} else {
			echo "<td>";
			if (empty($shipping)) $shipping = 0.00;
			if ($shipping < 0 || ($reference && $price < 0)) echo "<span class=\"text-red\">";
			echo number_format($shipping,$showdecimals,$decimalchar,$thousandchar);
			if ($shipping < 0 || ($reference && $price < 0)) echo "</span>";
			echo "</td><td align=\"right\">";
			if ($tax < 0 || $gst < 0 || ($reference && $price < 0)) echo "<span class=\"text-red\">";
			if ($tax) echo number_format($tax,$showdecimals,$decimalchar,$thousandchar);
			else if ($gst) echo number_format($gst,$showdecimals,$decimalchar,$thousandchar);
			else echo number_format(0,$showdecimals,$decimalchar,$thousandchar);
			if ($tax < 0 || $gst < 0 || ($reference && $price < 0)) echo "</span>";
			echo "</td><td>";
			if (empty($pst)) $pst = 0.00;
			if ($pst < 0 || ($reference && $price < 0)) echo "<span class=\"text-red\">";
			echo number_format($pst,$showdecimals,$decimalchar,$thousandchar);
			if ($pst < 0 || ($reference && $price < 0)) echo "</span>";
			echo "</td><td>";
			if ($reference && $price < 0) echo "<span class=\"text-red\">";
			if (!empty($storediscountcode)) echo "$storediscountcode:<br>";
			echo "-".number_format($discount,$showdecimals,$decimalchar,$thousandchar);
			if ($reference && $price < 0) echo "</span>";
			echo "</td><td>";
			if ($price < 0) echo "<span class=\"text-red\">".number_format($price,$showdecimals,$decimalchar,$thousandchar)."</span>";
			else echo number_format($price,$showdecimals,$decimalchar,$thousandchar);
			echo "</td>";
		}
		if (($userid == "1" || $dmshowcustomers) && !$customerid) echo "<td>$thiscustomerid: <a href=\"$editcustomer.php?customerid=$thiscustomerid\">$customername</a></td>";
		else if (!$customerid) echo "<td>$thiscustomerid: $customername</td>";
		if ($userid == "1" && ($transtype != "wholesale" || $wholesaleaffiliate) || ($transtype == "wholesale" && $generate == "Edit")) echo "<td>";
		if ($affiliateid && $userid == "1" && $generate != "Edit" && ($transtype != "wholesale" || $wholesaleaffiliate)) {
			echo "$affiliateid: <a href=\"affiliatedetail.php?affiliateid=$affiliateid\">$affiliatename";
		} else if ($userid == "1" && $generate == "Edit") {
			if ($ordertype == "paid" && !$reference) {
				echo "<a href=\"editsales.php?orderid=$orderid&action=updatestatus&salesreport=$reporttype|$fromdate|$todate|$orderby|$ascdesc|$generate\"><img src=\"images/icon_edit.gif\" alt=\"".UPDATESTATUS."\" title=\"".UPDATESTATUS."\" border=\"0\"></a> <a href=\"editsales.php?orderid=$orderid&action=chargeback&salesreport=$reporttype|$fromdate|$todate|$orderby|$ascdesc|$generate\"><img src=\"images/icon_chargeback.gif\" alt=\"".CHARGEBACKORDER."\" title=\"".CHARGEBACKORDER."\" border=\"0\"></a>&nbsp;<a href=\"reactivate.php?orderid=$orderid\"><img src=\"images/icon_reactivate.gif\" alt=\"".REACTIVATEORDER."\" title=\"".REACTIVATEORDER."\" border=\"0\"></a>";
			} else if ($ordertype == "unpaid") {
				echo "<a href=\"editsales.php?orderid=$orderid&action=modify&salesreport=$reporttype|$fromdate|$todate|$orderby|$ascdesc|$generate\"><img src=\"images/icon_edit.gif\" alt=\"".MODIFYORDER."\" title=\"".MODIFYORDER."\" border=\"0\"></a> <a href=\"activate.php?orderid=$orderid&salesreport=$reporttype|$fromdate|$todate|$orderby|$ascdesc|$generate\"><img src=\"images/icon_activatem.gif\" alt=\"".RECORDPAYMENTANDACTIVATE."\" title=\"".RECORDPAYMENTANDACTIVATE."\" border=\"0\"></a> <a href=\"salesadmin.php?remind=$orderid&salesreport=$reporttype|$fromdate|$todate|$orderby|$ascdesc|$generate\"><img src=\"images/icon_remind.gif\" alt=\"".REMINDCUSTOMER."\" title=\"".REMINDCUSTOMER."\" border=\"0\"></a>";
                if (!empty($checkifstripe) && !empty($remoteorderid)) echo " <a href=\"salesadmin.php?stripecancel=$orderid\"><img src=\"images/icon_trash.gif\" alt=\"Cancel Order\" title=\"Cancel Order\" border=\"0\"></a>";
                else echo "<a href=\"editsales.php?action=delete&orderid=$orderid&salesreport=$reporttype|$fromdate|$todate|$orderby|$ascdesc|$generate\"><img src=\"images/icon_trash.gif\" alt=\"".DELETEORDER."\" title=\"".DELETEORDER."\" border=\"0\"></a>";
			}
		} 
		if ($customerid && $paid) {
			echo "<td><a href=\"editsales.php?orderid=$orderid&action=updatestatus&salesreport=$reporttype|$fromdate|$todate|$orderby|$ascdesc|$generate\"><img src=\"images/icon_edit.gif\" alt=\"".UPDATESTATUS."\" title=\"".UPDATESTATUS."\" border=\"0\"></a> <a href=\"reactivate.php?orderid=$orderid\"><img src=\"images/icon_reactivate.gif\" alt=\"".REACTIVATEORDER."\" title=\"".REACTIVATEORDER."\" border=\"0\"></a></td>";
		} else if (!$paid && $generate != "Edit") echo "<td><a href=\"activate.php?orderid=$orderid&salesreport=$reporttype|$fromdate|$todate|$orderby|$ascdesc|$generate\"><img src=\"images/icon_activatem.gif\" alt=\"".RECORDPAYMENTANDACTIVATE."\" title=\"".RECORDPAYMENTANDACTIVATE."\" border=\"0\"></a></td>";
		else if ($reporttype == "all" && $generate != "Edit") echo "<td>&nbsp;</td>";

		if ($userid == "1") echo "</a></td>";
		echo "</tr>";
	}

	echo "<tr><th colspan=\"3\">".TOTALS.":</th>";
	if (($memberid > 1 && $user == "1") || $user > 1) {
		echo "<th>&nbsp;".$currencysymbols[$ashopcurrency]["pre"].number_format($totalamt,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th>&nbsp;-".$currencysymbols[$ashopcurrency]["pre"].number_format($discounttotal,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th> -".number_format($totalshopfee,$showdecimals,$decimalchar,$thousandchar)."</th>
		<th>&nbsp;".$currencysymbols[$ashopcurrency]["pre"].number_format($totalcommission,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th>&nbsp;</th>";
		if (!$customerid && ($userid == "1" || $reporttype == "unpaid")) echo "<th>&nbsp;</th>";
	} else {
		echo "<th>&nbsp;".$currencysymbols[$ashopcurrency]["pre"].number_format($totalamt,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th>
		<th>&nbsp;".$currencysymbols[$ashopcurrency]["pre"].number_format($shiptotal,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th>&nbsp;".$currencysymbols[$ashopcurrency]["pre"].number_format($tax1total,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th>&nbsp;".$currencysymbols[$ashopcurrency]["pre"].number_format($tax2total,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th>&nbsp;-".$currencysymbols[$ashopcurrency]["pre"].number_format($discounttotal,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th>&nbsp;".$currencysymbols[$ashopcurrency]["pre"].number_format($subtotal,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th>";
		if (($transtype != "wholesale" || $wholesaleaffiliate) || !$customerid) echo "<th>&nbsp;</th>";
		if (($transtype != "wholesale" || $wholesaleaffiliate) || ($transtype == "wholesale" && $generate == "Edit")) echo "<th>&nbsp;</th>";
		if (($reporttype == "unpaid" || $reporttype == "all") && $generate != "Edit") echo "<th>&nbsp;</th>";
	}
	echo "</tr></tbody></table>";
	if ($userid > 1) {
		echo "<p>";
		if ($totalpaidtoshop) echo TOTALPAIDTOYOU.": <b>".$currencysymbols[$ashopcurrency]["pre"].number_format($totalpaidtoshop,$showdecimals,$decimalchar,$thousandchar).$currencysymbols[$ashopcurrency]["post"]."</b>";
		echo "<br>";
		if ($totalowedtoshop) echo TOTALOWEDTOYOU.": <b>".$currencysymbols[$ashopcurrency]["pre"].number_format($totalowedtoshop,$showdecimals,$decimalchar,$thousandchar).$currencysymbols[$ashopcurrency]["post"]."</b>";
		echo "<br>";
	}
	if ($generate != "Edit") {
		echo "<p>".AFFILIATECOMMISSION.": <b>".$currencysymbols[$ashopcurrency]["pre"].number_format($affiliatecommission,$showdecimals,$decimalchar,$thousandchar).$currencysymbols[$ashopcurrency]["post"]."</b>, ".PAIDSMALL.": <b>".$currencysymbols[$ashopcurrency]["pre"].number_format($paidaffiliatecommission,$showdecimals,$decimalchar,$thousandchar).$currencysymbols[$ashopcurrency]["post"]."</b></p>";
	}
	echo "</div></div></div></section>$footer";


// Generate a sales report by product and show in browser...
} else if ($orderby == "productid" || $orderby == "dproductid" || $orderby == "pproductid") {
	ob_start();
	$ordertable = "orders";
	$customertable = "customer";
	$customeridfield = "customerid";
	$paidcheck = " AND paid != ''";
	if ($transtype == "wholesale") $ordertypesql = " AND orders.wholesale = '1' AND (orders.source != 'Auction' OR orders.source IS NULL)";
	else if ($transtype == "auction") $ordertypesql = " AND orders.source = 'Auction'";
	else if ($transtype == "retail") $ordertypesql = " AND (orders.wholesale IS NULL OR orders.wholesale != '1') AND (orders.source != 'Auction' OR orders.source IS NULL)";
	if ($shippingstatus == "shipped") $shippingstatussql = " AND NOT EXISTS (SELECT * FROM shippingstatus WHERE shippingstatus.orderid=$ordertable.orderid AND status='0' LIMIT 1)";
	else if ($shippingstatus == "unshipped") $shippingstatussql = " AND EXISTS (SELECT * FROM shippingstatus WHERE shippingstatus.orderid=$ordertable.orderid AND status='0' LIMIT 1)";
	else $shippingstatussql = "";
	if ($reporttype == "paid" || $reporttype == "chargebacks") $orderafftable = "orderaffiliate";
	else $orderafftable = "pendingorderaff";
	$totalamount = 0;
	$totalitems = 0;
	echo "$header
    <section class=\"content-header\"><h1>".SALESREPORT;
	if ($userid == "1") echo " <a href=\"$help1\" target=\"_blank\"><img src=\"images/icon_helpsm.gif\" width=\"15\" height=\"15\" border=\"0\"></a>";
	echo "</h1></section>
    <section class=\"content\">
        <div class=\"row\">
        <div class=\"col-xs-12\">
          <div class=\"box\">
            <div class=\"box-body\">";
	if (!$productid) {
        echo "<div class=\"box-header with-border\">
                    <h3 class=\"box-title\">";
		if ($transtype == "wholesale") $ordertoptext = WHOLESALE." ";
		else $ordertoptext = "";
		if ($shippingstatus == "shipped") $ordertoptext = SHIPPED." {$ordertoptext}";
		else if ($shippingstatus == "unshipped") $ordertoptext = UNSHIPPED." {$ordertoptext}";
		if ($reporttype == "paid") echo PAID." {$ordertoptext}".ORDERS;
		else if ($reporttype == "unpaid") echo UNPAID." {$ordertoptext}".ORDERS;
		else if ($reporttype == "chargebacks") echo "{$ordertoptext}".CHARGEBACKS;
		else echo "{$ordertoptext}".TRANSACTIONS;
		echo " - ".SMALLFROM." $fromdate ".TO." $todate, ".SUBTOTALEDBYPRODUCT."</h3></div>";
		$productlimit = "";
	} else {
		if ($memberid > 1) {
			$sql="SELECT * FROM user WHERE userid='$memberid'";
			$result = @mysqli_query($db, $sql);
			$membername = @mysqli_result($result, 0, "shopname");
			$memberemail = @mysqli_result($result, 0, "email");
			$memberstring = " ".THEWORDFOR." $membername, ".MEMBERID." $user";
			echo "<div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".PAIDORDERS."$memberstring <a href=\"editmember.php?memberid=$user\"><img src=\"images/icon_profile.gif\" alt=\"".MEMBERPROFILEFOR." $user\" title=\"".MEMBERPROFILEFOR." $user\" border=\"0\"></a>";
			if ($userid == "1") echo "&nbsp;<a href=\"editmember.php?memberid=$user&remove=True\"><img src=\"images/icon_trash.gif\" alt=\"".DELETEMEMBER." $user ".FROMDB."\" title=\"".DELETEMEMBER." $user ".FROMDB."\" border=\"0\"></a>";
			echo "</h3></div>";
		}
		$productlimit = " AND productid='$productid'";
	}
	if ($orderby == "productid" || $orderby == "pproductid") {
		if (($memberid > 1 && $userid == "1") || $user > 1) $result = @mysqli_query($db, "SELECT * FROM product WHERE userid='$user'$productlimit AND (prodtype!='content' OR prodtype IS NULL) ORDER BY name $ascdesc");
		else $result = @mysqli_query($db, "SELECT * FROM product WHERE (prodtype!='content' OR prodtype IS NULL)$productlimit ORDER BY name $ascdesc");
	} else if ($orderby == "dproductid") {
		if (($memberid > 1 && $userid == "1") || $user > 1) $result = @mysqli_query($db, "SELECT DISTINCT product.* FROM product, productfiles WHERE product.userid='$user' AND (product.prodtype!='content' OR prodtype IS NULL) AND product.productid=productfiles.productid ORDER BY product.name $ascdesc");
		else $result = @mysqli_query($db, "SELECT DISTINCT product.* FROM product, productfiles WHERE (product.prodtype!='content' OR prodtype IS NULL) AND product.productid=productfiles.productid ORDER BY product.name $ascdesc");
	}
	while($row=@mysqli_fetch_array($result)) {
		$productid=$row["productid"];
		$productname=$row["name"];
		if ($orderby == "pproductid") {
			$checkfiles = @mysqli_query($db, "SELECT * FROM productfiles WHERE productid='$productid'");
			if (@mysqli_num_rows($checkfiles)) $failedfilescheck = TRUE;
			else $failedfilescheck = FALSE;
		}
		if($productid && $productname && !$failedfilescheck) {
			if ($reporttype == "paid") $paidstring = "$ordertable.paid != ''";
			else if ($reporttype == "unpaid") $paidstring = "$ordertable.paid = ''";
			$sql = "SELECT $customertable.*, $ordertable.* FROM $customertable, $ordertable WHERE ($ordertable.products LIKE '%b$productid"."a%' OR $ordertable.products LIKE '%b$productid"."d%') AND $ordertable.$customeridfield = $customertable.$customeridfield";
			if (!$productlimit) $sql .= " AND $ordertable.date >= '$fromdate' AND $ordertable.date <= '$todate'";
			if ($reporttype == "chargebacks") $sql .= " AND $ordertable.reference != '' AND $ordertable.reference AND $ordertable.price < 0";
			if ($paidcheck && $paidstring) $sql .= " AND $paidstring";
			$sql .= $ordertypesql;
			$sql .= $shippingstatussql;
			if ($userid > "1" && !$productid) {
				if ($transtype == "auction") $sql .= " AND auction='1'";
				else $sql .= " AND (auction='0' OR auction IS NULL)";
			}
			$sql .= " ORDER BY $ordertable.date";
			$result2 = @mysqli_query($db, $sql);
			if(@mysqli_num_rows($result2)) {
				$subtotal = 0;
				$totalqty = 0;
				echo "
              <h4>$productname, ".PRODUCTID.": <a href=\"editcatalogue.php?pid=$productid\"> $productid</a></h4>
              <table class=\"table table-bordered\">
                <thead>
                    <tr>
                        <th>".DATETIME."</th><th>".ORDERID."</th><th>".QUANTITY."</th><th>".AMOUNT."</th><th>".CUSTOMER."</th>";
				if ($generate != "Edit" && $transtype != "wholesale") echo "<th>".REFERRED."</th>";
				if ($generate == "Edit") echo "<th></th>";
				echo "</tr>
                </thead>
                <tbody>";
				while($row=@mysqli_fetch_array($result2)) if ($thisquantity=ashop_checkproduct($productid,$row["products"])) {
					$paid = $row["paid"];
					$reference = $row["reference"];
					if ($paid && !$reference) $ordertype = "paid";
					else if (!$reference) $ordertype = "unpaid";
					else $ordertype = "chargebacks";
					$productprices = explode("|",$row["paidproductprices"]);
					if ($row["paidproductprices"] && is_array($productprices)) foreach ($productprices as $pricepart) {
						$thisproductprice = explode(":",$pricepart);
						if ($thisproductprice[0] == $productid) $productprice = $thisproductprice[1];
					} else if ($row["wholesale"]) {
							$wspriceresult = @mysqli_query($db, "SELECT wholesaleprice FROM product WHERE productid='$productid'");
							$productprice = @mysqli_result($wspriceresult, 0, "wholesaleprice");
					} else $productprice = 0;
					$thisprice = $productprice;
					if ($row["reference"] && $row["price"] < 0) $thisprice -= $thisprice*2;
					$totalqty += $thisquantity;
					$subtotal += $thisprice;
					$totalitems += $thisquantity;
					$totalamount += $thisprice;
					$orderid = $row["orderid"];
					$invoiceid = $row["invoiceid"];
					$timedate = explode(" ", $row["date"]);
					$date = $timedate[0];
					$time = explode(":",$timedate[1]);
					$comment = $row["comment"];
					$thiscustomerid = $row["$customeridfield"];
					$customername = $row["firstname"]." ".$row["lastname"];
					$customeremail = $row["email"];
					if ($generate != "Edit") {
						$sql = "SELECT affiliate.affiliateid, affiliate.firstname, affiliate.lastname, affiliate.email FROM $orderafftable, affiliate WHERE $orderafftable.orderid=$orderid AND $orderafftable.affiliateid=affiliate.affiliateid AND ($orderafftable.secondtier=0 OR $orderafftable.secondtier IS NULL)";
						$result3 = @mysqli_query($db, "$sql");
						$affiliatename = @mysqli_result($result3, 0, "firstname")." ".@mysqli_result($result3, 0, "lastname");
						$affiliateemail = @mysqli_result($result3, 0, "email");
						$affiliateid = @mysqli_result($result3, 0, "affiliateid");
					}
					if ($row["wholesale"]) {
						$editcustomer = "edituser";
						$ws = "&nbsp;".WHOLESALELETTER;
						if ($row["purchaseorder"]) $ws .= "</a> <a href=\"javascript: void(0)\" onMouseOver=\"window.status='{$row["purchaseorder"]}'; return true;\" onMouseOut=\"window.status=window.defaultStatus;\"><img src=\"images/icon_info.gif\" alt=\"{$row["purchaseorder"]}\" title=\"{$row["purchaseorder"]}\" border=\"0\">";						
					} else {
						$editcustomer = "editcustomer";
						$ws = "";
					}
					if (empty($invoiceid)) $invoiceid = $orderid;
					echo "<tr><td>$date<br>{$time[0]}:{$time[1]}</td><td>";
					if($userid == "1" && file_exists("$ashoppath/admin/receipts/$orderid")) echo "<a href=\"getreceipt.php?orderid=$orderid\" target=\"_blank\">$invoiceid$ws</a>";
					else if ($userid == "1" && file_exists("$ashoppath/emerchant/invoices/$orderid")) echo "<a href=\"getinvoice.php?orderid=$orderid\" target=\"_blank\">$invoiceid$ws</a>";
					else echo "$invoiceid$ws";
					echo "</td><td>";
					if ($thisquantity < 0 || ($thisprice < 0 && $reference)) echo "<span class=\"text-red\">$thisquantity</span>";
					else echo $thisquantity;
					echo "</td><td>";
					if ($thisquantity < 0 || ($thisprice < 0 && $reference)) echo "<span class=\"text-red\">".number_format($thisprice,$showdecimals,$decimalchar,$thousandchar)."</span></td>";
					else echo number_format($thisprice,$showdecimals,$decimalchar,$thousandchar)."</td>";
					if (!$customerid) echo "<td>$thiscustomerid: <a href=\"$editcustomer.php?customerid=$thiscustomerid\">$customername</a></td>";
					if ($generate != "Edit" && $transtype != "wholesale") {
						echo "<td>";
						if ($affiliateid) echo "$affiliateid: <a href=\"affiliatedetail.php?affiliateid=$affiliateid\">$affiliatename";
						else echo "-";
						echo "</td>";
					} else if ($generate == "Edit") {
						echo "<td>";
						if ($ordertype == "paid") {
							echo "<a href=\"editsales.php?orderid=$orderid&action=updatestatus&salesreport=$reporttype|$fromdate|$todate|$orderby|$ascdesc|$generate\"><img src=\"images/icon_edit.gif\" alt=\"".UPDATESTATUS."\" title=\"".UPDATESTATUS."\" border=\"0\"></a> <a href=\"editsales.php?orderid=$orderid&action=chargeback\"><img src=\"images/icon_chargeback.gif\" alt=\"".CHARGEBACKORDER."\" title=\"".CHARGEBACKORDER."\" border=\"0\"></a>&nbsp;<a href=\"reactivate.php?orderid=$orderid\"><img src=\"images/icon_reactivate.gif\" alt=\"".REACTIVATEORDER."\" title=\"".REACTIVATEORDER."\" border=\"0\"></a>";
						} else if ($ordertype == "unpaid") {
							echo "<a href=\"activate.php?orderid=$orderid\"><img src=\"images/icon_activatem.gif\" alt=\"".RECORDPAYMENTANDACTIVATE."\" title=\"".RECORDPAYMENTANDACTIVATE."\" border=\"0\"></a>";
						}
						echo "</td>";
					}
					echo "</tr>";
				}
				echo "<tr><th>".TOTALS.":</th><th>&nbsp;</th><th>$totalqty</th><th>".$currencysymbols[$ashopcurrency]["pre"].number_format($subtotal,$showdecimals,$decimalchar,$thousandchar).$currencysymbols[$ashopcurrency]["post"]."</th><th>&nbsp;</th>";
				if ($generate == "Edit" || $transtype != "wholesale") echo "<th>&nbsp;</th>";
				echo "</tr></tbody></table>";
			}
		}
	}
	echo "<h4>".TOTALITEMSSOLD.": $totalitems<br>".TOTALSALES.": ".$currencysymbols[$ashopcurrency]["pre"].number_format($totalamount,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</h4></div></div></div></section>$footer";
}

ob_end_flush();
?>