<?php
// AShop
// Copyright 2018 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "config.inc.php";
include "ashopfunc.inc.php";
include "ashopconstants.inc.php";
include "checklogin.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/editproduct.inc.php";
// Get context help for this page...
$contexthelppage = "editproduct";
include "help.inc.php";

// Get information about the product from the database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");
$sql="SELECT * FROM product WHERE productid = '$productid'";
$result = @mysqli_query($db, $sql);
$productname = @mysqli_result($result, 0, "name");
$productcopyof = @mysqli_result($result, 0, "copyof");
$productfeatured = @mysqli_result($result, 0, "featured");
$productowner = @mysqli_result($result, 0, "userid");
$productname = str_replace("\"", "&quot;", $productname);
$productreceipttext = @mysqli_result($result, 0, "receipttext");
$productebayid = @mysqli_result($result, 0, "ebayid");
$productprice = @mysqli_result($result, 0, "price");
$productpricelevels = @mysqli_result($result, 0, "wspricelevels");
$productpricelevels = explode("|",$productpricelevels);
$productdescr = @mysqli_result($result, 0, "description");
$productlicense = @mysqli_result($result, 0, "licensetext");
$productaffcom = explode("a",@mysqli_result($result, 0, "affiliatecom"));
$productaffwscom = explode("a",@mysqli_result($result, 0, "affiliatewscom"));
$productaffcom2 = explode("a",@mysqli_result($result, 0, "affiliatecom2"));
$producttieraffcoms = explode("|",@mysqli_result($result, 0, "affiliatetiercom"));
if (!empty($producttieraffcoms) && is_array($producttieraffcoms)) {
	$producttier2affcom = explode("a",$producttieraffcoms[0]);
	$producttier2affcom2 = explode("a",$producttieraffcoms[1]);
	$producttierlowerby = $producttieraffcoms[2];
}
if (empty($producttierlowerby)) $producttierlowerby = 0;
$productaffrepeat = @mysqli_result($result, 0, "affiliaterepeatcommission");
$productlmgroup = @mysqli_result($result, 0, "listmessengergroup");
$productlmpgroup = @mysqli_result($result, 0, "listmaillist");
$productphpbbgroup = @mysqli_result($result, 0, "phpbbgroup");
$productarpresponder = @mysqli_result($result, 0, "arpresponder");
$productarpreachresponder = @mysqli_result($result, 0, "arpreachresponder");
$productresponder = @mysqli_result($result, 0, "autoresponder");
$productresponderoff = @mysqli_result($result, 0, "autoresponderoff");
$productinfresponder = @mysqli_result($result, 0, "infresponder");
$productinfresponderoff = @mysqli_result($result, 0, "infresponderoff");
$productiemlist = @mysqli_result($result, 0, "iemlist");
$productmcgroup = @mysqli_result($result, 0, "mailchimplist");
$productstatus = @mysqli_result($result, 0, "active");
$productwsstatus = @mysqli_result($result, 0, "wholesaleactive");
$productwsprice = @mysqli_result($result, 0, "wholesaleprice");
$productbilltemplate = @mysqli_result($result, 0, "billtemplate");
$taxable = @mysqli_result($result, 0, "taxable");
// Get eMerchant vendor settings for this product...
$productvendor = @mysqli_result($result, 0, "vendorid");
$productcost = @mysqli_result($result, 0, "cost");
$productrecurringprice = @mysqli_result($result, 0, "recurringprice");
$productrecurringperiod = @mysqli_result($result, 0, "recurringperiod");
if (!empty($productrecurringperiod) && strstr($productrecurringperiod,"|")) {
	$recurringperiodarray = explode("|",$productrecurringperiod);
	$recurringperiod = $recurringperiodarray[0];
	$recurringperiodunits = $recurringperiodarray[1];
} else {
	$recurringperiod = "";
	$recurringperiodunits = "";
}
$productavail = @mysqli_result($result, 0, "avail");
$productinmainshop = @mysqli_result($result, 0, "inmainshop");
if ($productinmainshop) $inmainshop = " checked";
else $inmainshop = "";

// Generate Digital Mall member list if needed...
if ($userid == "1" && file_exists("$ashoppath/members/index.php") && $digitalmall != "OFF") {
	$memberlist = "<select class=\"form-control\" name=\"memberid\"><option value=\"1\"";
	if ($productowner == "1") $memberlist .= " selected";
	$memberlist .= ">".ADMINISTRATOR;
	$result = @mysqli_query($db, "SELECT * FROM user WHERE userid>1 ORDER BY shopname");
	while ($row = @mysqli_fetch_array($result)) {
		$memberlist .= "<option value=\"{$row["userid"]}\"";
		if ($productowner == $row["userid"]) $memberlist .= " selected";
		$memberlist .= ">{$row["shopname"]}";
	}
	$memberlist .= "</select>";
}

// Check for floating price...
$result = @mysqli_query($db, "SELECT * FROM floatingprice WHERE productid='$productid'");
if (@mysqli_num_rows($result)) {
	$row = @mysqli_fetch_array($result);
	$fp_length = $row["length"];
	$fp_lengthseconds = $fp_length;
	$fp_lengthdays = floor($fp_lengthseconds/86400);
	$fp_lengthseconds -= $fp_lengthdays*86400;
	$fp_lengthhours = floor($fp_lengthseconds/3600);
	$fp_lengthseconds -= $fp_lengthhours*3600;
	$fp_lengthminutes = floor($fp_lengthseconds/60);
	$fp_lengthseconds -= $fp_lengthminutes*60;
	$fp_activate = $row["activatetime"];
	$productprice = $row["originalstartprice"];
	$fp_priceincr = $row["priceincrement"];
	$fp_type = $row["type"];
}

// Generate floating price activation time...
if (@mysqli_num_rows($result) || $addfloatingprice) {
	if (!$fp_activate) $fp_activate = time()+$timezoneoffset;
    $fp_activate = date("Y-m-d H:i", $fp_activate);
}

// Detach copy from its original...
if ($detach && $productid) {

	// Make a complete copy of the product...
	$result = @mysqli_query($db, "SELECT * FROM product WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) $row = @mysqli_fetch_array($result, MYSQL_ASSOC);
	if (is_array($row)) {
		$sql = "UPDATE product SET ";
		foreach ($row as $fieldname=>$fieldvalue) {
			if (!get_magic_quotes_runtime()) $fieldvalue = addslashes($fieldvalue);
			if ($fieldname != "productid" && $fieldname != "ordernumber") $sql .= "$fieldname = '$fieldvalue', ";
		}
		$sql = substr($sql,0,-2);
		$sql .= " WHERE productid='$productid'";
		@mysqli_query($db, $sql);

		// Assign a new details URL to this product...
		$olddetailsurl = $row["detailsurl"];
		if (!empty($olddetailsurl)) {
			if (strstr($olddetailsurl,"product=")) $newdetailsurl = str_replace("$productcopyof","$productid",$olddetailsurl);
			else {
				$olddetailsurl = str_replace(".html","",$olddetailsurl);
				$pagenumber = 1;
				$newdetailsurl = $olddetailsurl."_{$pagenumber}.html";
				$checkdetailsurls = @mysqli_query($db, "SELECT productid FROM product WHERE detailsurl='$newdetailsurl'");
				if (@mysqli_num_rows($checkdetailsurls)) {
					$newdetailsurlused = TRUE;
					while ($newdetailsurlused == TRUE) {
						$pagenumber++;
						$newdetailsurl = $olddetailsurl."_$pagenumber";
						$checkdetailsurls = @mysqli_query($db, "SELECT productid FROM product WHERE detailsurl='$newdetailsurl'");
						if (!@mysqli_num_rows($checkdetailsurls)) $newdetailsurlused = FALSE;
					}
				}
			}
			@mysqli_query($db, "UPDATE product SET detailsurl='$newdetailsurl' WHERE productid='$productid'");
		}
	}

	// Copy quantity price settings...
	@mysqli_query($db, "DELETE FROM qtypricelevels WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM qtypricelevels WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		$row = @mysqli_fetch_array($result);
		@mysqli_query($db, "INSERT INTO qtypricelevels (levelprice, levelquantity, productid) VALUES ('{$row["levelprice"]}', '{$row["levelquantity"]}', '$productid')");
	}

	// Copy product inventory...
	@mysqli_query($db, "DELETE FROM productinventory WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM productinventory WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		$row = @mysqli_fetch_array($result);
		@mysqli_query($db, "INSERT INTO productinventory (type, skucode, inventory, productid) VALUES ('{$row["type"]}', '{$row["skucode"]}', '{$row["inventory"]}', '$productid')");
	}

	// Copy product file records...
	@mysqli_query($db, "DELETE FROM productfiles WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM productfiles WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		while ($row = @mysqli_fetch_array($result)) {
			@mysqli_query($db, "INSERT INTO productfiles (fileid, filename, url, productid) VALUES ('{$row["fileid"]}', '{$row["filename"]}', '{$row["url"]}', '$productid')");
			$newfileid = @mysqli_insert_id($db);
			@mysqli_query($db, "UPDATE productfiles SET ordernumber='$newfileid' WHERE id='$newfileid'");
		}
	}

	// Copy product discount...
	@mysqli_query($db, "DELETE FROM discount WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM discount WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		while ($row = @mysqli_fetch_array($result)) {
			@mysqli_query($db, "INSERT INTO discount (code, value, type, onetime, productid, affiliate, customerid) VALUES ('{$row["code"]}', '{$row["value"]}', '{$row["type"]}', '{$row["onetime"]}', '$productid', '{$row["affiliate"]}', '{$row["customerid"]}')");
		}
	}

	// Copy product shipping packages...
	@mysqli_query($db, "DELETE FROM packages WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM packages WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		while ($row = @mysqli_fetch_array($result)) {
			@mysqli_query($db, "INSERT INTO packages (originzip, origincountry, originstate, weight, freightclass, productid) VALUES ('{$row["originzip"]}', '{$row["origincountry"]}', '{$row["originstate"]}', '{$row["weight"]}', '{$row["freightclass"]}', '$productid')");
		}
	}

	// Copy product shipping zone rates...
	@mysqli_query($db, "DELETE FROM zonerates WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM zonerates WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		while ($row = @mysqli_fetch_array($result)) {
			@mysqli_query($db, "INSERT INTO zonerates (zone, rate, productid) VALUES ('{$row["zone"]}', '{$row["rate"]}', '$productid')");
		}
	}

	// Copy product quantity price rates...
	@mysqli_query($db, "DELETE FROM quantityrates WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM quantityrates WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		while ($row = @mysqli_fetch_array($result)) {
			@mysqli_query($db, "INSERT INTO quantityrates (quantity, rate, productid) VALUES ('{$row["quantity"]}', '{$row["rate"]}', '$productid')");
		}
	}

	// Copy product attributes and options...
	$result = @mysqli_query($db, "SELECT * FROM parameters WHERE productid='$productid'");
	if (@mysqli_num_rows($result)) {
		while ($row = @mysqli_fetch_array($result)) {
			$parameterid = $row["parameterid"];
			@mysqli_query($db, "DELETE FROM parametervalues WHERE parameterid='$parameterid'");
			@mysqli_query($db, "DELETE FROM customparametervalues WHERE parameterid='$parameterid'");
		}
	}
	@mysqli_query($db, "DELETE FROM parameters WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM parameters WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		while ($row = @mysqli_fetch_array($result)) {
			@mysqli_query($db, "INSERT INTO parameters (caption, buybuttons, productid) VALUES ('{$row["caption"]}', '{$row["buybuttons"]}', '$productid')");
			$newparameterid = @mysqli_insert_id($db);
			$result2 = @mysqli_query($db, "SELECT * FROM parametervalues WHERE parameterid='{$row["parameterid"]}' ORDER BY valueid ASC");
			while ($row2 = @mysqli_fetch_array($result2)) {
				if ($row2["price"] == NULL) $price = "NULL";
				else $price = "'{$row2["price"]}'";
				@mysqli_query($db, "INSERT INTO parametervalues (parameterid, download, noshipping, notax, nofulfilment, price, value) VALUES ('$newparameterid', '{$row2["download"]}', '{$row2["noshipping"]}', '{$row2["notax"]}', '{$row2["nofulfilment"]}', $price, '{$row2["value"]}')");
				$newvalueid = @mysqli_insert_id($db);
				$oldvalueid = $row2["valueid"];
				$parametervalues["$oldvalueid"] = $newvalueid;
			}
		}
	}

	// Copy product floating price...
	@mysqli_query($db, "DELETE FROM floatingprice WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM floatingprice WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		$row = @mysqli_fetch_array($result);
		@mysqli_query($db, "INSERT INTO floatingprice (length, activatetime, starttime, startprice, originalstartprice, priceincrement, productid, type) VALUES ('{$row["length"]}', '{$row["activatetime"]}', '{$row["starttime"]}', '{$row["startprice"]}', '{$row["startprice"]}', '{$row["priceincrement"]}', '$productid', '{$row["type"]}')");
	}

	// Copy related products...
	@mysqli_query($db, "DELETE FROM relatedproducts WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM relatedproducts WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		while ($row = @mysqli_fetch_array($result)) {
			@mysqli_query($db, "INSERT INTO relatedproducts (relatedproductid, priority, productid) VALUES ('{$row["relatedproductid"]}', '{$row["priority"]}', '$productid')");
		}
	}

	// Copy flags...
	@mysqli_query($db, "DELETE FROM flagvalues WHERE productid='$productid'");
	$result = @mysqli_query($db, "SELECT * FROM flagvalues WHERE productid='$productcopyof'");
	if (@mysqli_num_rows($result)) {
		while ($row = @mysqli_fetch_array($result)) {
			@mysqli_query($db, "INSERT INTO flagvalues (flagid, productid) VALUES ('{$row["flagid"]}', '$productid')");
		}
	}

	// Copy image files...
	ashop_copydir("$ashoppath/prodimg/$productcopyof","$ashoppath/prodimg/$productid");

	@mysqli_query($db, "UPDATE product SET copyof=NULL WHERE productid='$productid'");
	@mysqli_query($db, "DELETE FROM productinventory WHERE productid='$productid'");
	$edited = "";
	$productcopyof = 0;
}

// Handle removal of the product...
if ($remove && $productid) {
	if ($yes) {
       $sql="DELETE FROM product WHERE productid=$productid";
       $result = @mysqli_query($db, $sql);
       $sql="DELETE FROM productcategory WHERE productid=$productid";
       $result = @mysqli_query($db, $sql);
       $sql="DELETE FROM discount WHERE productid=$productid";
       $result = @mysqli_query($db, $sql);
       $sql="DELETE FROM unlockkeys WHERE productid=$productid";
       $result = @mysqli_query($db, $sql);
       $sql="DELETE FROM packages WHERE productid=$productid";
       $result = @mysqli_query($db, $sql);
       $sql="DELETE FROM zonerates WHERE productid=$productid";
       $result = @mysqli_query($db, $sql);
       $sql="DELETE FROM quantityrates WHERE productid=$productid";
       $result = @mysqli_query($db, $sql);
       $sql="DELETE FROM flagvalues WHERE productid=$productid";
       $result = @mysqli_query($db, $sql);
       $sql="DELETE FROM qtypricelevels WHERE productid=$productid";
       $result = @mysqli_query($db, $sql);
       $sql="DELETE FROM productinventory WHERE productid=$productid";
       $result = @mysqli_query($db, $sql);
	   $result = @mysqli_query($db, "SELECT * FROM parameters WHERE productid='$productid'");
	   while ($row = @mysqli_fetch_array($result)) {
		   $parameterid = $row["parameterid"];
		   @mysqli_query($db, "DELETE FROM parametervalues WHERE parameterid='$parameterid'");
		   @mysqli_query($db, "DELETE FROM customparametervalues WHERE parameterid='$parameterid'");
	   }
	   @mysqli_query($db, "DELETE FROM parameters WHERE productid='$productid'");
	   ashop_deleteimages("$ashoppath/prodimg/$productid/");
	   if (is_dir("$ashoppath/previews/$productid")) {
		   $findfile = opendir("$ashoppath/previews/$productid");
		   while (false !== ($foundfile = readdir($findfile))) { 
			   if($foundfile && $foundfile != "." && $foundfile != "..") unlink("$ashoppath/previews/$productid/$foundfile");
			   unset($foundfile);
		   }
		   closedir($findfile);
		   rmdir("$ashoppath/previews/$productid");
		   unset($findfile);
	   }
	   $result = @mysqli_query($db, "SELECT * FROM productfiles WHERE productid='$productid'");
	   while ($row = @mysqli_fetch_array($result)) {
		   $result2 = @mysqli_query($db, "SELECT * FROM productfiles WHERE fileid='{$row["fileid"]}' AND productid!='$productid'");
		   if (!@mysqli_num_rows($result2)) {
			   if (file_exists("$ashopspath/products/{$row["fileid"]}")) unlink("$ashopspath/products/{$row["fileid"]}");
		   }
		   @mysqli_query($db, "DELETE FROM productfiles WHERE productid='$productid'");
	   }
	   $result = @mysqli_query($db, "SELECT * FROM updates WHERE productid='$productid'");
	   while ($row = @mysqli_fetch_array($result)) if (file_exists("$ashopspath/updates/$productid")) unlink("$ashopspath/updates/$productid");
	   @mysqli_query($db, "DELETE FROM updates WHERE productid='$productid'");

	   // If there are copies of this product, the first copy should become the original...
	   $result = @mysqli_query($db, "SELECT * FROM product WHERE copyof='$productid' ORDER BY productid ASC LIMIT 1");
	   $firstcopy = @mysqli_result($result, 0, "productid");
	   @mysqli_query($db, "UPDATE product SET copyof=NULL WHERE productid='$firstcopy'");
	   @mysqli_query($db, "UPDATE product SET copyof='$firstcopy' WHERE copyof='$productid'");

	   header("Location: editcatalogue.php?cat=$cat&search=$search&resultpage=$resultpage&pid=$pid");
    }
	elseif ($no) header("Location: editcatalogue.php?cat=$cat&search=$search&pid=$pid&resultpage=$resultpage");
	else echo "$header
    <section class=\"content-header\"><h1>".REMOVEAPRODUCT."</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"editproduct.php\" method=\"post\">
                <div class=\"box-body\">
                    <div class=\"alert alert-danger\">
                        <h4><i class=\"icon fa fa-ban\"></i> ".THISWILLCOMPLETELYDELETE." <a href=\"editcatalogue.php?pid=$productid&cat=$cat\">$productname</a> ".FROMTHECATALOG."</h4>
                    </div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"no\" value=\"".NO."\">".NO."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"yes\" value=\"".YES."\">".YES."</button>
				</div>
                <input type=\"hidden\" name=\"productid\" value=\"$productid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"search\" value=\"$search\">
                <input type=\"hidden\" name=\"pid\" value=\"$pid\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
                <input type=\"hidden\" name=\"remove\" value=\"True\">
             </form></div></div></div></section>$footer";
} 

// Handle editing of the product...
elseif ($edit && $productid) {

	// Get MailChimp lists if applicable...
	if ($mailchimpapikey) {
		require_once "../includes/MCAPI.class.php";
		$api = new MCAPI($mailchimpapikey);
		$retval = $api->lists();
		if (!$api->errorCode){
			$mcselectstring = "
            <div class=\"form-group\">
                <label for=\"phpbbgroup\"><a href= \"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image1','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image1\" onclick=\"return overlib('$tip1');\" onmouseout=\"return nd();\"></a> ".MAILCHIMPLIST."</label><select class=\"form-control\" name=\"mclist\"><option value=\"0\">".NONE."</option>";
			foreach ($retval['data'] as $list){
				$mcselectstring .= "<option value=\"".$list['id']."\"";
				if ($list['id'] == $productmcgroup) $mcselectstring .= " selected";
				$mcselectstring .= ">".$list['name']."</option>";
			}
			$mcselectstring .= "</select></div>";
		}
	}

	// Get punbb groups if applicable...
	if ($phpbbpath && file_exists("$phpbbpath/config.php")) {
		$fp = fopen ("$phpbbpath/config.php", "r");
		while (!feof($fp)) {
			$buffer = fgets($fp,128);
			if (strpos($buffer, "\$db_host") == 0 && is_integer(strpos($buffer, "\$db_host"))) {
				$phpbbhost = substr($buffer, strpos($buffer, "'")+1);
				$phpbbhost = substr($phpbbhost, 0, strpos($phpbbhost, "'"));
			}
			if (strpos($buffer, "\$db_name") == 0 && is_integer(strpos($buffer, "\$db_name"))) {
				$phpbbname = substr($buffer, strpos($buffer, "'")+1);
				$phpbbname = substr($phpbbname, 0, strpos($phpbbname, "'"));
			}
			if (strpos($buffer, "\$db_username") == 0 && is_integer(strpos($buffer, "\$db_username"))) {
				$phpbbuser = substr($buffer, strpos($buffer, "'")+1);
				$phpbbuser = substr($phpbbuser, 0, strpos($phpbbuser, "'"));
			}
			if (strpos($buffer, "\$db_password") == 0 && is_integer(strpos($buffer, "\$db_password"))) {
				$phpbbpass = substr($buffer, strpos($buffer, "'")+1);
				$phpbbpass = substr($phpbbpass, 0, strpos($phpbbpass, "'"));
			}
			if (strpos($buffer, "\$db_prefix") == 0 && is_integer(strpos($buffer, "\$db_prefix"))) {
				$phpbbtablepref = substr($buffer, strpos($buffer, "'")+1);
				$phpbbtablepref = substr($phpbbtablepref, 0, strpos($phpbbtablepref, "'"));
			}
			if (strpos($buffer, "\$db_type") == 0 && is_integer(strpos($buffer, "\$db_type"))) {
				$phpbbdbms = substr($buffer, strpos($buffer, "'")+1);
				$phpbbdbms = substr($phpbbdbms, 0, strpos($phpbbdbms, "'"));
			}
		}
		fclose ($fp);
		if (stristr($phpbbdbms, "mysql")) {
			@mysqli_close($db);
			$phpbbdb = @mysqli_connect("$phpbbhost", "$phpbbuser", "$phpbbpass", "$phpbbname");
			$sql = "SELECT * FROM $phpbbtablepref"."groups";
			$result = @mysqli_query($phpbbdb, $sql);
			$phpbbselectstring = "";
			if (@mysqli_num_rows($result)) {
				$phpbbselectstring = "
            <div class=\"form-group\">
                <label for=\"phpbbgroup\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3\" onclick=\"return overlib('$tip3');\" onmouseout=\"return nd();\"></a> ".PHPBBUSERGROUP."</label><select class=\"form-control\" name=\"phpbbgroup\"><option value=\"0\">".NONE."</option>";
				for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
					$phpbbgroupid = @mysqli_result($result, $i, "g_id");
					$phpbbgroupname = @mysqli_result($result, $i, "g_title");
					$phpbbselectstring .= "<option value=\"$phpbbgroupid\"";
					if ($phpbbgroupid == $productphpbbgroup) $phpbbselectstring .= " selected";
					$phpbbselectstring .= ">$phpbbgroupname</option>";
				}
				$phpbbselectstring .= "</select></div>";
			}
			@mysqli_close($phpbbdb);
			$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");
		}
    }

// Get Infinity Responder autoresponders if applicable...
if ($infinitypath && file_exists("$infinitypath/config.php")) {
	$fp = fopen ("$infinitypath/config.php", "r");
	while (!feof($fp)) {
		$buffer = fgets($fp,128);
		if (strpos($buffer, "\$MySQL_server") == 0 && is_integer(strpos($buffer, "\$MySQL_server"))) {
			$infinityhost = substr($buffer, strpos($buffer, "'")+1);
			$infinityhost = substr($infinityhost, 0, strpos($infinityhost, "\""));
		}
		if (strpos($buffer, "\$MySQL_database") == 0 && is_integer(strpos($buffer, "\$MySQL_database"))) {
			$infinityname = substr($buffer, strpos($buffer, "'")+1);
			$infinityname = substr($infinityname, 0, strpos($infinityname, "'"));
		}
		if (strpos($buffer, "\$MySQL_user") == 0 && is_integer(strpos($buffer, "\$MySQL_user"))) {
			$infinityuser = substr($buffer, strpos($buffer, "'")+1);
			$infinityuser = substr($infinityuser, 0, strpos($infinityuser, "'"));
		}
		if (strpos($buffer, "\$MySQL_password") == 0 && is_integer(strpos($buffer, "\$MySQL_password"))) {
			$infinitypass = substr($buffer, strpos($buffer, "'")+1);
			$infinitypass = substr($infinitypass, 0, strpos($infinitypass, "'"));
		}
	}
	fclose ($fp);
	$infinitydb = @mysqli_connect("$infinityhost", "$infinityuser", "$infinitypass", "$infinityname");
	$sql = "SELECT * FROM InfResp_responders ORDER BY Name";
	$result = @mysqli_query($infinitydb, $sql);
	$infinityselectstring = "";
	if (@mysqli_num_rows($result)) {
		$infinityselectstring1 = "
            <div class=\"form-group\">
                <label for=\"phpbbgroup\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3b','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3b\" onclick=\"return overlib('$tip3b');\" onmouseout=\"return nd();\"></a> ".ADDTOINFINITYRESPONDER."</label><select class=\"form-control\" name=\"infinityresponder\"><option value=\"0\">".NONE."</option>";
		$infinityselectstring2 = "
            <div class=\"form-group\">
                <label for=\"phpbbgroup\">".REMOVEFROMINFINITYRESPONDER."</label><select class=\"form-control\" name=\"infinityresponderoff\"><option value=\"0\">".NONE."</option>";
		for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
			$infinityrespid = @mysqli_result($result, $i, "ResponderID");
			$infinityrespname = @mysqli_result($result, $i, "Name");
			$infinityselectstring1 .= "<option value=\"$infinityrespid\"";
			$infinityselectstring2 .= "<option value=\"$infinityrespid\"";
			if ($infinityrespid == $productinfresponder) $infinityselectstring1 .= " selected";
			if ($infinityrespid == $productinfresponderoff) $infinityselectstring2 .= " selected";
			$infinityselectstring1 .= ">$infinityrespname</option>";
			$infinityselectstring2 .= ">$infinityrespname</option>";
		}
		$infinityselectstring1 .= "</select></div>";
		$infinityselectstring2 .= "</select></div>";
	}
	@mysqli_close($infinitydb);
	$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");
}

// Get Interspire Email Marketer lists if applicable...
if ($iemurl && $iemuser && $iemtoken) {
	$iemselectstring = "";
	$iemxml = "<xmlrequest><username>$iemuser</username><usertoken>$iemtoken</usertoken><requesttype>lists</requesttype><requestmethod>GetLists</requestmethod><details> </details></xmlrequest>";
	$iemch = @curl_init($iemurl);
	curl_setopt($iemch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($iemch, CURLOPT_POST, 1);
	curl_setopt($iemch, CURLOPT_POSTFIELDS, $iemxml);
	$iemresult = @curl_exec($iemch);
	if($iemresult === false) {}
	else {
		$iemselectstring .= "
            <div class=\"form-group\">
                <label for=\"phpbbgroup\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3d','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3d\" onclick=\"return overlib('$tip3d');\" onmouseout=\"return nd();\"></a> ".EMAILMARKETERLIST."</label><select class=\"form-control\" name=\"iemlist\"><option value=\"0\">".NONE."</option>";
		if (strpos($iemresult,"<item>")) {
			$iemresultarray = explode("<item>",$iemresult);
			foreach($iemresultarray as $iempartnumber=>$iemxmlpart) {
				$iemlistid = 0;
				$iemlistname = "";
				if (strpos($iemxmlpart,"<listid>")) {
					$iemsubresultarray = explode("<listid>",$iemxmlpart);
					$iemsubresultarray = explode("</listid>",$iemsubresultarray[1]);
					$iemlistid = $iemsubresultarray[0];
				}
				if (strpos($iemxmlpart,"<name>")) {
					$iemsubresultarray = explode("<name>",$iemxmlpart);
					$iemsubresultarray = explode("</name>",$iemsubresultarray[1]);
					$iemlistname = $iemsubresultarray[0];
				}
				if ($iemlistid && $iemlistname) {
					$iemselectstring .= "<option value=\"$iemlistid\"";
					if ($iemlistid == $productiemlist) $iemselectstring .= " selected";
					$iemselectstring .= ">$iemlistname</option>";
				}
			}
		}
		$iemselectstring .= "</select></div>";
	}
}

  // Make sure special characters are handled properly...
  $name = str_replace("\"", "&quot;", $name);
  //$name = str_replace("'", "&#039;", $name);
  //$description = str_replace("'", "&#039;", $description);

  // Show edit form...
  if (!$edited || $addlicense || $addfloatingprice || $removefloatingprice || !$name || $price == '') {
	  echo "$header";
	  if (is_dir("$ashoppath/admin/ckeditor") && file_exists("$ashoppath/admin/ckeditor/ckeditor.js")) {
		  echo "
<script type=\"text/javascript\" src=\"ckeditor/ckeditor.js\"></script>
";
	  }
  echo "
    <section class=\"content-header\"><h1>".EDITPRODUCT.": <a href=\"editcatalogue.php?pid=$productid&cat=$cat\">$productname</a></h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"editproduct.php\" method=\"post\" enctype=\"multipart/form-data\" name=\"productform\">
                <div class=\"box-body\">";
		echo "
                    <div class=\"form-group\"><label><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image0','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image0\" align=\"absmiddle\" onclick=\"return overlib('$tip0');\" onmouseout=\"return nd();\"></a> ".PRODUCTID.": $productid</label></div>";
		if ($productcopyof) echo "<p>".COPYOFPRODUCT.": $productcopyof <input type=\"submit\" name=\"detach\" value=\"".DETACH."\">";
		echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => NAME, "name" => "name", "value" => $productname, "helpnumber" => 4, "helptext" => $tip4))."</div>";
		if ($userid == "1" && file_exists("$ashoppath/members/index.php") && $digitalmall != "OFF") {
			echo "
                    <div class=\"form-group\">
                        <label for=\"memberid\">".OWNERMEMBER.":</label>$memberlist
                    </div>";
			if ($productowner > 1) echo "<tr><td align=\"right\" class=\"formlabel\">".VISIBLEINMAINSHOP.":</td><td align=\"left\"><input type=\"checkbox\" name=\"activateinmainshop\"$inmainshop></td></tr>";
		}
		echo "
                    <div class=\"form-group\"><label><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image5','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image5\" align=\"absmiddle\" onclick=\"return overlib('$tip5');\" onmouseout=\"return nd();\"></a> ".CATALOGSTATUS."</label>
                    ";
		if ($userid == "1") {
                    if($wholesalecatalog && (!$addfloatingprice && (!$fp_length || $removefloatingprice))) echo admin_checkbox(array("label" => ACTIVE." ".RETAIL, "name" => "active", "checked" => $productstatus == 1?TRUE:FALSE)).admin_checkbox(array("label" => WHOLESALE, "name" => "wholesale", "checked" => $productwsstatus == 1?TRUE:FALSE));
                    else echo admin_checkbox(array("label" => ACTIVE." ".RETAIL, "name" => "active", "checked" => $productstatus == 1?TRUE:FALSE));
        } else {
			if ($productstatus) echo ACTIVE;
			else echo INACTIVE;
		}
        echo "
                    </div>";

		if ($userid == "1") {
			echo "
                    <div class=\"form-group\">
                        <label for=\"featured\">".FEATUREDSPOT."</label>
                        <select class=\"form-control\" name=\"featured\"><option value=\"0\""; if (!$productfeatured) echo " selected"; echo ">".NO."</option>";
			for ($featuredspot = 1; $featuredspot <= $numberoffeatures; $featuredspot++) {
				echo "<option value=\"$featuredspot\"";
				if ($productfeatured == $featuredspot) echo " selected";
				echo ">$featuredspot</option>";
			}
			echo "</select></div>";
		}
		if ($userid == "1") echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => EBAYID, "name" => "ebayid", "value" => $productebayid, "helpnumber" => 6, "helptext" => $tip6, "helplink" => $help6, "explanation" => OPTIONAL))."</div>";

		// Show price parameters...        
		if ($addfloatingprice || ($fp_length && !$removefloatingprice)) {
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => STARTPRICE, "name" => "price", "value" => number_format($productprice,$showdecimals,$decimalchar,$thousandchar), "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>
                    <div class=\"form-group\"><input type=\"hidden\" name=\"removefloatingprice\" value=\"\">
                    <button type=\"submit\" class=\"btn btn-primary btn-block\" value=\"".FIXEDPRICE."\" onClick=\"document.productform.removefloatingprice.value='true';document.productform.submit();\">".FIXEDPRICE."</button></div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => BIDINCREMENT, "name" => "priceincrement", "value" => number_format($fp_priceincr,$showdecimals,$decimalchar,$thousandchar), "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LENGTH, "name" => "bidlengthdays", "value" => $fp_lengthdays, "suffix" => DAYS))
                    .admin_inputfield(array("name" => "bidlengthhours", "value" => $fp_lengthhours, "suffix" => HOURS))
                    .admin_inputfield(array("name" => "bidlengthminutes", "value" => $fp_lengthminutes, "suffix" => MINUTES))
                    .admin_inputfield(array("name" => "bidlengthseconds", "value" => $fp_lengthseconds, "suffix" => SECONDS))."
                    </div>
                    <div class=\"form-group\"><label>".ACTIVATE."</label>
                    <div class=\"input-group date\">
                        <div class=\"input-group-addon\">
                            <i class=\"fa fa-calendar\"></i>
                        </div>
                        <input type=\"text\" class=\"form-control pull-right\" id=\"activatedate\" name=\"activatedate\" value=\"$fp_activate\">
                    </div>
                    </div>
                    <div class=\"form-group\"><label for=\"auctiontype\">".AUCTIONTYPE."</label><select name=\"auctiontype\" class=\"form-control\"><option value=\"standard\""; if($fp_type == "standard") echo " selected"; echo ">".STANDARD."</option><option value=\"penny\""; if($fp_type == "penny") echo " selected"; echo ">".PENNY."</option></select></div>";
                    $pagescript = "
                    <script>
                        $(function () {
                            $('#activatedate').daterangepicker({ singleDatePicker: true, timePicker: true, timePickerIncrement: 5, timePicker24Hour: true, locale: { format: 'YYYY-MM-DD HH:mm' }});
                        })
                    </script>";
		} else {
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => PRICE, "name" => "price", "value" => number_format($productprice,$showdecimals,$decimalchar,$thousandchar), "helpnumber" => 7, "helptext" => $tip7, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>
                    <input type=\"hidden\" name=\"addfloatingprice\" value=\"\">
                    <div class=\"form-group\"><button type=\"submit\" class=\"btn btn-primary btn-block\" value=\"".AUCTION."\" onClick=\"document.productform.addfloatingprice.value='true';document.productform.submit();\">".AUCTION."</button>
                    </div>";
		}

		if ($wholesalecatalog && ($advancedmallmode == "1" || $userid == "1")) {
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => WHOLESALEPRICE, "name" => "wholesaleprice", "value" => number_format($productwsprice,$showdecimals,$decimalchar,$thousandchar), "helpnumber" => 8, "helptext" => $tip8, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>";
			if ($pricelevels > 1) {
				for ($thislevel = 2; $thislevel <= $pricelevels; $thislevel++) {
					if (empty($productpricelevels[$thislevel-2])) $productpricelevels[$thislevel-2] = 0.00;
					echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => WHOLESALEPRICELEVEL." $thislevel", "name" => "wholesaleprice$thislevel", "value" => number_format($productpricelevels[$thislevel-2],$showdecimals,$decimalchar,$thousandchar), "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>";
				}
			}
		}
		if ($userid == "1" && file_exists("$ashoppath/emerchant/quote.php")) $billtemplateresult = @mysqli_query($db, "SELECT * FROM emerchant_billtemplates ORDER BY name");
		$recurringresult = @mysqli_query($db, "SELECT * FROM payoptions WHERE gateway='ccbill' OR gateway='paypal' OR gateway='paypalsandbox' OR gateway='payza' OR gateway='netbillingrecurring'");
		if (@mysqli_num_rows($billtemplateresult) || @mysqli_num_rows($recurringresult)) {
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => RECURRINGPRICE, "name" => "recurringprice", "value" => number_format($productrecurringprice,$showdecimals,$decimalchar,$thousandchar), "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>";
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => RECURRINGPERIOD, "name" => "nrecurringperiod", "value" => $recurringperiod, "suffix" => DAYS))."
                    <select name=\"nrecurringperiodunits\" class=\"form-control\"><option value=\"D\""; if ($recurringperiodunits == "D") echo " selected"; echo ">".DAYS."</option><option value=\"W\""; if ($recurringperiodunits == "W") echo " selected"; echo ">".WEEKS."</option><option value=\"M\""; if ($recurringperiodunits == "M") echo " selected"; echo ">".MONTHS."</option><option value=\"Y\""; if ($recurringperiodunits == "Y") echo " selected"; echo ">".YEARS."</option></select>
                    </div>";
		}
		if ($userid == "1" && @mysqli_num_rows($billtemplateresult)) {
			echo "
                    <div class=\"form-group\">
                        <label for=\"billtemplate\">".BILLINGTEMPLATE."</label>
                        <select name=\"billtemplate\" class=\"form-control\"><option value=\"none\"";
			if (!$productbilltemplate) echo " selected";
			echo ">".NONE;
			while ($billtemplaterow = @mysqli_fetch_array($billtemplateresult)) {
				$billtemplatename = $billtemplaterow["name"];
				$billtemplateid = $billtemplaterow["billtemplateid"];
				echo "<option value=\"$billtemplateid\"";
				if ($productbilltemplate == $billtemplateid) echo " selected";
				echo ">$billtemplatename";
			}
			echo "</select></div>";
		}
		echo "
                    <div class=\"form-group\">".admin_textbox(array("label" => RECEIPTTEXT, "name" => "receipttext", "value" => htmlentities(stripslashes($productreceipttext), ENT_QUOTES)))."</div>
                    <div class=\"form-group\">".admin_textbox(array("label" => DESCRIPTION, "name" => "description", "value" => htmlentities(stripslashes($productdescr), ENT_QUOTES), "WYSIWYG" => TRUE, "helpnumber" => 9, "helptext" => $tip9))."</div>";
		if (is_dir("$ashoppath/admin/ckeditor") && file_exists("$ashoppath/admin/ckeditor/ckeditor.js")) echo "<script type=\"text/javascript\">
		CKEDITOR.replace( 'description', {
			// Define the toolbar groups as it is a more accessible solution.
			toolbarGroups: [
				{\"name\":\"basicstyles\",\"groups\":[\"basicstyles\"]},
				{\"name\":\"links\",\"groups\":[\"links\"]},
				{\"name\":\"paragraph\",\"groups\":[\"list\",\"blocks\"]},
				{\"name\":\"document\",\"groups\":[\"mode\"]},
				{\"name\":\"insert\",\"groups\":[\"insert\"]},
				{\"name\":\"styles\",\"groups\":[\"styles\"]},
				{\"name\":\"colors\",\"groups\":[\"colors\"]}
			],
			// Remove the redundant buttons from toolbar groups defined above.
			removeButtons: 'Underline,Strike,Subscript,Superscript,Anchor,Styles,Specialchar'
		} );
		</script>";
		echo "
                    <div class=\"form-group\">
                        <label for=\"licensetext\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image10','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image10\" align=\"absmiddle\" onclick=\"return overlib('$tip10');\" onmouseout=\"return nd();\"></a> <a href=\"$help10\" class=\"helpnav2\" target=\"_blank\">".LICENSEAGREEMENT."</a></label>";
		if ($addlicense || $productlicense) echo "<textarea class=\"form-control\" name=\"licensetext\" id=\"licensetext\">".htmlentities(stripslashes($productlicense), ENT_QUOTES)."</textarea>";
		else echo "<input type=\"hidden\" name=\"addlicense\" value=\"\">
        <button type=\"submit\" class=\"btn btn-primary btn-block\" value=\"".ADDLICENSEAGREEMENT."\" onClick=\"document.productform.addlicense.value='true';document.productform.submit();\">".ADDLICENSEAGREEMENT."</button>";
		echo "</div>";
        $radioaddon = "
                        <label><input type=\"radio\" name=\"affcomtype\" value=\"percent\"";
		if ($productaffcom[1]=="percent" || !$productaffcom[1]) $radioaddon .= "checked";
		$radioaddon .= "> %</label>
                        <label><input type=\"radio\" name=\"affcomtype\" value=\"money\"";
		if ($productaffcom[1]=="money") $radioaddon .= "checked";
		$radioaddon .= "> ";
		if ($currencysymbols[$ashopcurrency]["pre"]) $radioaddon .= $currencysymbols[$ashopcurrency]["pre"];
		else if ($currencysymbols[$ashopcurrency]["post"]) $radioaddon .= $currencysymbols[$ashopcurrency]["post"];
        $radioaddon .= "</label>";
        if ($productaffcom[1]) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => AFFILIATECOMMISSION, "name" => "affiliatecom", "value" => $productaffcom[0], "helpnumber" => 14, "helptext" => $tip14, "helplink" => $help14, "suffix" => $radioaddon))."</div>";
		else echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => AFFILIATECOMMISSION, "name" => "affiliatecom", "value" => $affiliatepercent, "helpnumber" => 14, "helptext" => $tip14, "helplink" => $help14, "suffix" => $radioaddon))."</div>";
		if ($wholesaleaffiliate == "1") {
            $radioaddon = "
                        <label><input type=\"radio\" name=\"affwscomtype\" value=\"percent\"";
			if ($productaffwscom[1]=="percent" || !$productaffcom[1]) $radioaddon .= "checked";
			$radioaddon .= "> %</label>
                        <label><input type=\"radio\" name=\"affwscomtype\" value=\"money\"";
			if ($productaffwscom[1]=="money") $radioaddon .= "checked";
			$radioaddon .= "> ";
            if ($currencysymbols[$ashopcurrency]["pre"]) $radioaddon .= $currencysymbols[$ashopcurrency]["pre"];
            else if ($currencysymbols[$ashopcurrency]["post"]) $radioaddon .= $currencysymbols[$ashopcurrency]["post"];
            $radioaddon .= "</label>";
			if ($productaffwscom[1]) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => WSAFFILIATECOMMISSION, "name" => "affiliatewscom", "value" => $productaffwscom[0], "suffix" => $radioaddon))."</div>";
			if ($productaffwscom[1]) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => WSAFFILIATECOMMISSION, "name" => "affiliatewscom", "value" => $wholesalepercent, "suffix" => $radioaddon))."</div>";
		}

		if ($userid == "1") {
            $radioaddon = "
                        <label><input type=\"radio\" name=\"affcomtype2\" value=\"percent\"";
			if ($productaffcom2[1]=="percent" || !$productaffcom2[1]) $radioaddon .= "checked";
			$radioaddon .= "> %</label>
                        <label><input type=\"radio\" name=\"affcomtype2\" value=\"money\"";
			if ($productaffcom2[1]=="money") $radioaddon .= "checked";
			$radioaddon .= "> ";
            if ($currencysymbols[$ashopcurrency]["pre"]) $radioaddon .= $currencysymbols[$ashopcurrency]["pre"];
            else if ($currencysymbols[$ashopcurrency]["post"]) $radioaddon .= $currencysymbols[$ashopcurrency]["post"];
            $radioaddon .= "</label>";
			if ($producttier2affcom[1]) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => UPGRADEDAFFILIATECOMMISSION, "name" => "affiliatecom2", "value" => $productaffcom2[0], "suffix" => $radioaddon))."</div>";
            else echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => UPGRADEDAFFILIATECOMMISSION, "name" => "affiliatecom2", "value" => $affiliatepercent2, "suffix" => $radioaddon))."</div>";
            $radioaddon = "
                        <label><input type=\"radio\" name=\"afftier2comtype\" value=\"percent\"";
			if ($producttier2affcom[1]=="percent" || !$producttier2affcom[1]) $radioaddon .= "checked";
			$radioaddon .= "> %</label>
                        <label><input type=\"radio\" name=\"afftier2comtype\" value=\"money\"";
			if ($producttier2affcom[1]=="money") $radioaddon .= "checked";
			$radioaddon .= "> ";
            if ($currencysymbols[$ashopcurrency]["pre"]) $radioaddon .= $currencysymbols[$ashopcurrency]["pre"];
            else if ($currencysymbols[$ashopcurrency]["post"]) $radioaddon .= $currencysymbols[$ashopcurrency]["post"];
            $radioaddon .= "</label>";
			if ($producttier2affcom[1]) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => TIER2COMMISSION, "name" => "affiliatetier2com", "value" => $producttier2affcom[0], "suffix" => $radioaddon))."</div>";
			else echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => TIER2COMMISSION, "name" => "affiliatetier2com", "value" => $secondtierpercent, "suffix" => $radioaddon))."</div>";
            $radioaddon = "
                        <label><input type=\"radio\" name=\"afftier2comtype2\" value=\"percent\"";
			if ($producttier2affcom2[1]=="percent" || !$producttier2affcom2[1]) $radioaddon .= "checked";
			$radioaddon .= "> %</label>
                        <label><input type=\"radio\" name=\"afftier2comtype2\" value=\"money\"";
			if ($producttier2affcom2[1]=="money") $radioaddon .= "checked";
			$radioaddon .= "> ";
            if ($currencysymbols[$ashopcurrency]["pre"]) $radioaddon .= $currencysymbols[$ashopcurrency]["pre"];
            else if ($currencysymbols[$ashopcurrency]["post"]) $radioaddon .= $currencysymbols[$ashopcurrency]["post"];
            $radioaddon .= "</label>";
			if ($producttier2affcom2[1]) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => UPGRADEDTIER2COMMISSION, "name" => "affiliatetier2com2", "value" => $producttier2affcom2[0], "suffix" => $radioaddon))."</div>";
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => UPGRADEDTIER2COMMISSION, "name" => "affiliatetier2com2", "value" => $secondtierpercent2, "suffix" => $radioaddon))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LOWERBY, "name" => "affiliatetierlowerby", "value" => $producttierlowerby, "suffix" => ONEACHTIER, "explanation" => DISABLEMULTITIER))."</div>
                    <div class=\"form-group\">
                        <label for=\"affiliaterepeatcommission\">".ONREPEATORDERS."</label>
                        <select name=\"affiliaterepeatcommission\" class=\"form-control\"><option value=\"1\""; if ($productaffrepeat == "1") echo " selected"; echo ">Yes</option><option value=\"0\""; if ($productaffrepeat == "0") echo " selected"; echo ">No</option></select>
                    </div>
                    <div class=\"form-group\">
                        <label for=\"taxable\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image15','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image15\" align=\"absmiddle\" onclick=\"return overlib('$tip15');\" onmouseout=\"return nd();\"></a> ".SALESTAX."</label>
                        <select name=\"istaxable\" class=\"form-control\"><option value=\"0\""; if ($taxable == "0") echo " selected"; echo ">".NO."<option value=\"1\""; if ($taxable == "1") echo " selected"; echo ">".YES."<option value=\"2\""; if ($taxable == "2") echo " selected"; echo ">".LEVEL2."</select>
                    </div>";
			if ($activateautoresponder == "1" && !empty($autoresponderid) && is_numeric($autoresponderid)) {
				$sql = "SELECT * FROM autoresponders ORDER BY name";
				$result = @mysqli_query($db, $sql);
				if (@mysqli_num_rows($result)) {
					echo "
                    <div class=\"form-group\">
                        <label for=\"autoresponder\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3c','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3c\" align=\"absmiddle\" onclick=\"return overlib('$tip3c');\" onmouseout=\"return nd();\"></a> ".ADDTOAUTORESPONDER."</label>
                        <select class=\"form-control\" name=\"autoresponder\"><option value=\"0\"";
					if ($productresponder == "0") echo " selected";
					echo ">".NONE."</option>";
					for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
						$responderid = @mysqli_result($result, $i, "responderid");
						$respondername = @mysqli_result($result, $i, "name");
						echo "<option value=\"$responderid\"";
						if ($productresponder == $responderid) echo " selected";
						echo ">$respondername</option>";
					}
					echo "</select></div>
                    <div class=\"form-group\">
                        <label for=\"autoresponderoff\">".REMOVEFROMAUTORESPONDER."</label>
                        <select class=\"form-control\" name=\"autoresponderoff\"><option value=\"0\"";
					if ($productresponderoff == "0") echo " selected";
					echo ">".NONE."</option>";
					for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
						$responderid = @mysqli_result($result, $i, "responderid");
						$respondername = @mysqli_result($result, $i, "name");
						echo "<option value=\"$responderid\"";
						if ($productresponderoff == $responderid) echo " selected";
						echo ">$respondername</option>";
					}
					echo "</select></div>";
				}
			} else if (!empty($aweberauthcode)) {
				$sql = "SELECT * FROM autoresponders ORDER BY name";
				$result = @mysqli_query($db, $sql);
				if (@mysqli_num_rows($result)) {
					echo "
                    <div class=\"form-group\">
                        <label for=\"autoresponderoff\">AWeber List:</label>
                        <select class=\"form-control\" name=\"autoresponder\"><option value=\"0\">".NONE."</option>";
					for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
						$responderid = @mysqli_result($result, $i, "responderid");
						$respondername = @mysqli_result($result, $i, "name");
						echo "<option value=\"$responderid\"";
						if ($productresponder == $responderid) echo " selected";
						echo ">$respondername</option>";
					}
					echo "</select></div>";
				}
			}
			if ($infinityselectstring1) echo $infinityselectstring1;
			if ($infinityselectstring2) echo $infinityselectstring2;
			if ($mcselectstring) echo $mcselectstring;
			if ($iemselectstring) echo $iemselectstring;
			if ($phpbbselectstring) echo $phpbbselectstring;
		}
		echo "
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-primary pull-right\" value=\"".SUBMIT."\" name=\"submitbutton\">".SUBMIT."</button>
				</div>
                <input type=\"hidden\" name=\"edit\" value=\"True\"><input type=\"hidden\" name=\"edited\" value=\"True\"><input type=\"hidden\" name=\"productid\" value=\"$productid\"><input type=\"hidden\" name=\"cat\" value=\"$cat\"><input type=\"hidden\" name=\"search\" value=\"$search\"><input type=\"hidden\" name=\"pid\" value=\"$pid\"><input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\"><input type=\"hidden\" name=\"copyof\" value=\"$productcopyof\">
             </form></div></div></div></section>";
        $footer = str_replace("<!-- pagescript -->", $pagescript, $footer);
		echo $footer;
  }
  else {
	// Reset the featured spot...
	if ($userid == "1" && $featured > 0) @mysqli_query($db, "UPDATE product SET featured='0' WHERE featured='$featured'");

	// Convert money format...
	$price = str_replace($thousandchar,"",$price);
	$price = str_replace($decimalchar,".",$price);
	$wholesaleprice = str_replace($thousandchar,"",$wholesaleprice);
	$wholesaleprice = str_replace($decimalchar,".",$wholesaleprice);
	$wspricelevels = "";
	if ($pricelevels > 1) {
		for ($thislevel = 2; $thislevel <= $pricelevels; $thislevel++) {
			$thislevelprice = $_POST["wholesaleprice$thislevel"];
			$thislevelprice = str_replace($thousandchar,"",$thislevelprice);
			$thislevelprice = str_replace($decimalchar,".",$thislevelprice);
			$wspricelevels .= $thislevelprice."|";
		}
		$wspricelevels = substr($wspricelevels,0,-1);
	}
	$priceincrement = str_replace($thousandchar,"",$priceincrement);
	$priceincrement = str_replace($decimalchar,".",$priceincrement);
	$recurringprice = str_replace($thousandchar,"",$recurringprice);
	$recurringprice = str_replace($decimalchar,".",$recurringprice);
	$affiliatecom = str_replace($thousandchar,"",$affiliatecom);
	$affiliatecom = str_replace($decimalchar,".",$affiliatecom);
	$affiliatewscom = str_replace($thousandchar,"",$affiliatewscom);
	$affiliatewscom = str_replace($decimalchar,".",$affiliatewscom);
	$affiliatecom2 = str_replace($thousandchar,"",$affiliatecom2);
	$affiliatecom2 = str_replace($decimalchar,".",$affiliatecom2);
	$affiliatetier2com = str_replace($thousandchar,"",$affiliatetier2com);
	$affiliatetier2com = str_replace($decimalchar,".",$affiliatetier2com);
	$affiliatetier2com2 = str_replace($thousandchar,"",$affiliatetier2com2);
	$affiliatetier2com2 = str_replace($decimalchar,".",$affiliatetier2com2);
	$affiliatetierlowerby = str_replace($thousandchar,"",$affiliatetierlowerby);
	$affiliatetierlowerby = str_replace($decimalchar,".",$affiliatetierlowerby);	

	// Check max affiliate commission for member products...
	if ($userid != "1") {
		if ($affiliatecom && $affcomtype == "money") {
			$memberresult = @mysqli_query($db, "SELECT commissionlevel FROM user WHERE userid='$userid'");
			$commissionlevel = @mysqli_result($memberresult, 0, "commissionlevel");
			if ($commissionlevel > 75) $commissionlevel = 75;
			$commissionlevel = $commissionlevel/100;
			$maxcommission = number_format($price*$commissionlevel,2,'.','');
			if ($affiliatecom > $maxcommission) $affiliatecom = $maxcommission;
		} else if ($affiliatecom > 75) $affiliatecom = 75;
		if ($affiliatewscom && $affwscomtype == "money") {
			$memberresult = @mysqli_query($db, "SELECT commissionlevel FROM user WHERE userid='$userid'");
			$commissionlevel = @mysqli_result($memberresult, 0, "commissionlevel");
			if ($commissionlevel > 75) $commissionlevel = 75;
			$commissionlevel = $commissionlevel/100;
			$maxcommission = number_format($price*$commissionlevel,2,'.','');
			if ($affiliatewscom > $maxcommission) $affiliatewscom = $maxcommission;
		} else if ($affiliatewscom > 75) $affiliatewscom = 75;
	}
	$sql="UPDATE product SET name='$name', price='$price', description='$description', receipttext='$receipttext'";
    if ($userid == "1") {
		if ($active == "on") $sql.=", active=1";
		else $sql.=", active=0";
		if ($wholesale == "on" && !$priceincrement) $sql.=", wholesaleactive=1";
		else $sql.=", wholesaleactive=0";
	}
    $sql.=", licensetext='$licensetext', ebayid='$ebayid'";
	if (isset($activateinmainshop)) {
		if (!empty($activateinmainshop)) $sql.=", inmainshop=1";
		else $sql.=", inmainshop=0";
	} else if ($userid == "1") $sql.=", inmainshop=0";
	if ($lmgroup) $sql.=", listmessengergroup=$lmgroup";
	else $sql.=", listmessengergroup=NULL";
	if ($lmpgroup) $sql.=", listmaillist='$lmpgroup'";
	else $sql.=", listmaillist='0'";
	if ($iemlist) $sql.=", iemlist='$iemlist'";
	else $sql.=", iemlist='0'";
	if ($mclist) $sql.=", mailchimplist='$mclist'";
	else $sql.=", mailchimplist=''";
	if ($phpbbgroup) $sql.=", phpbbgroup=$phpbbgroup";
	else $sql.=", phpbbgroup=NULL";
	if ($wholesaleprice) $sql.=", wholesaleprice='$wholesaleprice'";
	else $sql.=", wholesaleprice=NULL";
	if ($wspricelevels) $sql.=", wspricelevels='$wspricelevels'";
	else $sql.=", wspricelevels=NULL";
	if ($arpresponder) $sql.=", arpresponder='$arpresponder'";
	else $sql.=", arpresponder=NULL";
	if ($arpreachresponder) $sql.=", arpreachresponder='$arpreachresponder'";
	else $sql.=", arpreachresponder=NULL";
	if (isset($autoresponder)) $sql .= ", autoresponder='$autoresponder'";
	if (isset($autoresponderoff)) $sql .= ", autoresponderoff='$autoresponderoff'";
	if ($infinityresponder) $sql.=", infresponder=$infinityresponder";
	else $sql.=", infresponder=NULL";
	if ($infinityresponderoff) $sql.=", infresponderoff=$infinityresponderoff";
	else $sql.=", infresponderoff=NULL";	
    if ($istaxable == "0") $sql.=", taxable=NULL";
	else $sql.=", taxable='$istaxable'";
	if ($billtemplate && $billtemplate != "none") $sql.=", billtemplate='$billtemplate'";
	else $sql.=", billtemplate=NULL";
    if (!$affiliatecom) $affiliatecom = "0";
	$affiliatecomstring = $affiliatecom."a$affcomtype";
    $sql.=", affiliatecom='$affiliatecomstring'";
    if (!$affiliatewscom) $affiliatewscom = "0";
	$affiliatewscomstring = $affiliatewscom."a$affwscomtype";
    $sql.=", affiliatewscom='$affiliatewscomstring'";
    if (!$affiliatecom2) $affiliatecom2 = "0";
    $affiliatecom2string = $affiliatecom2."a$affcomtype2";
    $sql.=", affiliatecom2='$affiliatecom2string'";
	if (empty($affiliatetier2com)) $affiliatetier2com = 0;
	if (empty($affiliatetier2com2)) $affiliatetier2com2 = 0;
	if (empty($affiliatetierlowerby)) $affiliatetierlowerby = 0;
	if ($afftier2comtype != "percent" && $afftier2comtype != "money") $afftier2comtype = "percent";
	if ($afftier2comtype2 != "percent" && $afftier2comtype2 != "money") $afftier2comtype2 = "percent";
	$affiliatetiercom = $affiliatetier2com."a".$afftier2comtype."|".$affiliatetier2com2."a".$afftier2comtype2."|".$affiliatetierlowerby;
	$sql.=", affiliatetiercom='$affiliatetiercom'";
	if (empty($affiliaterepeatcommission) || $affiliaterepeatcommission != "1") $affiliaterepeatcommission = 0;
	$sql.=", affiliaterepeatcommission='$affiliaterepeatcommission'";
	if (isset($memberid)) $sql .= ", userid='$memberid'";
	if ($recurringprice) $sql .= ", recurringprice='$recurringprice'";
	else $sql .= ", recurringprice=NULL";
	if ($recurringprice && $nrecurringperiod) $sql .= ", recurringperiod='$nrecurringperiod|$nrecurringperiodunits'";
	else $sql .= ", recurringperiod=NULL";
	if ($copyof) $sql.=" WHERE productid='$productid' OR copyof='$productid' OR productid='$copyof' OR copyof='$copyof'";
	else $sql.=" WHERE productid='$productid' OR copyof='$productid'";
    $result = @mysqli_query($db, $sql);

	// Set featured to the original product if selected on a copy...
	if ($copyof) {
		@mysqli_query($db, "UPDATE product SET featured='$featured' WHERE productid='$copyof'");
		@mysqli_query($db, "UPDATE product SET featured='0' WHERE copyof='$copyof'");
	} else {
		@mysqli_query($db, "UPDATE product SET featured='$featured' WHERE productid='$productid'");
		@mysqli_query($db, "UPDATE product SET featured='0' WHERE copyof='$productid'");
	}
	
	// Update attribute specific price if needed...
	if ($price != $productprice) {
		$result = @mysqli_query($db, "SELECT * FROM parameters WHERE productid='$productid' OR productid='$copyof'");
		while ($row = @mysqli_fetch_array($result)) {
			$parameterid = $row["parameterid"];
			@mysqli_query($db, "UPDATE parametervalues SET price='$price' WHERE parameterid='$parameterid' AND price='$productprice'");
		}
	}

	// Update floating price...
	$bidlength = $bidlengthdays*86400;
	$bidlength += $bidlengthhours*3600;
	$bidlength += $bidlengthminutes*60;
	$bidlength += $bidlengthseconds;
	if ($price && $priceincrement && $bidlength) {
		$activatetimestamp = mktime($activatehour, $activateminute, 0, $activatemonth, $activateday, date("Y",time()));
		if (!$fp_length) {
			if ($auctiontype == "standard") {
				$starttimestamp = $activatetimestamp;
				@mysqli_query($db, "INSERT INTO floatingprice (productid, startprice, originalstartprice, length, priceincrement, activatetime, type, starttime) VALUES ('$productid', '$price', '$price', '$bidlength', '$priceincrement', '$activatetimestamp', '$auctiontype', '$starttimestamp')");
			} else @mysqli_query($db, "INSERT INTO floatingprice (productid, startprice, originalstartprice, length, priceincrement, activatetime, type) VALUES ('$productid', '$price', '$price', '$bidlength', '$priceincrement', '$activatetimestamp', '$auctiontype')");
		} else {
			if ($auctiontype == "standard") {
				$starttimestamp = $activatetimestamp;
				@mysqli_query($db, "UPDATE floatingprice SET startprice='$price', originalstartprice='$price', length='$bidlength', priceincrement='$priceincrement', activatetime='$activatetimestamp', type='$auctiontype', starttime='$starttimestamp' WHERE productid='$productid'");
			} else @mysqli_query($db, "UPDATE floatingprice SET startprice='$price', originalstartprice='$price', length='$bidlength', priceincrement='$priceincrement', activatetime='$activatetimestamp', type='$auctiontype' WHERE productid='$productid'");
		}
		@mysqli_query($db, "DELETE FROM qtypricelevels WHERE productid='$productid'");
		if ($copyof) $checkfppriceoncopies = @mysqli_query($db, "SELECT * FROM product WHERE copyof='$productid' OR productid='$copyof' OR copyof='$copyof'");
		else $checkfppriceoncopies = @mysqli_query($db, "SELECT * FROM product WHERE copyof='$productid'");
		while ($checkfppricerow = @mysqli_fetch_array($checkfppriceoncopies)) {
			$fpcopyproductid = $checkfppricerow["productid"];
			$checkfponthiscopy = @mysqli_query($db, "SELECT * FROM floatingprice WHERE productid='$fpcopyproductid'");
			if (@mysqli_num_rows($checkfponthiscopy)) @mysqli_query($db, "UPDATE floatingprice SET startprice='$price', originalstartprice='$price', length='$bidlength', priceincrement='$priceincrement', activatetime='$activatetimestamp', type='$auctiontype' WHERE productid='$fpcopyproductid'");
			else @mysqli_query($db, "INSERT INTO floatingprice (productid, startprice, originalstartprice, length, priceincrement, activatetime, type) VALUES ('$fpcopyproductid', '$price', '$price', '$bidlength', '$priceincrement', '$activatetimestamp', '$auctiontype')");
			@mysqli_query($db, "DELETE FROM qtypricelevels WHERE productid='$fpcopyproductid'");
		}
	} else {
		@mysqli_query($db, "DELETE FROM floatingprice WHERE productid='$productid'");
		if ($copyof) $checkfppriceoncopies = @mysqli_query($db, "SELECT * FROM product WHERE copyof='$productid' OR productid='$copyof' OR copyof='$copyof'");
		else $checkfppriceoncopies = @mysqli_query($db, "SELECT * FROM product WHERE copyof='$productid'");
		while ($checkfppricerow = @mysqli_fetch_array($checkfppriceoncopies)) {
			$fpcopyproductid = $checkfppricerow["productid"];
			@mysqli_query($db, "DELETE FROM floatingprice WHERE productid='$fpcopyproductid'");
		}
	}

	if ($error) header ("Location: editcatalogue.php?cat=$cat&search=$search&pid=$pid&error=$error&resultpage=$resultpage");
    else header("Location: editcatalogue.php?cat=$cat&search=$search&pid=$pid&resultpage=$resultpage");
  }
}
?>