<?php
// AShop
// Copyright 2017 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "config.inc.php";
include "ashopconstants.inc.php";
include "ashopfunc.inc.php";
include "checklogin.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/customers.inc.php";

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

if (!$orderid || !$action) {
	header("Location: salesreport.php?error=noorderselected");
	exit;
}

// Get order information from database...
$sql="SELECT * FROM orders WHERE orderid='$orderid' AND (date ='' OR date IS NULL)";
$result = @mysqli_query($db, "$sql");
if (!@mysqli_num_rows($result)) {
	echo "$header
    <section class=\"content-header\"><h1>".INCOMPLETEORDERS."</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <div class=\"alert alert-danger alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ORDER.": $orderid ".COULDNOTBEFOUND."
            </div>
            <p><a href=\"salesreport.php\">".BACKTOINCOMPLETELIST."</a></p>
        </div>
        </div>
        </div>
        </section>
	$footer";
	exit;
}
$customerid = @mysqli_result($result, 0, "customerid");
$products = @mysqli_result($result, 0, "products");
$descriptionstring = @mysqli_result($result, 0, "description");
if (!$descriptionstring) {
	$productsincart = ashop_parseproductstring($db, @mysqli_result($result, $i, "products"));
	if ($productsincart) foreach($productsincart as $productnumber => $thisproduct) {
		$descriptionstring .= $thisproduct["quantity"].": ".$thisproduct["name"].$thisproduct["parameters"];
		if (count($productsincart) > 1 && $productnumber < count($productsincart)-1) $descriptionstring .= ", ";
	}
}
$displaydescr = str_replace(",","<br>",$descriptionstring);
$price = @mysqli_result($result, 0, "price");
$ip = @mysqli_result($result, 0, "ip");

$sql="SELECT * FROM shipping WHERE shippingid='$customerid'";
$result = @mysqli_query($db, "$sql");
$realcustomerid = @mysqli_result($result, 0, "customerid");
if ($realcustomerid) {
	$result = @mysqli_query($db, "SELECT * FROM customer WHERE customerid='$realcustomerid'");
	$firstname = @mysqli_result($result, 0, "firstname");
	$lastname = @mysqli_result($result, 0, "lastname");
	$address = @mysqli_result($result, 0, "address");
	$address2 = "";
	$email = @mysqli_result($result, 0, "shippingemail");
	$zip = @mysqli_result($result, 0, "zip");
	$city = @mysqli_result($result, 0, "city");
	$state = @mysqli_result($result, 0, "state");
	$country = @mysqli_result($result, 0, "country");
	$phone = @mysqli_result($result, 0, "phone");
} else {
	$business = @mysqli_result($result, 0, "shippingbusiness");
	$firstname = @mysqli_result($result, 0, "shippingfirstname");
	$lastname = @mysqli_result($result, 0, "shippinglastname");
	$address = @mysqli_result($result, 0, "shippingaddress");
	$address2 = @mysqli_result($result, 0, "shippingaddress2");
	$email = @mysqli_result($result, 0, "shippingemail");
	$zip = @mysqli_result($result, 0, "shippingzip");
	$city = @mysqli_result($result, 0, "shippingcity");
	$state = @mysqli_result($result, 0, "shippingstate");
	$country = @mysqli_result($result, 0, "shippingcountry");
	$phone = @mysqli_result($result, 0, "shippingphone");
}

if (!$firstname && !$lastname) $customername = UNKNOWN;
else $customername = "$firstname $lastname";

// Delete a preliminary order...
if ($action == "delete") {
	if ($yes) {
       $sql="DELETE FROM orders WHERE orderid='$orderid'";
       $result = @mysqli_query($db, $sql);
	   header("Location: salesreport.php?msg=deleted");
	   exit;
    } elseif ($no) {
	   header("Location: salesreport.php");
	   exit;
	} else {
		echo "$header
    <section class=\"content-header\"><h1>".DELETEANORDER."</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"editpreliminary.php\" method=\"post\">
                <div class=\"box-body\">
                    <div class=\"alert alert-danger\">
                        <h4><i class=\"icon fa fa-ban\"></i> ".AREYOUSUREDELETEINCOMPLETE."</h4>
                    </div>
                    <div class=\"form-group\"><label>".ORDERID.":</label> $orderid</div>
                    <div class=\"form-group\"><label>".CUSTOMER.":</label> $customername</div>
                    <div class=\"form-group\"><label>".AMOUNT.":</label> ".$currencysymbols[$ashopcurrency]["pre"].number_format($price,$showdecimals,$decimalchar,$thousandchar).$currencysymbols[$ashopcurrency]["post"]."</div>
                    <div class=\"form-group\"><label>".PRODUCTS.":</label><p>$displaydescr</p></div>
                </div>
				<div class=\"box-footer\">
					<button type=\"button\" class=\"btn btn-default\" name=\"no\" value=\"".NO."\" onClick=\"javascript:history.back()\">".NO."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"yes\" value=\"".YES."\">".YES."</button>
				</div>
                <input type=\"hidden\" name=\"orderid\" value=\"$orderid\">
                <input type=\"hidden\" name=\"action\" value=\"delete\">";

                if ($fromstats) echo "<input type=\"hidden\" name=\"fromstats\" value=\"True\">";

                echo "
             </form></div></div></div></section>$footer";
		exit;
	}
} 

// Complete a preliminary order...
if ($action == "complete") {
	if ($step1) {
		if ($naddress2) $naddress .= ", $naddress2";
		$adminkey = md5("$databasepasswd$ashoppath"."prelcomplete");
		$querystring = "email=$nemail&firstname=$nfirstname&lastname=$nlastname&address=$naddress&city=$ncity&zip=$nzip&state=$nstate&country=$ncountry&phone=$nphone&invoice=$orderid&adminkey=$adminkey&amount=$price&products=$payoption"."ashoporderstring$products";
		if (strpos($ashopurl, "/", 8)) {
			$urlpath = "/".substr($ashopurl, strpos($ashopurl, "/", 8)+1);
			$urldomain = substr($ashopurl, 0, strpos($ashopurl, "/", 8));
		} else {
			$urlpath = "/";
			$urldomain = $ashopurl;
		}
		if ($urlpath == "/") $scriptpath = "order.php";
		else $scriptpath = "/order.php";
		$urldomain = str_replace("http://", "", $urldomain);
		$postheader = "POST $urlpath$scriptpath HTTP/1.0\r\nHost: $urldomain\r\nUser-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: ".strlen ($querystring)."\r\n\r\n";
		$fp = fsockopen ("$urldomain", 80);
		if ($fp) {
			fputs ($fp, $postheader . $querystring);
			$response = "";
			while (!feof($fp)) $response .= fread ($fp, 8192);
			fclose ($fp);
		}
		echo "$header
    <section class=\"content-header\"><h1>".INCOMPLETEORDERS."</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <div class=\"alert alert-success alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ORDER.": $orderid ".HASBEENPROCESSED."
            </div>
            <p><a href=\"salesreport.php\">".BACKTOINCOMPLETELIST."</a></p>
        </div>
        </div>
        </div>
        </section>
		$footer";
	} else {
		$payoptionsstring = "";
		$result = @mysqli_query($db, "SELECT * FROM payoptions");
		while($row = @mysqli_fetch_array($result)) $payoptionsstring .= "<option value=\"".$row["payoptionid"]."\">".$row["name"]."</option>";
		echo "$header
    <section class=\"content-header\"><h1>".INCOMPLETEORDERS." <a href=\"editpreliminary.php?orderid=$orderid&action=delete\"><img src=\"images/icon_trash.gif\" alt=\"DELETEORDER\" title=\"".DELETEORDER."\" /></a></h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
		    <form action=\"editpreliminary.php\" method=\"post\">
                <div class=\"box-header with-border\">
                    <h3 class=\"box-title\">".COMPLETEPRELIMINARYORDER."</h3>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\"><label>".ORDERID.":</label> $orderid</div>
                    <div class=\"form-group\"><label>".CUSTOMER.":</label> $customername</div>
                    <div class=\"form-group\"><label>".AMOUNT.":</label> ".$currencysymbols[$ashopcurrency]["pre"].number_format($price,$showdecimals,$decimalchar,$thousandchar).$currencysymbols[$ashopcurrency]["post"]."</div>
                    <div class=\"form-group\"><label>".PRODUCTS.":</label><p>$displaydescr</p></div>
                    <div class=\"form-group\"><label for=\"payoption\">".PAYMENTOPTION.":</label><select class=\"form-control\" name=\"payoption\">$payoptionsstring</select></div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => CUSTOMEREMAIL, "name" => "nemail", "value" => $email))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => FIRSTNAME, "name" => "nfirstname", "value" => $firstname))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LASTNAME, "name" => "nlastname", "value" => $lastname))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ADDRESS, "name" => "naddress", "value" => $address))."</div>";
		if ($address2) echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => ADDRESSLINE2, "name" => "naddress2", "value" => $address2))."</div>";
		echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => CITY, "name" => "ncity", "value" => $city))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => STATEPROVINCE, "name" => "nstate", "value" => $state))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ZIP, "name" => "nzip", "value" => $zip, "small" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => COUNTRY, "name" => "ncountry", "value" => $country))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => PHONE, "name" => "nphone", "value" => $phone))."</div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"step1\" value=\"".SUBMIT."\">".SUBMIT."</button>
					<button type=\"button\" class=\"btn btn-default\" name=\"cancel\" value=\"".CANCEL."\" onClick=\"javascript:history.back()\">".CANCEL."</button>
				</div>
                <input type=\"hidden\" name=\"orderid\" value=\"$orderid\">
                <input type=\"hidden\" name=\"action\" value=\"complete\">
            </form>
        </div>
        </div>
        </div>
		</section>
		$footer";
	}
}

// Close database...
@mysqli_close($db);

?>