<?php
// AShop
// Copyright 2017 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "config.inc.php";
include "ashopconstants.inc.php";
include "ashopfunc.inc.php";
include "checklogin.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/affiliates.inc.php";
// Get context help for this page...
$contexthelppage = "affiliatestats";
include "help.inc.php";

// Remember how many items to display...
if (!is_numeric($admindisplayitems)) unset($admindisplayitems);
else {
	$c_admindisplayitems = $admindisplayitems;
	if (!$p3psent) header('P3P: CP="IDC DSP COR CURa ADMa OUR IND PHY ONL COM STA"');
	$p3psent = TRUE;
	setcookie("c_admindisplayitems","$admindisplayitems");
}
if (!is_numeric($c_admindisplayitems)) unset($c_admindisplayitems);

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

echo "$header
    <section class=\"content-header\"><h1>".STATISTICSANDPAYMENT." <a href=\"$help1\" target=\"_blank\"><img src=\"images/icon_helpsm.gif\" width=\"15\" height=\"15\" border=\"0\"></a></h1></section>
    <section class=\"content\">
		<div class=\"row\">
        <div class=\"col-xs-12\">
          <div class=\"box\">
            <div class=\"box-body\">
            <div class=\"row\">
                <form class=\"form-horizontal\" action=\"affiliatestats.php?resultpage=$resultpage&admindisplayitems=$admindisplayitems\" method=\"post\" name=\"affiliatefilterform\">                     <div class=\"col-md-4\">
                        <div class=\"form-group\">
                            <label for=\"namefilter\" class=\"col-sm-4 control-label\">".FILTERBYNAME."</label>
                            <div class=\"col-sm-8\"><input class=\"form-control\" type=\"text\" name=\"namefilter\" value=\"$namefilter\" size=\"10\"></div>
                        </div>
                   </div>
                   <div class=\"col-md-2\">
                        <button type=\"submit\" class=\"btn btn-primary\" value=\"".FILTER."\">".FILTER."</button>
                   </div>
                </form>
            </div>
              <table id=\"affiliates\" class=\"table table-bordered\">
                <thead><tr>
                    <th>".IDNAME."</th><th>".CLICKS."</th><th>".ORDERS."</th><th>".DOWNLINEORDERS."</th><th>".EARNED."</th><th>".UNPAID."</th><th>".ACTION."</th></tr>
                </thead>
                <tbody>";

// Reset statistics...
$totalclicks = 0;
$totalorders = 0;
$totalprovision = 0;
$totalourdebt = 0;
$totaldownline = 0;

// Get affiliate information from database...
$sql="SELECT * FROM affiliate";
if ($namefilter) $sql .= " WHERE firstname  LIKE '%$namefilter%' OR lastname LIKE '%$namefilter%'";
$sql .=" ORDER BY affiliateid";
$result = @mysqli_query($db, "$sql");
$numberofrows = intval(@mysqli_num_rows($result));
if (!$admindisplayitems) {
	if ($c_admindisplayitems) $admindisplayitems = $c_admindisplayitems;
	else $admindisplayitems = 10;
}
$numberofpages = ceil($numberofrows/$admindisplayitems);
if ($resultpage > 1) $startrow = (intval($resultpage)-1) * $admindisplayitems;
else {
	$resultpage = 1;
	$startrow = 0;
}
$startpage = $resultpage - 9;
if ($numberofpages - $resultpage < 10) {
	$pagesleft = $numberofpages - $resultpage;
	$startpage = $startpage - (10 - $pagesleft);
}
if ($startpage < 1) $startpage = 1;
$stoprow = $startrow + $admindisplayitems;
@mysqli_data_seek($result, $startrow);
$thisrow = $startrow;
while (($row = @mysqli_fetch_array($result)) && ($thisrow < $stoprow)) {
	$thisrow++;
	$provision = 0;
	$ourdebt = 0;
    $firstname = $row["firstname"];
    $lastname = $row["lastname"];
	$email = $row["email"];
    $affiliateid = $row["affiliateid"];
	$clicks = $row["clicks"];
	$totalclicks += $clicks;
	if (!$clicks) $clicks = 0;

	// Get number of orders...
	$sql="SELECT COUNT(orders.orderid) AS numberoforders FROM orders, orderaffiliate WHERE orderaffiliate.affiliateid='$affiliateid' AND (orderaffiliate.secondtier=0 OR orderaffiliate.secondtier IS NULL) AND orders.orderid=orderaffiliate.orderid";
	$result2 = @mysqli_query($db, "$sql");
	$orders = @mysqli_result($result2,0,"numberoforders");
	$totalorders += $orders;

	// Get total commission...
	$sql="SELECT SUM(orderaffiliate.commission) AS totalcommission FROM orders, orderaffiliate WHERE orderaffiliate.affiliateid='$affiliateid' AND (orderaffiliate.secondtier=0 OR orderaffiliate.secondtier IS NULL) AND orders.orderid=orderaffiliate.orderid";
	$result2 = @mysqli_query($db, "$sql");
	$provision = @mysqli_result($result2,0,"totalcommission");

	// Get total unpaid commission...
	$sql="SELECT SUM(orderaffiliate.commission) AS ourdebt FROM orders, orderaffiliate WHERE orderaffiliate.affiliateid='$affiliateid' AND (orderaffiliate.secondtier=0 OR orderaffiliate.secondtier IS NULL) AND orders.orderid=orderaffiliate.orderid AND (orderaffiliate.paid='' OR orderaffiliate.paid IS NULL OR orderaffiliate.paid=0)";
	$result2 = @mysqli_query($db, "$sql");
	$thisdebt = @mysqli_result($result2,0,"ourdebt");
	$ourdebt += $thisdebt;

	// Get multi tier stats...
	$sql="SELECT orderaffiliate.commission, orderaffiliate.paid FROM orders, orderaffiliate WHERE orderaffiliate.affiliateid='$affiliateid' AND orderaffiliate.secondtier!=0 AND orderaffiliate.secondtier IS NOT NULL AND orders.orderid=orderaffiliate.orderid";
	$result2 = @mysqli_query($db, "$sql");
	$secondtier = @mysqli_num_rows($result2);
	if (@mysqli_num_rows($result2) != 0) {
		for ($j = 0; $j < @mysqli_num_rows($result2);$j++) {
			$commission = @mysqli_result($result2, $j, "commission");
			$paid = @mysqli_result($result2, $j, "paid");
			$provision += $commission;
			if (!$paid) $ourdebt += $commission;
		}
	}
	if (!$secondtier) $secondtier = "0";
	$totaldownline += $secondtier;
	echo "<tr><td>$affiliateid, <a href=\"editaffiliate.php?affiliateid=$affiliateid&fromstats=True\">$firstname $lastname</a></td><td>$clicks</td><td>$orders</td><td>$secondtier</td><td>".$currencysymbols[$ashopcurrency]["pre"].number_format($provision,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</td><td>";
	if ($ourdebt) echo $currencysymbols[$ashopcurrency]["pre"].number_format($ourdebt,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"];
	echo "</td><td>";
	if ($ourdebt) echo "<a href=\"payaffiliate.php?affiliateid=$affiliateid\"><img src=\"images/icon_pay.gif\" alt=\"".PAYAFFILIATE." $affiliateid.\" title=\"".PAYAFFILIATE." $affiliateid.\" border=\"0\"></a>&nbsp;";
	else echo "<img src=\"images/spacer.gif\" width=\"15\" border=\"0\"></a>&nbsp;";
	echo "<a href=\"editaffiliate.php?affiliateid=$affiliateid\"><img src=\"images/icon_profile.gif\" alt=\"".PROFILEFORAFFILIATE." $affiliateid\" title=\"".PROFILEFORAFFILIATE." $affiliateid\" border=\"0\"></a>&nbsp;<a href=\"affiliatedetail.php?affiliateid=$affiliateid\"><img src=\"images/icon_history.gif\" alt=\"".STATISTICSFORAFFILIATE." $affiliateid\" title=\"".STATISTICSFORAFFILIATE." $affiliateid\" border=\"0\"></a>&nbsp;<a href=\"editaffiliate.php?affiliateid=$affiliateid&remove=True&fromstats=True\"><img src=\"images/icon_trash.gif\" alt=\"".DELETEAFFILIATE." $affiliateid ".FROMTHEDATABASE."\" title=\"".DELETEAFFILIATE." $affiliateid ".FROMTHEDATABASE."\" border=\"0\"></a></td></tr>";
	$totalprovision += $provision;
	$totalourdebt += $ourdebt;
}

echo "<tr><th>".TOTALS." </th><th>$totalclicks</th><th>$totalorders</th><th>$totaldownline</th><th> ".$currencysymbols[$ashopcurrency]["pre"].number_format($totalprovision,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th> ".$currencysymbols[$ashopcurrency]["pre"].number_format($totalourdebt,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</th><th>&nbsp;</th></tr></tbody></table></div></div>";

if ($numberofrows > 5) {
	echo "
        <div class=\"row\">
        <div class=\"col-md-4\"></div>
        <div class=\"col-md-4 text-center\">
        <nav aria-label=\"".PAGE."\">
            <ul class=\"pagination text-center\">";
	if ($numberofpages > 1) {
		if ($resultpage > 1) {
			$previouspage = $resultpage-1;
			echo "<li class=\"page-item\"><a class=\"page-link\" href=\"affiliatestats.php?resultpage=$previouspage&admindisplayitems=$admindisplayitems&namefilter=$namefilter\">".PREVIOUS."</a></li>";
		}
		$page = 1;
		for ($i = $startpage; $i <= $numberofpages; $i++) {
			if ($page > 20) break;
			if ($i != $resultpage) echo "<li class=\"page-item\"><a class=\"page-link\" href=\"affiliatestats.php?resultpage=$i&admindisplayitems=$admindisplayitems&namefilter=$namefilter\">";
            else echo "<li class=\"page-item active\"><span class=\"page-link\">";
			echo "$i";
			if ($i != $resultpage) echo "</a>";
            else echo "</span>";
            echo "</li>";
			$page++;
		}
		if ($resultpage < $numberofpages) {
			$nextpage = $resultpage+1;
			echo "<li class=\"page-item\"><a class=\"page-link\" href=\"affiliatestats.php?resultpage=$nextpage&admindisplayitems=$admindisplayitems&namefilter=$namefilter\">".NEXTPAGE."</a></li>";
		}
	}
    echo "</ul>
    </nav></div>
    </div>
        <div class=\"row\">
        <div class=\"col-md-4\"></div>
        <div class=\"col-md-4\">
    <div class=\"form-group\"><label for=\"admindisplayitems\" class=\"col-sm-2 control-label\">".DISPLAY.":</label><div class=\"col-sm-10\"><select name=\"admindisplayitems\" id=\"admindisplayitems\" class=\"form-control\" onChange=\"document.location.href='affiliatestats.php?resultpage=$resultpage&namefilter=$namefilter&admindisplayitems='+getElementById('admindisplayitems').value;\"><option value=\"$numberofrows\">".SELECT."</option>
		<option value=\"5\"";
		if ($c_admindisplayitems == "5") echo " selected";
		echo ">5</option><option value=\"10\"";
		if ($c_admindisplayitems == "10") echo " selected";
		echo ">10</option><option value=\"20\"";
		if ($c_admindisplayitems == "20") echo " selected";
		echo ">20</option><option value=\"40\"";
		if ($c_admindisplayitems == "40") echo " selected";
		echo ">40</option><option value=\"$numberofrows\"";
		if ($c_admindisplayitems == "$numberofrows") echo " selected";
		echo ">".ALL."</option></select><p class=\"help-block\">".AFFILIATES2."</p></div></div></div></div>";
}
echo "</div></div></section>$footer";
?>