<?php
// AShop
// Copyright 2017 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "config.inc.php";
include "ashopfunc.inc.php";
include "ashopconstants.inc.php";
include "checklogin.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/affiliates.inc.php";

// Validate variables...
if (!is_numeric($resultpage)) unset($resultpage);
if (!is_numeric($commissiondisplayitems)) unset($commissiondisplayitems);
else {
	$c_commissiondisplayitems = $commissiondisplayitems;
	if (!$p3psent) header('P3P: CP="IDC DSP COR CURa ADMa OUR IND PHY ONL COM STA"');
	$p3psent = TRUE;
	setcookie("c_commissiondisplayitems","$commissiondisplayitems");
}
if (!is_numeric($c_commissiondisplayitems)) unset($c_commissiondisplayitems);

// Open database...
$db = mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Delete paid commission...
if ($delete && $affiliateid) {
	if ($payment == "true") $sql="UPDATE orderaffiliate SET paid='', paymethod='' WHERE orderid='$delete'"; 
	else if ($chargeback == "true") $sql="DELETE FROM orderaffiliate WHERE orderid='$delete' AND commission<0";
	else $sql="DELETE FROM orderaffiliate WHERE orderid='$delete'";
	$result = @mysqli_query($db, "$sql");
}

// Get affiliate information from database...
$sql="SELECT * FROM affiliate WHERE affiliateid='$affiliateid'";
$result = @mysqli_query($db, "$sql");
if (@mysqli_num_rows($result) == 0) {
    echo "$header
        <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
              <div class=\"alert alert-danger alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ERRORNOSUCHAFFILIATE." <a href=\"javascript:history.back()\">".TRYAGAIN."</a>
              </div>
            </div>
        </div>
        </section>$footer";
    exit;
}

// Store affiliate information in variables...
$firstname = mysqli_result($result, 0, "firstname");
$lastname = mysqli_result($result, 0, "lastname");
$click = mysqli_result($result, 0, "clicks");
$lastdate = @mysqli_result ($result, 0, "lastdate");

// Get statistics from database...
$selectorderids = "
              <table id=\"affiliates\" class=\"table table-bordered\">
                <thead><tr>
                    <th>".DATETIME."</th><th>".AMOUNT."</th><th>".REFERENCE."</th><th></th>
                </tr></thead>
                <tbody>";


$totalprovision = 0;
$totalourdebt = 0;
$sql="SELECT orders.date, orders.orderid, orders.invoiceid, orders.wholesale, orderaffiliate.* FROM orders, orderaffiliate WHERE orderaffiliate.affiliateid='$affiliateid' AND orderaffiliate.orderid=orders.orderid AND orders.paid != '0' AND orders.paid != '' AND orders.paid IS NOT NULL ORDER BY orderaffiliate.orderid DESC";
$result = @mysqli_query($db, "$sql");
$order = intval(@mysqli_num_rows($result));
if (!$commissiondisplayitems) {
	if ($c_commissiondisplayitems) $commissiondisplayitems = $c_commissiondisplayitems;
	else $commissiondisplayitems = 10;
}
$numberofpages = ceil($order/$commissiondisplayitems);
if ($resultpage > 1) $startrow = (intval($resultpage)-1) * $commissiondisplayitems;
else {
	$resultpage = 1;
	$startrow = 0;
}
$startpage = $resultpage - 9;
if ($numberofpages - $resultpage < 10) {
	$pagesleft = $numberofpages - $resultpage;
	$startpage = $startpage - (10 - $pagesleft);
}
if ($startpage < 1) $startpage = 1;
$stoprow = $startrow + $commissiondisplayitems;
@mysqli_data_seek($result, $startrow);
$thisrow = $startrow;
while (($row = @mysqli_fetch_array($result)) && ($thisrow < $stoprow)) {
	$thisrow++;
	$orderdate = $row["date"];
	$orderid = $row["orderid"];
	$invoiceid = $row["invoiceid"];
	$wholesale = $row["wholesale"];
	$paid = $row["paid"];
	$paymethod = $row["paymethod"];
	$provision = $row["commission"];
	$provision = number_format($provision,$showdecimals,$decimalchar,$thousandchar);
	$secondtier = $row["secondtier"];
	if ($secondtier) $secondtier++;
	$totalprovision += $provision;
	if ($provision < 0) {
		$chargebackresult = @mysqli_query($db, "SELECT orderid FROM orders WHERE reference='$orderid' LIMIT 1");
		$linkorderid = @mysqli_result($chargebackresult,0,"orderid");
	} else $linkorderid = $orderid;

	$selectorderids .= "<tr><td>$orderdate</td><td><font ";
	if ($provision < 0) $selectorderids .= " color=\"#FF0000\">- ".$currencysymbols[$ashopcurrency]["pre"].number_format(-$provision,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"];
	else $selectorderids .= ">".$currencysymbols[$ashopcurrency]["pre"].number_format($provision,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"];
	$selectorderids .= "</font></td><td>&nbsp;&nbsp;<a href=\"salesreport.php?generate=true&orderid=$linkorderid\">";
	if ($provision < 0) $selectorderids .= CHARGEBACK." ";
	$selectorderids .= ORDERID.": $invoiceid";
	if ($wholesale) $selectorderids .= " ".WHOLESALESIGN;
	$selectorderids .= "</a>";
	if ($secondtier) $selectorderids .= ", ".TIER." $secondtier";
	$selectorderids .= "</td><td>";
	if ($provision > 0) $selectorderids .= "<a href=\"affiliatedetail.php?affiliateid=$affiliateid&delete=$orderid\"><img src=\"images/icon_trash.gif\" border=\"0\" alt=\"".DELETETRANSACTION."\" title=\"".DELETETRANSACTION."\"></a>";
	else $selectorderids .= "<a href=\"affiliatedetail.php?affiliateid=$affiliateid&delete=$orderid&chargeback=true\"><img src=\"images/icon_trash.gif\" border=\"0\" alt=\"".DELETETRANSACTION."\" title=\"".DELETETRANSACTION."\"></a>";
	$selectorderids .= "</td></tr>";

	if ($paid && $provision > 0) {
		$selectorderids .= "<tr><td>$paid</td><td><font color=\"#FF0000\">- ".$currencysymbols[$ashopcurrency]["pre"].number_format($provision,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."</font></td><td>&nbsp;&nbsp;".PAIDBY." $paymethod</td><td><a href=\"affiliatedetail.php?affiliateid=$affiliateid&delete=$orderid&payment=true\"><img src=\"images/icon_trash.gif\" border=\"0\" alt=\"".DELETETRANSACTION."\" title=\"".DELETETRANSACTION."\"></a></td></tr>";
	}
}
$selectorderids .= "</tbody></table>";


// Show affiliate stats in browser...
	if (strpos($header, "title") != 0) {
		$newheader = substr($header,1,strpos($header, "title")+5);
		$newheader .= AFFILIATEDATAFOR.": $firstname $lastname - ".substr($header,strpos($header, "title")+6,strlen($header));
    } else {
		$newheader = substr($header,1,strpos($header, "TITLE")+5);
		$newheader .= AFFILIATEDATAFOR.": $firstname $lastname - ".substr($header,strpos($header, "TITLE")+6,strlen($header));
	}

echo "$header
    <section class=\"content-header\"><h1>".STATISTICSFOR." $firstname $lastname, ".AFFILIATEID." $affiliateid\n <a href=\"editaffiliate.php?affiliateid=$affiliateid\"><img src=\"images/icon_profile.gif\" alt=\"".PROFILEFORAFFILIATE." $affiliateid\" title=\"".PROFILEFORAFFILIATE." $affiliateid\" border=\"0\"></a>&nbsp;<a href=\"referraldiscounts.php?affiliateid=$affiliateid\"><img src=\"images/icon_discount.gif\" alt=\"".REFERRALDISCOUNTSFORAFFILIATE." $affiliateid\" title=\"".REFERRALDISCOUNTSFORAFFILIATE." $affiliateid\" border=\"0\"></a>&nbsp;<a href=\"editaffiliate.php?affiliateid=$affiliateid&remove=True&fromstats=True\"><img src=\"images/icon_trash.gif\" alt=\"".DELETEAFFILIATE." $affiliateid ".FROMTHEDATABASE."\" title=\"".DELETEAFFILIATE." $affiliateid ".FROMTHEDATABASE."\" border=\"0\"></a></h1></section>
    <section class=\"content\">
		<div class=\"row\">
        <div class=\"col-xs-12\">
            <p>".TOTALNUMBEROFCLICKS.": $click<br>
            ".TOTALNUMBEROFORDERS.": $order<br>
            ".TOTALEARNINGS.": ".$currencysymbols[$ashopcurrency]["pre"].number_format($totalprovision,$showdecimals,$decimalchar,$thousandchar)." ".$currencysymbols[$ashopcurrency]["post"]."<br>
            ".DATEOFLASTACTIVITY.": $lastdate</font></p>
		<div class=\"box box-primary\">
			    <div class=\"box-header with-border\">
				    <h3 class=\"box-title\">".COMMISSIONHISTORY."</h3>
			    </div>
                $selectorderids</div></div>";
if ($order > 5) {
	echo "
        <div class=\"row\">
        <div class=\"col-md-4\"></div>
        <div class=\"col-md-4\">
        <nav aria-label=\"".PAGE."\">
            <ul class=\"pagination text-center\">";
	if ($numberofpages > 1) {
		if ($resultpage > 1) {
			$previouspage = $resultpage-1;
			echo "<li class=\"page-item\"><a class=\"page-link\" href=\"affiliatedetail.php?resultpage=$previouspage&commissiondisplayitems=$commissiondisplayitems&affiliateid=$affiliateid\">".PREVIOUS."</a></li>";
		}
		$page = 1;
		for ($i = $startpage; $i <= $numberofpages; $i++) {
			if ($page > 20) break;
			if ($i != $resultpage) echo "<li class=\"page-item\"><a class=\"page-link\" href=\"affiliatedetail.php?resultpage=$i&commissiondisplayitems=$commissiondisplayitems&affiliateid=$affiliateid\">";
			echo "$i";
			if ($i != $resultpage) echo "</a></li>";
			$page++;
		}
		if ($resultpage < $numberofpages) {
			$nextpage = $resultpage+1;
			echo "<li class=\"page-item\"><a class=\"page-link\" href=\"affiliatedetail.php?resultpage=$nextpage&commissiondisplayitems=$commissiondisplayitems&affiliateid=$affiliateid\">".NEXTPAGE."</a></li>";
		}
	}
	echo "</ul>
    </nav><div class=\"form-group\"><label for=\"admindisplayitems\" class=\"col-sm-2 control-label\">".DISPLAY.":</label><div class=\"col-sm-10\"><select name=\"commissiondisplayitems\" id=\"commissiondisplayitems\" class=\"form-control\" onChange=\"document.location.href='affiliatedetail.php?resultpage=$resultpage&affiliateid=$affiliateid&commissiondisplayitems='+document.getElementById('commissiondisplayitems').value;\"><option value=\"$order\">".SELECT."</option><option value=\"5\">5</option><option value=\"10\">10</option><option value=\"20\">20</option><option value=\"40\">40</option><option value=\"$order\">".ALL."</option></select><p class=\"help-block\">".AFFILIATES2."</p></div></div>
	";
}
echo "</section>$footer";

// Close database...
@mysqli_close($db);
?>