<?php
// AShop
// Copyright 2017 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "config.inc.php";
include "ashopfunc.inc.php";
include "checklogin.inc.php";

if ($cancel) {
	header("Location: settings.php");
	exit;
}
include "template.inc.php";
// Get language module...
include "language/$adminlang/configure.inc.php";
include "ashopconstants.inc.php";

// Open database connection...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Perform requested unlock...
if ($changeconfig && ($unlockmove || $unlockhtml)) {
	$changeconfig = 0;
	if ($unlockmove) @mysqli_query($db, "UPDATE user SET movelock='0'");
	else if ($unlockhtml) @mysqli_query($db, "UPDATE user SET htmllock='0'");
}

// Check if any features are currently locked...
$result = @mysqli_query($db, "SELECT * FROM user WHERE movelock='1'");
if (@mysqli_num_rows($result)) $productmovecheck = "<b>".LOCKED."</b> <input type=\"submit\" name=\"unlockmove\" value=\"".UNLOCK."\">";
else $productmovecheck = "<b>".UNLOCKED."</b>";
$result = @mysqli_query($db, "SELECT * FROM user WHERE htmllock='1'");
if (@mysqli_num_rows($result)) $pagegeneratorcheck = "<b>".LOCKED."</b> <input type=\"submit\" name=\"unlockhtml\" value=\"".UNLOCK."\">";
else $pagegeneratorcheck = "<b>".UNLOCKED."</b>";

if (!$changeconfig) {
        echo "$header
        <section class=\"content-header\"><h1>".ADVANCEDSHOPPARAMETERS."</h1></section><section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		        <div class=\"box box-primary\">
                    <form action=\"advancedoptions.php?changeconfig=1\" method=\"post\" name=\"configurationform\">";
}

if (!$changeconfig) {
	// Get context help for this page...
		$contexthelppage = "advancedoptions";
		include "help.inc.php";
	echo "
              <div class=\"alert alert-danger alert-dismissible\">
                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                ".ONLYCHANGEIFYOUKNOW."
              </div>
				<div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => SHOPURL, "name" => "nashopurl", "value" => $ashopurl, "helpnumber" => 22, "helptext" => $tip1))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => SECUREURL, "name" => "nashopsurl", "value" => $ashopurl, "helpnumber" => 1, "helptext" => $tip1))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => FILESYSTEMPATH, "name" => "nashoppath", "value" => $ashoppath, "helpnumber" => 2, "helptext" => $tip2))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => SECUREFILESYSTEMPATH, "name" => "nashopspath", "value" => $ashopspath, "helpnumber" => 11, "helptext" => $tip11))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => TIMEZONEOFFSET, "name" => "ntimezoneoffset", "value" => $timezoneoffset, "helpnumber" => 3, "helptext" => $tip3))."</div>
					<div class=\"form-group\"><label for=\"nmailertype\">".MAILERTYPE."</label>
						<select name=\"nmailertype\" id=\"nmailertype\" class=\"form-control\"><option value=\"mailfunction\""; if ($mailertype == "mailfunction") echo " selected"; echo ">".MAILFUNCTION."</option><option value=\"smtp\""; if ($mailertype == "smtp") echo " selected"; echo ">SMTP</option></select>
                    </div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MAILERSERVER, "name" => "nmailerserver", "value" => $mailerserver))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MAILERPORT, "name" => "nmailerport", "value" => $mailerport))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MAILERUSER, "name" => "nmaileruser", "value" => $maileruser))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => MAILERPASS, "name" => "nmailerpass", "value" => $mailerpass))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => PATHTO." Infinity Responder", "name" => "ninfinitypath", "value" => $infinitypath, "helpnumber" => 12, "helptext" => $tip12, "helplink" => $help12))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => PATHTO." punBB", "name" => "nphpbbpath", "value" => $phpbbpath, "helpnumber" => 6, "helptext" => $tip6, "helplink" => $help6))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => URLTO." punBB", "name" => "nphpbburl", "value" => $phpbburl, "helpnumber" => 7, "helptext" => $tip7))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => "AWeber Authorization Code", "name" => "naweberauthcode", "value" => $aweberauthcode, "helpnumber" => 17, "helptext" => $tip17, "helplink" => "http://www.aweber.com"))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => "MailChimp API Key", "name" => "nmailchimpapikey", "value" => $mailchimpapikey, "helpnumber" => 18, "helptext" => $tip18, "helplink" => "https://us2.admin.mailchimp.com/account/api/"))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => "Email Marketer ".URL, "name" => "niemurl", "value" => $iemurl, "helpnumber" => 16, "helptext" => $tip16, "helplink" => $help16))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => "Email Marketer ".USER, "name" => "niemuser", "value" => $iemuser))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => "Email Marketer ".TOKEN, "name" => "niemtoken", "value" => $iemtoken))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => "Facebook ".APPLICATIONID, "name" => "nfacebookappid", "value" => $facebookappid))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => "Facebook ".SECRET, "name" => "nfacebooksecret", "value" => $facebooksecret))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => PATHTO." PAP", "name" => "npappath", "value" => $pappath, "helpnumber" => 15, "helptext" => $tip15, "helplink" => $help15))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => PRODUCTMOVEIS, "name" => "productmovecheck", "explanation" => $productmovecheck, "helpnumber" => 13, "helptext" => $tip13, "noinput" => TRUE))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => SITEMAPGENERATORIS, "name" => "pagegeneratorcheck", "explanation" => $pagegeneratorcheck, "helpnumber" => 14, "helptext" => $tip14, "noinput" => TRUE))."</div>
				</div>
";
} else {

	// Auhtenticate the AWeber authorization code...
	$awebercodecheck = explode("|",$naweberauthcode);
	if (!empty($naweberauthcode) && count($awebercodecheck) == 6) {
		require_once('../includes/aweber/aweber_api.php');

		try {
			$auth = AWeberAPI::getDataFromAweberID($naweberauthcode);
			list($consumerKey, $consumerSecret, $accessKey, $accessSecret) = $auth;
		}
		catch(AWeberAPIException $exc) {
			echo "AWeber Error: ".$exc->message;
			exit;
		}
		$naweberauthcode = $consumerKey."|".$consumerSecret."|".$accessKey."|".$accessSecret."|";
	}

	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopurl' WHERE prefname='ashopurl'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopsurl' WHERE prefname='ashopsurl'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashoppath' WHERE prefname='ashoppath'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nashopspath' WHERE prefname='ashopspath'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$ntimezoneoffset' WHERE prefname='timezoneoffset'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmailertype' WHERE prefname='mailertype'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmailerserver' WHERE prefname='mailerserver'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmailerport' WHERE prefname='mailerport'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmaileruser' WHERE prefname='maileruser'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmailerpass' WHERE prefname='mailerpass'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nphpbbpath' WHERE prefname='phpbbpath'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nphpbburl' WHERE prefname='phpbburl'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$ninfinitypath' WHERE prefname='infinitypath'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$niemurl' WHERE prefname='iemurl'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$niemuser' WHERE prefname='iemuser'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$niemtoken' WHERE prefname='iemtoken'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfacebookappid' WHERE prefname='facebookappid'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nfacebooksecret' WHERE prefname='facebooksecret'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$naweberauthcode' WHERE prefname='aweberauthcode'");
	@mysqli_query($db, "UPDATE preferences SET prefvalue='$nmailchimpapikey' WHERE prefname='mailchimpapikey'");
	
	// Disable Autoresponder-Service if AWeber is activated...
	if (!empty($naweberauthcode)) @mysqli_query($db, "UPDATE preferences SET prefvalue='' WHERE prefname='activateautoresponder'");
}

if (!$changeconfig) {
	echo "
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\">".SUBMIT."</button>
				</div>
            </form>
		</div>
		</div>
		</div>
        </section>$footer";
} else {
	@mysqli_close($db);
	header("Location: settings.php");
}
?>