<?php
// AShop
// Copyright 2018 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

include "config.inc.php";
include "ashopfunc.inc.php";
include "ashopconstants.inc.php";
include "checklogin.inc.php";
// Get context help for this page...
$contexthelppage = "editproduct";
include "help.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/editproduct.inc.php";

// Get MailChimp lists if applicable...
if ($mailchimpapikey) {
	require_once "../includes/MCAPI.class.php";
	$api = new MCAPI($mailchimpapikey);
	$retval = $api->lists();
	if (!$api->errorCode){
		$mcselectstring = "
        <div class=\"form-group\">
            <label for=\"mclist\"><a href= \"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image1','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image1\" align=\"absmiddle\" onclick=\"return overlib('$tip1');\" onmouseout=\"return nd();\"></a> ".MAILCHIMPLIST.":</label><select class=\"form-control\" name=\"mclist\"><option value=\"0\">".NONE."</option>";
		foreach ($retval['data'] as $list){
			$mcselectstring .= "<option value=\"".$list['id']."\">".$list['name']."</option>";
		}
		$mcselectstring .= "</select></div>";
	}
}

// Get phpbb groups if applicable...
if ($phpbbpath && file_exists("$phpbbpath/config.php")) {
	$fp = fopen ("$phpbbpath/config.php", "r");
	while (!feof($fp)) {
		$buffer = fgets($fp,128);
		if (strpos($buffer, "\$db_host") == 0 && is_integer(strpos($buffer, "\$db_host"))) {
			$phpbbhost = substr($buffer, strpos($buffer, "'")+1);
			$phpbbhost = substr($phpbbhost, 0, strpos($phpbbhost, "'"));
		}
		if (strpos($buffer, "\$db_name") == 0 && is_integer(strpos($buffer, "\$db_name"))) {
			$phpbbname = substr($buffer, strpos($buffer, "'")+1);
			$phpbbname = substr($phpbbname, 0, strpos($phpbbname, "'"));
		}
		if (strpos($buffer, "\$db_username") == 0 && is_integer(strpos($buffer, "\$db_username"))) {
			$phpbbuser = substr($buffer, strpos($buffer, "'")+1);
			$phpbbuser = substr($phpbbuser, 0, strpos($phpbbuser, "'"));
		}
		if (strpos($buffer, "\$db_password") == 0 && is_integer(strpos($buffer, "\$db_password"))) {
			$phpbbpass = substr($buffer, strpos($buffer, "'")+1);
			$phpbbpass = substr($phpbbpass, 0, strpos($phpbbpass, "'"));
		}
		if (strpos($buffer, "\$db_prefix") == 0 && is_integer(strpos($buffer, "\$db_prefix"))) {
			$phpbbtablepref = substr($buffer, strpos($buffer, "'")+1);
			$phpbbtablepref = substr($phpbbtablepref, 0, strpos($phpbbtablepref, "'"));
		}
		if (strpos($buffer, "\$db_type") == 0 && is_integer(strpos($buffer, "\$db_type"))) {
			$phpbbdbms = substr($buffer, strpos($buffer, "'")+1);
			$phpbbdbms = substr($phpbbdbms, 0, strpos($phpbbdbms, "'"));
		}
	}
	fclose ($fp);
	if (stristr($phpbbdbms, "mysql")) {
		$phpbbdb = @mysqli_connect("$phpbbhost", "$phpbbuser", "$phpbbpass", "$phpbbname");
		$sql = "SELECT * FROM $phpbbtablepref"."groups";
		$result = @mysqli_query($phpbbdb,$sql);
		$phpbbselectstring = "";
		if (@mysqli_num_rows($result)) {
			$phpbbselectstring = "
            <div class=\"form-group\">
                <label for=\"phpbbgroup\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3\" onclick=\"return overlib('$tip3');\" onmouseout=\"return nd();\"></a> ".PHPBBUSERGROUP."</label><select class=\"form-control\" name=\"phpbbgroup\"><option value=\"0\">".NONE."</option>";
			for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
				$phpbbgroupid = @mysqli_result($result, $i, "g_id");
				$phpbbgroupname = @mysqli_result($result, $i, "g_title");
				$phpbbselectstring .= "<option value=\"$phpbbgroupid\">$phpbbgroupname</option>";
			}
			$phpbbselectstring .= "</select></div>";
		}
		@mysqli_close($phpbbdb);
	}
}

// Get Infinity Responder autoresponders if applicable...
if ($infinitypath && file_exists("$infinitypath/config.php")) {
	$fp = fopen ("$infinitypath/config.php", "r");
	while (!feof($fp)) {
		$buffer = fgets($fp,128);
		if (strpos($buffer, "\$MySQL_server") == 0 && is_integer(strpos($buffer, "\$MySQL_server"))) {
			$infinityhost = substr($buffer, strpos($buffer, "'")+1);
			$infinityhost = substr($infinityhost, 0, strpos($infinityhost, "\""));
		}
		if (strpos($buffer, "\$MySQL_database") == 0 && is_integer(strpos($buffer, "\$MySQL_database"))) {
			$infinityname = substr($buffer, strpos($buffer, "'")+1);
			$infinityname = substr($infinityname, 0, strpos($infinityname, "'"));
		}
		if (strpos($buffer, "\$MySQL_user") == 0 && is_integer(strpos($buffer, "\$MySQL_user"))) {
			$infinityuser = substr($buffer, strpos($buffer, "'")+1);
			$infinityuser = substr($infinityuser, 0, strpos($infinityuser, "'"));
		}
		if (strpos($buffer, "\$MySQL_password") == 0 && is_integer(strpos($buffer, "\$MySQL_password"))) {
			$infinitypass = substr($buffer, strpos($buffer, "'")+1);
			$infinitypass = substr($infinitypass, 0, strpos($infinitypass, "'"));
		}
	}
	fclose ($fp);
	$infinitydb = @mysqli_connect("$infinityhost", "$infinityuser", "$infinitypass", "$infinityname");
	$sql = "SELECT * FROM InfResp_responders ORDER BY Name";
	$result = @mysqli_query($infinitydb,$sql);
	$infinityselectstring = "";
	if (@mysqli_num_rows($result)) {
		$infinityselectstring1 = "
        <div class=\"form-group\">
            <label for=\"infinityresponder\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3b','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3b\" onclick=\"return overlib('$tip3b');\" onmouseout=\"return nd();\"></a> ".ADDTOINFINITYRESPONDER."</label><select class=\"form-control\" name=\"infinityresponder\"><option value=\"0\">".NONE."</option>";
		$infinityselectstring2 = "
        <div class=\"form-group\">
            <label for=\"infinityresponderoff\">".REMOVEFROMINFINITYRESPONDER."</label><select class=\"form-control\" name=\"infinityresponderoff\"><option value=\"0\">".NONE."</option>";
		for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
			$infinityrespid = @mysqli_result($result, $i, "ResponderID");
			$infinityrespname = @mysqli_result($result, $i, "Name");
			$infinityselectstring1 .= "<option value=\"$infinityrespid\">$infinityrespname</option>";
			$infinityselectstring2 .= "<option value=\"$infinityrespid\">$infinityrespname</option>";
		}
		$infinityselectstring1 .= "</select></div>";
		$infinityselectstring2 .= "</select></div>";
	}
	@mysqli_close($infinitydb);
}

// Get Interspire Email Marketer lists if applicable...
if ($iemurl && $iemuser && $iemtoken) {
	$iemselectstring = "";
	$iemxml = "<xmlrequest><username>$iemuser</username><usertoken>$iemtoken</usertoken><requesttype>lists</requesttype><requestmethod>GetLists</requestmethod><details> </details></xmlrequest>";
	$iemch = @curl_init($iemurl);
	curl_setopt($iemch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($iemch, CURLOPT_POST, 1);
	curl_setopt($iemch, CURLOPT_POSTFIELDS, $iemxml);
	$iemresult = @curl_exec($iemch);
	if($iemresult === false) {}
	else {
		$iemselectstring .= "
        <div class=\"form-group\">
            <label for=\"infinityresponder\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3d','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3d\" onclick=\"return overlib('$tip3d');\" onmouseout=\"return nd();\"></a> ".EMAILMARKETERLIST."</label><select class=\"form-control\" name=\"iemlist\"><option value=\"0\">".NONE."</option>";
		if (strpos($iemresult,"<item>")) {
			$iemresultarray = explode("<item>",$iemresult);
			foreach($iemresultarray as $iempartnumber=>$iemxmlpart) {
				$iemlistid = 0;
				$iemlistname = "";
				if (strpos($iemxmlpart,"<listid>")) {
					$iemsubresultarray = explode("<listid>",$iemxmlpart);
					$iemsubresultarray = explode("</listid>",$iemsubresultarray[1]);
					$iemlistid = $iemsubresultarray[0];
				}
				if (strpos($iemxmlpart,"<name>")) {
					$iemsubresultarray = explode("<name>",$iemxmlpart);
					$iemsubresultarray = explode("</name>",$iemsubresultarray[1]);
					$iemlistname = $iemsubresultarray[0];
				}
				if ($iemlistid && $iemlistname) $iemselectstring .= "<option value=\"$iemlistid\">$iemlistname</option>";
			}
		}
		$iemselectstring .= "</select></div>";
	}
}

   $db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Generate Digital Mall member list if needed...
if ($userid == "1" && file_exists("$ashoppath/members/index.php") && $digitalmall != "OFF") {
	// Check if we are in a member owned category...
	$result = @mysqli_query($db,"SELECT userid FROM category WHERE categoryid='$cat'");
	$catuser = @mysqli_result($result, 0, "userid");
	$memberlist = "<select name=\"memberid\" class=\"form-control\"><option value=\"1\">".ADMINISTRATOR;
	$result = @mysqli_query($db,"SELECT * FROM user WHERE userid>1 ORDER BY shopname");
	while ($row = @mysqli_fetch_array($result)) {
		$memberlist .= "<option value=\"{$row["userid"]}\"";
		if ($catuser == $row["userid"]) $memberlist .= " selected";
		$memberlist .= ">{$row["shopname"]}";
	}
	$memberlist .= "</select>";
}

// Generate floating price activation time...
$fp_activate = date("Y-m-d H:i", time()+$timezoneoffset);

   // Make sure special characters are handled properly...
   $name = str_replace("\"", "&quot;", $name);
   //$name = str_replace("'", "&#039;", $name);
   //$description = str_replace("'", "&#039;", $description);

if (!$name || $price == '' || $addlicense || $addfloatingprice || $removefloatingprice) {
	if (!empty($description)) $description = str_replace("\\\"","\"",$description);

  $sql="SELECT name FROM category WHERE categoryid = $cat";
  $result = @mysqli_query($db,$sql);
  $categoryname = @mysqli_result($result, $j, "name");
  echo "$header";
	  if (is_dir("$ashoppath/admin/ckeditor") && file_exists("$ashoppath/admin/ckeditor/ckeditor.js")) {
		  echo "
<script type=\"text/javascript\" src=\"ckeditor/ckeditor.js\"></script>
";
	  }
  echo "
    <section class=\"content-header\"><h1>".ADDPRODUCTTOCATEGORY.": $categoryname</h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"addproduct.php\" method=\"post\" name=\"productform\" enctype=\"multipart/form-data\">
                <div class=\"box-body\">
                    <div class=\"form-group\">".admin_inputfield(array("label" => NAME, "name" => "name", "value" => $name, "helpnumber" => 4, "helptext" => $tip4))."</div>";
		if ($userid == "1" && file_exists("$ashoppath/members/index.php") && $digitalmall != "OFF") echo "
                    <div class=\"form-group\">
                        <label for=\"memberid\">".OWNERMEMBER."</label>
                        $memberlist
                    </div>";
		if ($userid == "1") {
			echo "
                    <div class=\"form-group\"><label><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image5','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image5\" align=\"absmiddle\" onclick=\"return overlib('$tip5');\" onmouseout=\"return nd();\"></a> ".CATALOGSTATUS."</label>
                    ";
                    if($wholesalecatalog && (!$addfloatingprice && (!$fp_length || $removefloatingprice))) echo admin_checkbox(array("label" => ACTIVE." ".RETAIL, "name" => "active", "checked" => TRUE)).admin_checkbox(array("label" => WHOLESALE, "name" => "wholesale", "checked" => TRUE));
                    else echo admin_checkbox(array("label" => ACTIVE." ".RETAIL, "name" => "active", "checked" => TRUE));
                    echo "
                    </div>
                    <div class=\"form-group\">
                        <label for=\"featured\">".FEATUREDSPOT."</label>
                        <select name=\"featured\" class=\"form-control\"><option value=\"0\">".NO."</option>";
			for ($featuredspot = 1; $featuredspot <= $numberoffeatures; $featuredspot++) {
				echo "<option value=\"$featuredspot\">$featuredspot</option>";
			}
			echo "</select></div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => EBAYID, "name" => "ebayid", "value" => $ebayid, "helpnumber" => 6, "helptext" => $tip6, "helplink" => $help6, "explanation" => OPTIONAL))."</div>";
		}

		// Show price parameters...        
		if ($addfloatingprice || ($fp_length && !$removefloatingprice)) {
            echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => STARTPRICE, "name" => "price", "value" => $price, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>
                    <div class=\"form-group\"><input type=\"hidden\" name=\"removefloatingprice\" value=\"\">
                    <button type=\"submit\" class=\"btn btn-primary btn-block\" value=\"".FIXEDPRICE."\" onClick=\"document.productform.removefloatingprice.value='true';document.productform.submit();\">".FIXEDPRICE."</button></div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => BIDINCREMENT, "name" => "priceincrement", "value" => $priceincrement, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LENGTH, "name" => "bidlengthdays", "value" => $bidlengthdays, "suffix" => DAYS))
                    .admin_inputfield(array("name" => "bidlengthhours", "value" => $bidlengthhours, "suffix" => HOURS))
                    .admin_inputfield(array("name" => "bidlengthminutes", "value" => $bidlengthminutes, "suffix" => MINUTES))
                    .admin_inputfield(array("name" => "bidlengthseconds", "value" => $bidlengthseconds, "suffix" => SECONDS))."
                    </div>
                    <div class=\"form-group\"><label>".ACTIVATE."</label>
                    <div class=\"input-group date\">
                        <div class=\"input-group-addon\">
                            <i class=\"fa fa-calendar\"></i>
                        </div>
                        <input type=\"text\" class=\"form-control pull-right\" id=\"activatedate\" name=\"activatedate\" value=\"$fp_activate\">
                    </div>
                    </div>
                    <div class=\"form-group\"><label for=\"auctiontype\">".AUCTIONTYPE."</label><select name=\"auctiontype\" class=\"form-control\"><option value=\"standard\">".STANDARD."</option><option value=\"penny\">".PENNY."</option></select></div>";
                    $pagescript = "
                    <script>
                        $(function () {
                            $('#activatedate').daterangepicker({ singleDatePicker: true, timePicker: true, timePickerIncrement: 5, timePicker24Hour: true, locale: { format: 'YYYY-MM-DD HH:mm' }});
                        })
                    </script>";
		} else {
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => PRICE, "name" => "price", "value" => $price, "helpnumber" => 7, "helptext" => $tip7, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>
                    <input type=\"hidden\" name=\"addfloatingprice\" value=\"\">
                    <div class=\"form-group\"><button type=\"submit\" class=\"btn btn-primary btn-block\" value=\"".AUCTION."\" onClick=\"document.productform.addfloatingprice.value='true';document.productform.submit();\">".AUCTION."</button>
                    </div>";
		}

		if ($wholesalecatalog && ($advancedmallmode == "1" || $userid == "1")) {
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => WHOLESALEPRICE, "name" => "wholesaleprice", "value" => $wholesaleprice, "helpnumber" => 8, "helptext" => $tip8, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>";
			if ($pricelevels > 1) {
				for ($thislevel = 2; $thislevel <= $pricelevels; $thislevel++) {
					echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => WHOLESALEPRICELEVEL." $thislevel", "name" => "wholesaleprice$thislevel", "value" => $_POST["wholesaleprice$thislevel"], "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>";
				}
			}
		}
		if ($userid == "1" && file_exists("$ashoppath/emerchant/quote.php")) $billtemplateresult = @mysqli_query($db,"SELECT * FROM emerchant_billtemplates ORDER BY name");
		$recurringresult = @mysqli_query($db,"SELECT recurringperiod FROM payoptions WHERE (gateway='ccbill' OR gateway='paypal' OR gateway='payza' OR gateway='netbillingrecurring') AND recurringperiod IS NOT NULL AND recurringperiod!=''");
		if (@mysqli_num_rows($billtemplateresult) || @mysqli_num_rows($recurringresult)) {
			if (empty($nrecurringperiod)) {
				$nrecurringperiod = @mysqli_result($recurringresult, 0, "recurringperiod");
				$nrecurringperiod = explode("|",$nrecurringperiod);
				$nrecurringperiodunits = $nrecurringperiod[1];
				$nrecurringperiod = $nrecurringperiod[0];
			}
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => RECURRINGPRICE, "name" => "recurringprice", "value" => $recurringprice, "prefix" => $currencysymbols[$ashopcurrency]["pre"], "suffix" => $currencysymbols[$ashopcurrency]["post"]))."</div>";
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => RECURRINGPERIOD, "name" => "nrecurringperiod", "value" => $nrecurringperiod, "suffix" => DAYS))."
                    <select name=\"nrecurringperiodunits\" class=\"form-control\"><option value=\"D\""; if ($nrecurringperiodunits == "D") echo " selected"; echo ">".DAYS."</option><option value=\"W\""; if ($nrecurringperiodunits == "W") echo " selected"; echo ">".WEEKS."</option><option value=\"M\""; if ($nrecurringperiodunits == "M") echo " selected"; echo ">".MONTHS."</option><option value=\"Y\""; if ($nrecurringperiodunits == "Y") echo " selected"; echo ">".YEARS."</option></select>
                    </div>";
		}
		if ($userid == "1" && @mysqli_num_rows($billtemplateresult)) {
			echo "
                    <div class=\"form-group\">
                        <label for=\"billtemplate\">".BILLINGTEMPLATE."</label>
                        <select name=\"billtemplate\" class=\"form-control\"><option value=\"none\" selected>".NONE;
			while ($billtemplaterow = @mysqli_fetch_array($billtemplateresult)) {
				$billtemplatename = $billtemplaterow["name"];
				$billtemplateid = $billtemplaterow["billtemplateid"];
				echo "<option value=\"$billtemplateid\">$billtemplatename";
			}
			echo "</select></div>";
		}
        echo "
                    <div class=\"form-group\">".admin_textbox(array("label" => RECEIPTTEXT, "name" => "receipttext", "value" => $receipttext))."</div>";
		if ($userid != "1" && !$description) echo "<div class=\"form-group\">".admin_textbox(array("label" => DESCRIPTION, "name" => "description", "value" => $memberproducttemplate, "WYSIWYG" => TRUE, "helpnumber" => 9, "helptext" => $tip9))."</div>";
		else echo "<div class=\"form-group\">".admin_textbox(array("label" => DESCRIPTION, "name" => "description", "value" => $description, "WYSIWYG" => TRUE, "helpnumber" => 9, "helptext" => $tip9))."</div>";
		if (is_dir("$ashoppath/admin/ckeditor") && file_exists("$ashoppath/admin/ckeditor/ckeditor.js")) echo "<script type=\"text/javascript\">
		CKEDITOR.replace( 'description', {
			// Define the toolbar groups as it is a more accessible solution.
			toolbarGroups: [
				{\"name\":\"basicstyles\",\"groups\":[\"basicstyles\"]},
				{\"name\":\"links\",\"groups\":[\"links\"]},
				{\"name\":\"paragraph\",\"groups\":[\"list\",\"blocks\"]},
				{\"name\":\"document\",\"groups\":[\"mode\"]},
				{\"name\":\"insert\",\"groups\":[\"insert\"]},
				{\"name\":\"styles\",\"groups\":[\"styles\"]},
				{\"name\":\"colors\",\"groups\":[\"colors\"]}
			],
			// Remove the redundant buttons from toolbar groups defined above.
			removeButtons: 'Underline,Strike,Subscript,Superscript,Anchor,Styles,Specialchar'
		} );
		</script>";
		echo "
                    <div class=\"form-group\">
                        <label for=\"licensetext\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image10','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image10\" align=\"absmiddle\" onclick=\"return overlib('$tip10');\" onmouseout=\"return nd();\"></a> <a href=\"$help10\" class=\"helpnav2\" target=\"_blank\">".LICENSEAGREEMENT."</a></label>";
		if ($addlicense) echo "<textarea class=\"form-control name=\"licensetext\" id=\"licensetext\"></textarea>";
		else echo "<input type=\"hidden\" name=\"addlicense\" value=\"\">
        <button type=\"submit\" class=\"btn btn-primary btn-block\" value=\"".ADDLICENSEAGREEMENT."\" onClick=\"document.productform.addlicense.value='true';document.productform.submit();\">".ADDLICENSEAGREEMENT."</button>";
		echo "</div>";
        $radioaddon = "
                        <label><input type=\"radio\" name=\"affcomtype\" value=\"percent\" checked> %</label>
                        <label><input type=\"radio\" name=\"affcomtype\" value=\"money\"> ";
		if ($currencysymbols[$ashopcurrency]["pre"]) $radioaddon .= $currencysymbols[$ashopcurrency]["pre"];
		else if ($currencysymbols[$ashopcurrency]["post"]) $radioaddon .= $currencysymbols[$ashopcurrency]["post"];
        $radioaddon .= "</label>";
        echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => AFFILIATECOMMISSION, "name" => "affiliatecom", "value" => $affiliatepercent, "helpnumber" => 14, "helptext" => $tip14, "helplink" => $help14, "suffix" => $radioaddon))."</div>";
		if ($wholesaleaffiliate == "1") {
            $radioaddon = "
                        <label><input type=\"radio\" name=\"affwscomtype\" value=\"percent\" checked> %</label>
                        <label><input type=\"radio\" name=\"affwscomtype\" value=\"money\"> ";
            if ($currencysymbols[$ashopcurrency]["pre"]) $radioaddon .= $currencysymbols[$ashopcurrency]["pre"];
            else if ($currencysymbols[$ashopcurrency]["post"]) $radioaddon .= $currencysymbols[$ashopcurrency]["post"];
            $radioaddon .= "</label>";
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => WSAFFILIATECOMMISSION, "name" => "affiliatewscom", "value" => $wholesalepercent, "suffix" => $radioaddon))."</div>";
		}
		if ($userid == "1") {
            $radioaddon = "
                        <label><input type=\"radio\" name=\"affcomtype2\" value=\"percent\" checked> %</label>
                        <label><input type=\"radio\" name=\"affcomtype2\" value=\"money\"> ";
            if ($currencysymbols[$ashopcurrency]["pre"]) $radioaddon .= $currencysymbols[$ashopcurrency]["pre"];
            else if ($currencysymbols[$ashopcurrency]["post"]) $radioaddon .= $currencysymbols[$ashopcurrency]["post"];
            $radioaddon .= "</label>";
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => UPGRADEDAFFILIATECOMMISSION, "name" => "affiliatecom2", "value" => $affiliatepercent2, "suffix" => $radioaddon))."</div>";
            $radioaddon = "
                        <label><input type=\"radio\" name=\"afftier2comtype\" value=\"percent\" checked> %</label>
                        <label><input type=\"radio\" name=\"afftier2comtype\" value=\"money\"> ";
            if ($currencysymbols[$ashopcurrency]["pre"]) $radioaddon .= $currencysymbols[$ashopcurrency]["pre"];
            else if ($currencysymbols[$ashopcurrency]["post"]) $radioaddon .= $currencysymbols[$ashopcurrency]["post"];
            $radioaddon .= "</label>";
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => TIER2COMMISSION, "name" => "affiliatetier2com", "value" => $secondtierpercent, "suffix" => $radioaddon))."</div>";
            $radioaddon = "
                        <label><input type=\"radio\" name=\"afftier2comtype2\" value=\"percent\" checked> %</label>
                        <label><input type=\"radio\" name=\"afftier2comtype2\" value=\"money\"> ";
            if ($currencysymbols[$ashopcurrency]["pre"]) $radioaddon .= $currencysymbols[$ashopcurrency]["pre"];
            else if ($currencysymbols[$ashopcurrency]["post"]) $radioaddon .= $currencysymbols[$ashopcurrency]["post"];
            $radioaddon .= "</label>";
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => UPGRADEDTIER2COMMISSION, "name" => "affiliatetier2com2", "value" => $secondtierpercent2, "suffix" => $radioaddon))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => LOWERBY, "name" => "affiliatetierlowerby", "value" => 0, "suffix" => ONEACHTIER, "explanation" => DISABLEMULTITIER))."</div>
                    <div class=\"form-group\">
                        <label for=\"affiliaterepeatcommission\">".ONREPEATORDERS."</label>
                        <select name=\"affiliaterepeatcommission\" class=\"form-control\"><option value=\"1\">Yes</option><option value=\"0\">No</option></select>
                    </div>
                    <div class=\"form-group\">
                        <label for=\"taxable\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image15','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image15\" align=\"absmiddle\" onclick=\"return overlib('$tip15');\" onmouseout=\"return nd();\"></a> ".SALESTAX."</label>
                        <select name=\"taxable\" class=\"form-control\"><option value=\"0\""; if ($taxable == "0") echo " selected"; echo ">".NO."<option value=\"1\""; if ($taxable == "1") echo " selected"; echo ">".YES."<option value=\"2\""; if ($taxable == "2") echo " selected"; echo ">".LEVEL2."</select>
                    </div>";
			if ($activateautoresponder == "1" && !empty($autoresponderid) && is_numeric($autoresponderid)) {
				$sql = "SELECT * FROM autoresponders ORDER BY name";
				$result = @mysqli_query($db,$sql);
				if (@mysqli_num_rows($result)) {
					echo "
                    <div class=\"form-group\">
                        <label for=\"autoresponder\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image3c','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image3c\" align=\"absmiddle\" onclick=\"return overlib('$tip3c');\" onmouseout=\"return nd();\"></a> ".ADDTOAUTORESPONDER."</label>
                        <select class=\"form-control\" name=\"autoresponder\"><option value=\"0\">".NONE."</option>";
					for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
						$responderid = @mysqli_result($result, $i, "responderid");
						$respondername = @mysqli_result($result, $i, "name");
						echo "<option value=\"$responderid\">$respondername</option>";
					}
					echo "</select></div>
                    <div class=\"form-group\">
                        <label for=\"autoresponderoff\">".REMOVEFROMAUTORESPONDER."</label>
                        <select class=\"form-control\" name=\"autoresponderoff\"><option value=\"0\">".NONE."</option>";
					for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
						$responderid = @mysqli_result($result, $i, "responderid");
						$respondername = @mysqli_result($result, $i, "name");
						echo "<option value=\"$responderid\">$respondername</option>";
					}
					echo "</select></div>";
				}
			} else if (!empty($aweberauthcode)) {
				$sql = "SELECT * FROM autoresponders ORDER BY name";
				$result = @mysqli_query($db,$sql);
				if (@mysqli_num_rows($result)) {
					echo "
                    <div class=\"form-group\">
                        <label for=\"autoresponderoff\">AWeber List:</label>
                        <select class=\"form-control\" name=\"autoresponder\"><option value=\"0\">".NONE."</option>";
					for ($i = 0; $i < @mysqli_num_rows($result); $i++) {
						$responderid = @mysqli_result($result, $i, "responderid");
						$respondername = @mysqli_result($result, $i, "name");
						echo "<option value=\"$responderid\">$respondername</option>";
					}
					echo "</select></div>";
				}
			}

			if ($infinityselectstring1) echo $infinityselectstring1;
			if ($infinityselectstring2) echo $infinityselectstring2;
			if ($mcselectstring) echo $mcselectstring;
			if ($iemselectstring) echo $iemselectstring;
			if ($phpbbselectstring) echo $phpbbselectstring;
		}
		echo "
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-primary pull-right\" value=\"".SUBMIT."\" name=\"submitbutton\">".SUBMIT."</button>
				</div>
                <input type=\"hidden\" name=\"cat\" value=\"$cat\"><input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\"><input type=\"hidden\" name=\"search\" value=\"$search\">
             </form></div></div></div></section>";
        $footer = str_replace("<!-- pagescript -->", $pagescript, $footer);
		echo $footer;
} else {
	// Convert money format...
	$price = str_replace($thousandchar,"",$price);
	$price = str_replace($decimalchar,".",$price);
	$wholesaleprice = str_replace($thousandchar,"",$wholesaleprice);
	$wholesaleprice = str_replace($decimalchar,".",$wholesaleprice);
	$wspricelevels = "";
	if ($pricelevels > 1) {
		for ($thislevel = 2; $thislevel <= $pricelevels; $thislevel++) {
			$thislevelprice = $_POST["wholesaleprice$thislevel"];
			$thislevelprice = str_replace($thousandchar,"",$thislevelprice);
			$thislevelprice = str_replace($decimalchar,".",$thislevelprice);
			$wspricelevels .= $thislevelprice."|";
		}
		$wspricelevels = substr($wspricelevels,0,-1);
	}
	$priceincrement = str_replace($thousandchar,"",$priceincrement);
	$priceincrement = str_replace($decimalchar,".",$priceincrement);
	$recurringprice = str_replace($thousandchar,"",$recurringprice);
	$recurringprice = str_replace($decimalchar,".",$recurringprice);
	$affiliatecom = str_replace($thousandchar,"",$affiliatecom);
	$affiliatecom = str_replace($decimalchar,".",$affiliatecom);
	$affiliatewscom = str_replace($thousandchar,"",$affiliatewscom);
	$affiliatewscom = str_replace($decimalchar,".",$affiliatewscom);
	$affiliatecom2 = str_replace($thousandchar,"",$affiliatecom2);
	$affiliatecom2 = str_replace($decimalchar,".",$affiliatecom2);
	$affiliatetier2com = str_replace($thousandchar,"",$affiliatetier2com);
	$affiliatetier2com = str_replace($decimalchar,".",$affiliatetier2com);
	$affiliatetier2com2 = str_replace($thousandchar,"",$affiliatetier2com2);
	$affiliatetier2com2 = str_replace($decimalchar,".",$affiliatetier2com2);
	$affiliatetierlowerby = str_replace($thousandchar,"",$affiliatetierlowerby);
	$affiliatetierlowerby = str_replace($decimalchar,".",$affiliatetierlowerby);

   if (!$memberid) $memberid = $userid;
   if ($userid == "1" && $featured > 0) @mysqli_query($db,"UPDATE product SET featured='0' WHERE featured='$featured'");
   // Check max affiliate commission for member products...
   if ($userid != "1") {
	   if ($affiliatecom && $affcomtype == "money") {
		   $memberresult = @mysqli_query($db,"SELECT commissionlevel FROM user WHERE userid='$userid'");
		   $commissionlevel = @mysqli_result($memberresult, 0, "commissionlevel");
		   if ($commissionlevel > 75) $commissionlevel = 75;
		   $commissionlevel = $commissionlevel/100;
		   $maxcommission = number_format($price*$commissionlevel,2,'.','');
		   if ($affiliatecom > $maxcommission) $affiliatecom = $maxcommission;
	   } else if ($affiliatecom > 75) $affiliatecom = 75;
	   if ($affiliatewscom && $affwscomtype == "money") {
		   $memberresult = @mysqli_query($db,"SELECT commissionlevel FROM user WHERE userid='$userid'");
		   $commissionlevel = @mysqli_result($memberresult, 0, "commissionlevel");
		   if ($commissionlevel > 75) $commissionlevel = 75;
		   $commissionlevel = $commissionlevel/100;
		   $maxcommission = number_format($price*$commissionlevel,2,'.','');
		   if ($affiliatewscom > $maxcommission) $affiliatewscom = $maxcommission;
	   } else if ($affiliatewscom > 75) $affiliatewscom = 75;
   }
   $sql="INSERT INTO product (name, price, description, receipttext, userid, featured) VALUES ('$name','$price','$description','$receipttext','$memberid','$featured')";
   $result = @mysqli_query($db,$sql);
   $product_id = @mysqli_insert_id($db);
   $sql="UPDATE product SET ordernumber='$product_id'";
   // Check if the product is in a main shop category...
   if ($memberid > "1" && !empty($cat) && is_numeric($cat)) {
	   $catresult = @mysqli_query($db,"SELECT * FROM category WHERE categoryid='$cat'");
	   $catowner = @mysqli_result($catresult,0,"userid");
	   $memberclone = @mysqli_result($catresult,0,"memberclone");
	   if ($memberclone == "1" && $catowner == "1") $sql .= ", inmainshop='1'";
   }
   if ($userid != "1" && $memberactivate) $active = "on";
   if ($active == "on") $sql.=", active='1'";
   else $sql.=", active='0'";
   if ($userid != "1" && $memberactivate) $wholesale = "on";
   if ($wholesale == "on" && !$priceincrement) $sql.=", wholesaleactive='1'";
   else $sql.=", wholesaleactive='0'";
   if ($taxable == "1") $sql.=", taxable='1'";
   else if ($taxable == "2") $sql.=", taxable='2'";
   if ($billtemplate) $sql.=", billtemplate='$billtemplate'";
   if ($licensetext) $sql.=", licensetext='$licensetext'";
   if ($lmgroup) $sql.=", listmessengergroup='$lmgroup'";
   if ($lmpgroup) $sql.=", listmaillist='$lmpgroup'";
   if ($iemlist) $sql.=", iemlist='$iemlist'";
   if ($mclist) $sql.=", mailchimplist='$mclist'";
   if ($phpbbgroup) $sql.=", phpbbgroup='$phpbbgroup'";
   if ($arpresponder) $sql.=", arpresponder='$arpresponder'";
   if ($arpreachresponder) $sql.=", arpreachresponder='$arpreachresponder'";
   if (isset($autoresponder)) $sql .= ", autoresponder='$autoresponder'";
   if (isset($autoresponderoff)) $sql .= ", autoresponderoff='$autoresponderoff'";
   if ($infinityresponder) $sql.=", infresponder='$infinityresponder'";
   if ($infinityresponderoff && $infinityresponderoff != $infinityresponder) $sql.=", infresponderoff='$infinityresponderoff'";
   if ($ebayid) $sql.=", ebayid='$ebayid'";
   if ($wholesaleprice) $sql.=", wholesaleprice='$wholesaleprice'";
   if ($wspricelevels) $sql.=", wspricelevels='$wspricelevels'";
   if (!$affiliatecom) $affiliatecom = "0";
   $affiliatecomstring = $affiliatecom."a$affcomtype";
   $sql.=", affiliatecom='$affiliatecomstring'";
   if (!$affiliatewscom) $affiliatewscom = "0";
   $affiliatewscomstring = $affiliatewscom."a$affwscomtype";
   $sql.=", affiliatewscom='$affiliatewscomstring'";
   if (!$affiliatecom2) $affiliatecom2 = "0";
   $affiliatecom2string = $affiliatecom2."a$affcomtype2";
   $sql.=", affiliatecom2='$affiliatecom2string'";
   if (empty($affiliatetier2com)) $affiliatetier2com = 0;
   if (empty($affiliatetier2com2)) $affiliatetier2com2 = 0;
   if (empty($affiliatetierlowerby)) $affiliatetierlowerby = 0;
   if ($afftier2comtype != "percent" && $afftier2comtype != "money") $afftier2comtype = "percent";
   if ($afftier2comtype2 != "percent" && $afftier2comtype2 != "money") $afftier2comtype2 = "percent";
   $affiliatetiercom = $affiliatetier2com."a".$afftier2comtype."|".$affiliatetier2com2."a".$afftier2comtype2."|".$affiliatetierlowerby;
   $sql.=", affiliatetiercom='$affiliatetiercom'";
   if (empty($affiliaterepeatcommission) || $affiliaterepeatcommission != "1") $affiliaterepeatcommission = 0;
   $sql.=", affiliaterepeatcommission='$affiliaterepeatcommission'";

   if ($recurringprice) $sql .= ", recurringprice='$recurringprice'";

   if ($recurringprice && $nrecurringperiod) $sql .= ", recurringperiod='$nrecurringperiod|$nrecurringperiodunits'";
   else $sql .= ", recurringperiod=NULL";

   $sql.=" WHERE productid='$product_id'";
   $result = @mysqli_query($db,$sql);

   $sql="INSERT INTO productcategory (productid,categoryid) VALUES ($product_id,$cat)";
   $result = @mysqli_query($db,$sql);

   // Add floating price...
   $bidlength = $bidlengthdays*86400;
   $bidlength += $bidlengthhours*3600;
   $bidlength += $bidlengthminutes*60;
   $bidlength += $bidlengthseconds;
   if ($priceincrement && $bidlength) {
	   $activatetimestamp = strtotime($activatedate);
	   if ($auctiontype == "standard") @mysqli_query($db,"INSERT INTO floatingprice (productid, startprice, originalstartprice, length, priceincrement, activatetime, starttime, type) VALUES ('$product_id', '$price', '$price', '$bidlength', '$priceincrement', '$activatetimestamp', '$activatetimestamp', '$auctiontype')");
	   else @mysqli_query($db,"INSERT INTO floatingprice (productid, startprice, originalstartprice, length, priceincrement, activatetime, type) VALUES ('$product_id', '$price', '$price', '$bidlength', '$priceincrement', '$activatetimestamp', '$auctiontype')");
   }

   if ($userid != "1" && !$memberactivate) {
	   $result = @mysqli_query($db,"SELECT prefvalue FROM preferences WHERE prefname='ashopname'");
	   $ashopname = @mysqli_result($result, 0, "prefvalue");
	   $result = @mysqli_query($db,"SELECT * FROM user WHERE userid='$userid'");
	   $membershopname = @mysqli_result($result, 0, "shopname");
	   $membershopemail = @mysqli_result($result, 0, "email");
	   $message="<html><head><title>$ashopname - ".MEMBERPRODUCTACTIVATION."</title></head><body><font face=\"$font\"><p>".MEMBER." <b>$userid: $membershopname</b> ".HASADDEDAPRODUCT." <a href=\"$ashopurl/admin/login.php?prodactivate=$product_id\">".VERIFYPRODUCT."</a></p></font></body></html>";
	   $headers = "From: ".un_html($ashopname)."<$ashopemail>\nX-Sender: <$ashopemail>\nX-Mailer: PHP\nX-Priority: 3\nReturn-Path: <$ashopemail>\nMIME-Version: 1.0\nContent-Type: text/html; charset=iso-8859-1\n";

	   @ashop_mail("$ashopemail",un_html($ashopname)." - ".MEMBERPRODUCTACTIVATION,"$message","$headers");
   }

   if ($error) header ("Location: editcatalogue.php?cat=$cat&error=$error&resultpage=$resultpage&search=$search");
   else {
	   if ($userid != "1" && !$advancedmallmode) header("Location: editfiles.php?add=$product_id&cat=$cat&resultpage=$resultpage&search=$search");
	   else header ("Location: pagegenerator.php?add=$product_id&cat=$cat&resultpage=$resultpage&search=$search");
   }
}
?>