<?php
// AShop
// Copyright 2002-2018 - All Rights Reserved Worldwide
// http://www.ashopsoftware.com
// This software is licensed per individual site.
// By installing or using this software, you agree to the licensing terms,
// which are located at http://www.ashopsoftware.com/license.htm
// Unauthorized use or distribution of this software 
// is a violation U.S. and international copyright laws.

unset($shop);
include "admin/checklicense.inc.php";
if (!$membershops || !$enablemall) {
	header("Location: index.php");
	exit;
}
include "admin/ashopconstants.inc.php";
include "counter.php";

// Apply selected theme...
$buttonpath = "";
$templatepath = "/templates";
if ($ashoptheme && $ashoptheme != "none" && file_exists("$ashoppath/themes/$ashoptheme/theme.cfg.php")) include "themes/$ashoptheme/theme.cfg.php";
if ($usethemebuttons == "true") $buttonpath = "themes/$ashoptheme/";
if ($usethemetemplates == "true") $templatepath = "/themes/$ashoptheme";
if ($lang && is_array($themelanguages)) {
	if (!in_array("$lang",$themelanguages)) unset($lang);
}

// Include language file...
if (!isset($lang) || !preg_match("/[a-z]+/", $lang) || strlen($lang) > 2) $lang = $defaultlanguage;
include "language/$lang/mall.inc.php";

// Show "Please wait" page while completing the search...
if($searchstring && !$showresult) {
	echo "<html><head><title>".SEARCHING."</title>\n".CHARSET."<style type=\"text/css\"><!-- .fontsize1 { font-size: {$fontsize1}px}\n.fontsize2 { font-size: {$fontsize2}px}\n.fontsize3 { font-size: {$fontsize3}px}--></style></head><body bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\"><table width=\"100%\" border=\"0\" height=\"100%\"><tr><td align=\"center\" valign=\"middle\"><font face=\"$font\" size=\"4\"><span class=\"fontsize2\"><b>".SEARCHING."</b></span></font><br></center><meta http-equiv=\"Refresh\" content=\"0; URL=mall.php?searchstring=$searchstring&showresult=true\"><br><br><br><br><br><br></td></tr></table></body></html>";
	exit;
} else if ($searchcategories && !$showresult) {
	echo "<html><head><title>".SEARCHING."</title>\n".CHARSET."<style type=\"text/css\"><!-- .fontsize1 { font-size: {$fontsize1}px}\n.fontsize2 { font-size: {$fontsize2}px}\n.fontsize3 { font-size: {$fontsize3}px}--></style></head><body onload=\"document.searchform.submit();\" bgcolor=\"$bgcolor\" text=\"$textcolor\" link=\"$linkcolor\"><table width=\"100%\" border=\"0\" height=\"100%\"><tr><td align=\"center\" valign=\"middle\"><font face=\"$font\" size=\"4\"><span class=\"fontsize2\"><b>".SEARCHING."</b></span></font><br></center>
	<form name=\"searchform\" action=\"mall.php\" method=\"post\">
		<input type=\"hidden\" name=\"showresult\" value=\"true\"><input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">";
	foreach($searchcategories as $key => $value) echo "<input type=\"hidden\" name=\"searchcategories[$key]\" value=\"$value\">";
	echo "</form><br><br><br><br><br><br></td></tr></table></body></html>";
	exit;
}
ob_start();

// Open database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");
if (!$db) $error = 1;

// Print header from template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/mall-$lang.html")) ashop_showtemplateheader("$ashoppath$templatepath/mall-$lang.html");
else ashop_showtemplateheader("$ashoppath$templatepath/mall.html");

// List categories...
echo "
<div class=\"span3\">
<h4>".CATEGORIES."</h4>
	  <p><form action=\"mall.php\" method=\"post\">
              <div class=\"control-group\"> <select name=\"searchcategories[]\" size=\"5\" multiple><option value=\"all\">".ALLCATEGORIES."<option value=\"new\">".NEWSHOPS;
$categories = @mysqli_query($db,"SELECT * FROM shopcategory ORDER BY name");
while ($row = @mysqli_fetch_array($categories)) echo "<option value=\"{$row["categoryid"]}\">{$row["name"]}";
echo "</select></div><button class=\"btn btn-inverse\">".SEARCH."</button></form></p>
<h4>".TEXT."</h4>
<p><form action=\"mall.php\" method=\"post\"><div class=\"control-group\"><input type=\"text\" size=\"19\" name=\"searchstring\" style=\"\"></div><button class=\"btn btn-inverse\">".SEARCH."</button></form></p>
</div>
<div class=\"span9\">\n<h4 class=\"title\"><span class=\"text\">";

// Show search page header...
if ($searchcategories[0] == "new") $searchcategories = "";
if ($searchstring || $searchcategories) echo SEARCHRESULT;
else echo LATESTADDITIONS;
echo ":</span></h4><ul class=\"thumbnails listing-products\">";

// List found shops...
if ($searchstring) {
    $searchwords = explode(" ", $searchstring);
    $sql="SELECT * from user WHERE password > '' AND";
	foreach($searchwords as $wordnumber => $thisword) {
		if ($wordnumber == 0) $sql.=" (UPPER(shopdescription) LIKE '%".strtoupper($thisword)."%' OR UPPER(shopname) LIKE '%".strtoupper($thisword)."%')";
		else $sql.=" AND (UPPER(shopdescription) LIKE '%".strtoupper($thisword)."%' OR UPPER(shopname) LIKE '%".strtoupper($thisword)."%')";
	}
	$sql.=" ORDER BY userid";
} else if ($searchcategories[0] == "all") {
	$sql = "SELECT * FROM user WHERE userid!='1' AND password > '' ORDER BY userid ASC";
} else if ($searchcategories) {
	$sql = "SELECT DISTINCT user.* FROM user, membercategory WHERE user.password > '' AND user.userid=membercategory.userid AND (";
	$categorynumber = 0;
	foreach ($searchcategories as $key => $value) {
		if ($categorynumber == 0) $sql .= "membercategory.categoryid='$value'";
		else $sql .= " OR membercategory.categoryid='$value'";
		$categorynumber++;
	}
	$sql .= ")";
} else $sql = "SELECT * FROM user WHERE userid!='1' AND password > '' ORDER BY userid DESC LIMIT 10";
$displayitems = 10;
$result = @mysqli_query($db,$sql);
$numberofrows = intval(@mysqli_num_rows($result));
$numberofpages = ceil($numberofrows/$displayitems);
if ($resultpage > 1) $startrow = (intval($resultpage)-1) * $displayitems;
else {
	$resultpage = 1;
	$startrow = 0;
}
$startpage = $resultpage - 9;
if ($numberofpages - $resultpage < 10) {
	$pagesleft = $numberofpages - $resultpage;
	$startpage = $startpage - (10 - $pagesleft);
}
if ($startpage < 1) $startpage = 1;
$stoprow = $startrow + $displayitems;
@mysqli_data_seek($result, $startrow);
$thisrow = $startrow;
while (($row = @mysqli_fetch_array($result)) && ($thisrow < $stoprow)) {
	$thisrow++;
	$userid = $row["userid"];
	$shopname = $row["shopname"];
	$shopdescription = $row["shopdescription"];
	$url = $row["url"];

	if (!empty($cpanelapiuser) && !empty($cpanelapipass) && !empty($cpanelapiurl)) {
		echo "<li class=\"span9\">
		<h5>$thisrow) <a href=\"$url\" target=\"_blank\" class=\"title\">$shopname</a></h5>
        <p>$shopdescription</p>
		<p>[ <a href=\"$url\" target=\"_blank\">".WEBSITE."</a> ] [ <a href=\"$url/affiliate/signupform.php\">".PROMOTESHOP."</a> ]</p>
		</li>";
	} else {
		if (!$url) $url = $ashopurl."/index.php?shop=$userid";

		echo "<li class=\"span9\">
		<h5>$thisrow) <a href=\"index.php?shop=$userid\" target=\"_blank\" class=\"title\">$shopname</a></h5>
        <p>$shopdescription</p>
		<p>[ <a href=\"$url\">".WEBSITE."</a> ]";
		if (file_exists("$ashoppath/affiliate/shoplink.php")) echo " [ <a href=\"affiliate/shoplink.php?promoteshop=$userid\">".PROMOTESHOP."</a> ]</p>
		</li>";
	}
}
echo "</ul>";

$searchcategoriesurl = "";
if (is_array($searchcategories)) foreach ($searchcategories as $key=>$value) $searchcategoriesurl .= "&searchcategories[$key]=$value";

if ($numberofpages > 1) {
    echo "\n<hr>\n<div class=\"pagination pagination-small pagination-centered\">\n<ul>\n";
	if ($resultpage > 1) {
		$previouspage = $resultpage-1;
		echo "<li><a href=\"mall.php?searchstring=$searchstring$searchcategoriesurl&resultpage=$previouspage\">".PREVIOUS."</a></li>\n";
	}
	$page = 1;
	for ($i = $startpage; $i <= $numberofpages; $i++) {
		if ($page > 20) break;
		if ($i != $resultpage) echo "<li><a href=\"mall.php?searchstring=$searchstring$searchcategoriesurl&resultpage=$i\">$i</a></li>\n";
		else echo "<li class=\"active\"><a href=\"#\">$i</a></li>";
		$page++;
	}
	if ($resultpage < $numberofpages) {
		$nextpage = $resultpage+1;
		echo "<li><a href=\"mall.php?searchstring=$searchstring$searchcategoriesurl&resultpage=$nextpage\">".NEXTPAGE."</a></li>\n";
	}
	echo "
		</ul>\n</div>\n";
}

// Close database...

@mysqli_close($db);

echo "</div>";


// Print footer using template...
if ($lang != $defaultlanguage && file_exists("$ashoppath$templatepath/mall-$lang.html")) ashop_showtemplatefooter("$ashoppath$templatepath/mall-$lang.html");
else ashop_showtemplatefooter("$ashoppath$templatepath/mall.html");
ob_end_flush();
?>