<?php
// AShop
// Copyright 2018 - AShop Software - http://www.ashopsoftware.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see: http://www.gnu.org/licenses/.

@set_time_limit(0);
$noinactivitycheck = "true";

// Check for GD...
ob_start();
phpinfo(8);
$phpinfo=ob_get_contents();
ob_end_clean();
$phpinfo=strip_tags($phpinfo);
$phpinfo=stristr($phpinfo,"gd version");
$phpinfo=stristr($phpinfo,"version"); 
$end=strpos($phpinfo,"\n");
$phpinfo=substr($phpinfo,0,$end);
preg_match ("/[0-9]/", $phpinfo, $version);
if(isset($version[0]) && $version[0]>1) $gdversion = 2;
else $gdversion = 0;

include "config.inc.php";
include "ashopconstants.inc.php";
include "ashopfunc.inc.php";
include "checklogin.inc.php";
include "template.inc.php";
// Get language module...
include "language/$adminlang/editproduct.inc.php";
// Get context help for this page...
$contexthelppage = "editproduct";
include "help.inc.php";
include "keycodes.inc.php";

// Get the productid...
if ($add) $productid = $add;

// Connect to database...
$db = @mysqli_connect("$databaseserver", "$databaseuser", "$databasepasswd", "$databasename");

// Handle downloads...
if ($download) {
	if (file_exists("$ashopspath/products/$download")) {
		$result = @mysqli_query($db, "SELECT filename FROM productfiles WHERE fileid='$download'");
		$filename = @mysqli_result($result, 0, "filename");
		header ("Content-Type: application/octet-stream"); 
		header ("Content-Length: ".filesize("$ashopspath/products/$download"));
		header ("Content-Disposition: attachment; filename=$filename");
		readfile_chunked("$ashopspath/products/$download",false);
		exit;
	} else exit;
}

// Change the order of product files...
if ($filemoveup) {
	$sql="UPDATE productfiles SET ordernumber=$prevordno WHERE fileid=$thisfileid";
    $result = @mysqli_query($db, $sql);
	$sql="UPDATE productfiles SET ordernumber=$thisordno WHERE fileid=$prevfileid";
    $result = @mysqli_query($db, $sql);
}

// Delete a product image...
if (is_numeric($deleteimage) && is_numeric($productid)) {
	// Get number of images...
	$productimage = ashop_productimages($productid);
	// Get product images to delete...
	$deleteproductimage = ashop_productimages($productid,$deleteimage);
	if ($deleteproductimage["main"]) unlink("$ashoppath/prodimg/$productid/$deleteimage/{$deleteproductimage["main"]}");
	if ($productimage["additionalimages"] > $deleteimage) {
		for ($imgnumber = $deleteimage+1; $imgnumber <= $productimage["additionalimages"]; $imgnumber++) {
			$newproductimage = ashop_productimages($productid,$imgnumber);
			$newimgnumber = $imgnumber-1;
			if ($newproductimage["main"]) rename("$ashoppath/prodimg/$productid/$imgnumber/{$newproductimage["main"]}","$ashoppath/prodimg/$productid/$newimgnumber/{$newproductimage["main"]}");
		}
		$newimgnumber = $imgnumber-1;
		if ($newimgnumber > 0) ashop_deleteimages("$ashoppath/prodimg/$productid/$newimgnumber");
	} else ashop_deleteimages("$ashoppath/prodimg/$productid/$deleteimage");

}

// Move a product image up one step...
if (is_numeric($moveupimage) && is_numeric($productid)) {
	if (!file_exists("$ashoppath/prodimg/$productid/temp")) mkdir("$ashoppath/prodimg/$productid/temp");

	if ($moveupimage == 1) {
		// Move top picture to temp...
		$downproductimage = ashop_productimages($productid);
		if ($downproductimage["main"]) rename("$ashoppath/prodimg/$productid/{$downproductimage["main"]}","$ashoppath/prodimg/$productid/temp/{$downproductimage["main"]}");

		// Move selected picture up...
		$upproductimage = ashop_productimages($productid,$moveupimage);
		if ($upproductimage["main"]) rename("$ashoppath/prodimg/$productid/$moveupimage/{$upproductimage["main"]}","$ashoppath/prodimg/$productid/{$upproductimage["main"]}");

		// Move previous top image to $moveupimage directory...
		if ($downproductimage["main"]) rename("$ashoppath/prodimg/$productid/temp/{$downproductimage["main"]}","$ashoppath/prodimg/$productid/$moveupimage/{$downproductimage["main"]}");

		// Remove the temp directory...
		rmdir("$ashoppath/prodimg/$productid/temp");

	} else {
		$previousimage = $moveupimage-1;

		// Move previous picture to temp...
		$downproductimage = ashop_productimages($productid,$previousimage);
		if ($downproductimage["main"]) rename("$ashoppath/prodimg/$productid/$previousimage/{$downproductimage["main"]}","$ashoppath/prodimg/$productid/temp/{$downproductimage["main"]}");

		// Move selected picture up...
		$upproductimage = ashop_productimages($productid,$moveupimage);
		if ($upproductimage["main"]) rename("$ashoppath/prodimg/$productid/$moveupimage/{$upproductimage["main"]}","$ashoppath/prodimg/$productid/$previousimage/{$upproductimage["main"]}");

		// Move previous pircture to $moveupimage directory...
		if ($downproductimage["main"]) rename("$ashoppath/prodimg/$productid/temp/{$downproductimage["main"]}","$ashoppath/prodimg/$productid/$moveupimage/{$downproductimage["main"]}");

		// Remove the temp directory...
		rmdir("$ashoppath/prodimg/$productid/temp");

	}
}

// Get information about the product from the database...
$sql="SELECT * FROM product WHERE productid = $productid";
$result = @mysqli_query($db, $sql);
$productname = @mysqli_result($result, 0, "name");
$productname = str_replace("\"", "&quot;", $productname);
$filesresult = @mysqli_query($db, "SELECT * FROM productfiles WHERE productid='$productid' AND (storage='' OR storage IS NULL) ORDER BY ordernumber");
while($filerow = @mysqli_fetch_array($filesresult)) {
	$filename[$filerow["fileid"]] = $filerow["filename"];
	$fileordernumber[$filerow["fileid"]] = $filerow["ordernumber"];
	$fileurl[$filerow["fileid"]] = $filerow["url"];
}

if ($copyfrom) unset($edited);

// Handle editing of the product...
if ($productid) {

  // Show edit form...
  if (!$edited) {

	  // Check for uploaded product files...
	  $numberoffiles = 0;
	  unset($findfile);
	  if ($userid == "1" && is_dir("$ashopspath/products")) $findfile = opendir("$ashopspath/products");
	  else if (is_dir("$ashopspath/products/$username")) $findfile = opendir("$ashopspath/products/$username");
	  if ($findfile) while (false !== ($foundfile = readdir($findfile))) {
		  if ($foundfile != "." && $foundfile != ".." && $foundfile != "CVS" && $foundfile != ".htaccess" && !preg_match("/index/", $foundfile) && !preg_match("/^[0-9]*$/", $foundfile) && substr($foundfile, 0, 1) != "_" && !is_dir("$ashopspath/products/$foundfile")) {
			  $uploadedfiles[$numberoffiles] = $foundfile;
			  $numberoffiles++;
		  }
	  }

	  // Check for uploaded preview files...
	  $numberofpreviewfiles = 0;
	  unset($findfile);
	  if (is_dir("$ashoppath/previews")) $findfile = opendir("$ashoppath/previews");
	  if ($findfile) while (false !== ($foundfile = readdir($findfile))) {
		  if ($foundfile != "." && $foundfile != ".." && $foundfile != "CVS" && $foundfile != ".htaccess" && !preg_match("/index/", $foundfile) && !preg_match("/maillog/", $foundfile) && !preg_match("/^[0-9]*$/", $foundfile) && substr($foundfile, 0, 1) != "_" && !is_dir("$ashoppath/previews/$foundfile")) {
			  $uploadedpreviewfiles[$numberofpreviewfiles] = $foundfile;
			  $numberofpreviewfiles++;
		  }
	  }

	  // Check for product files to copy...
	  if ($copyfrom) $result = @mysqli_query($db, "SELECT * FROM productfiles WHERE productid='$copyfrom' AND (storage='' OR storage IS NULL) ORDER BY filename");
	  while ($row = @mysqli_fetch_array($result)) $copyfiles[$row["fileid"]] = $row["filename"];
	  if (is_array($copyfiles)) {
		  $result = @mysqli_query($db, "SELECT * FROM product WHERE productid='$copyfrom'");
		  $copyfromname = @mysqli_result($result,0,"name");
	  }

	  if (strpos($header, "body") != 0) {
		  $newheader = substr($header,1,strpos($header, "body")+3);
		  $newheader .= " onUnload=\"closemessage()\" ".substr($header,strpos($header, "body")+4,strlen($header));
	  } else {
		  $newheader = substr($header,1,strpos($header, "BODY")+3);
		  $newheader .= " onUnload=\"closemessage()\" ".substr($header,strpos($header, "BODY")+4,strlen($header));
	  }
	  echo "$newheader
	  	<script language=\"JavaScript\">
		function uploadmessage() 
		{
		  if ((document.productform.prodfile.value != '') || (document.productform.imgfile.value != '') || (document.productform.demofile.value != '')) {
			  w = window.open('uploadmessage.html','_blank','toolbar=no,location=no,width=350,height=150');
		  }
	    }
        function closemessage()
        {
       	  if (typeof w != 'undefined') w.close();
        }
        </script>
    <section class=\"content-header\"><h1>".EDITPRODUCTFILES." <a href=\"editcatalogue.php?pid=$productid&cat=$cat\">$productname</a></h1></section>
    <section class=\"content\">
		<div class=\"row\">
			<div class=\"col-md-6\">
		<div class=\"box box-primary\">
            <form action=\"editfiles.php\" method=\"post\" enctype=\"multipart/form-data\" name=\"productimageform\">";

		if ($error) {
			echo "
                    <div class=\"alert alert-danger alert-dismissible\">
                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>
                        ".ERROR." ";
			if ($error=="extension") echo MUSTBEGIFORJPG;
			elseif ($error=="keycodes" || $error=="products") echo CHECKPERMISSIONS;
			elseif ($error=="previews") echo CHECKPERMISSIONS2;
			elseif ($error=="prodimg") echo CHECKPERMISSIONS3;
            echo "</div>";
		}

		if ($msg) {
			echo "
                    <div class=\"alert alert-info alert-dismissible\">
                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">&times;</button>";
			if ($msg=="1") echo AUTORESIZED."<br>".ORIGINALKEPT;
			elseif ($msg=="2") echo AUTORESIZED;
			elseif ($msg=="3") echo UNLOCKKEYSADDED;
            echo "</div>";
		}

		if (!$copyfromname && !$copyfiles) {
			// Get product image info...
			$productimage = ashop_productimages($productid);
			echo "
			    <div class=\"box-header with-border\">
				    <h3 class=\"box-title\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image11','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image11\" align=\"absmiddle\" onclick=\"return overlib('$tip11');\" onmouseout=\"return nd();\"></a> <a href=\"$help11\" class=\"helpnav2\" target=\"_blank\">".PRODUCTIMAGES."</a></h3>
                    <p>".GIFORJPG."</p>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
                </div>
                <div class=\"box-body\">";
			if ($productimage["thumbnail"]) echo "<div class=\"row\"><div class=\"col-md-6\"><img src=\"../prodimg/$productid/{$productimage["thumbnail"]}?x=".time()."\" alt=\"$productname\" width=\"$thumbnailwidth\" align=\"texttop\"></div><div class=\"col-md-6\">".admin_checkbox(array("label" => THEWORDDELETE, "name" => "deletethumbnail"))."</div></div>";
			if ($productimage["additionalimages"]) {
				echo "<div class=\"row\">";
				$cellcount = 0;
				for ($imagenumber = 1; $imagenumber <= $productimage["additionalimages"]; $imagenumber++) {
					$thisproductimage = ashop_productimages($productid,$imagenumber);
					if ($thisproductimage["thumbnail"]) echo "<div class=\"col-md-3 text-center\"><img src=\"$ashopurl/prodimg/$productid/$imagenumber/{$thisproductimage["thumbnail"]}?x=".time()."\" width=\"".floor($thumbnailwidth/2)."\"><p class=\"text-center\">$imagenumber) <a href=\"editfiles.php?productid=$productid&moveupimage=$imagenumber&cat=$cat&resultpage=$resultpage&add=$add\"><img src=\"images/icon_moveup.gif\" border=\"0\" align=\"absbottom\"></a> <a href=\"editfiles.php?productid=$productid&deleteimage=$imagenumber&cat=$cat&resultpage=$resultpage&add=$add\"><img src=\"images/icon_delete.gif\" border=\"0\" align=\"absbottom\"></a></p></div>";
				}
                echo "</div>";                
			}
			echo "
					<div class=\"form-group\">".admin_inputfield(array("label" => USETHEUPLOADBUTTON, "name" => "imgfile", "fileupload" => TRUE))."</div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"upload\" value=\"".THEWORDDELETE."\">".THEWORDDELETE."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"upload\" value=\"".UPLOAD."\" onClick=\"uploadmessage()\">".UPLOAD."</button>
				</div>
                <input type=\"hidden\" name=\"edit\" value=\"True\">
                <input type=\"hidden\" name=\"edited\" value=\"True\">
                <input type=\"hidden\" name=\"";
			if ($add) echo "add";
			else echo "productid";
			echo "\" value=\"$productid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"search\" value=\"$search\">
                <input type=\"hidden\" name=\"pid\" value=\"$pid\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
            </form>
        </div>

		<div class=\"box box-primary\">
			<div class=\"box-header with-border\">
				<h3 class=\"box-title\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image16','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image16\" align=\"absmiddle\" onclick=\"return overlib('$tip17');\" onmouseout=\"return nd();\"></a> ".PREVIEWFILE."</h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
            </div>
            <form action=\"editfiles.php\" method=\"post\" enctype=\"multipart/form-data\" name=\"productimageform\">
                <div class=\"box-body\">";
			if (is_dir("$ashoppath/previews/$productid")) {
				$findfile = opendir("$ashoppath/previews/$productid");
				$i = 0;
				while (false !== ($foundfile = readdir($findfile))) {
					if($foundfile && $foundfile != "." && $foundfile != "..") $previewfilename = $foundfile;
					else $previewfilename = "";
					if (!empty($previewfilename)) {
						echo "<div class=\"row\"><div class=\"col-md-6\"><b>$previewfilename</b></div><div class=\"col-md-6\"><div class=\"form-group\">".admin_checkbox(array("label" => THEWORDDELETE, "name" => "deletepreview[$i]", "value" => $foundfile))."</div></div></div>";
						$i++;
					}
					unset($foundfile);
				}
				unset($findfile);
			}
			echo "
					<div class=\"form-group\">".admin_inputfield(array("name" => "demofile", "fileupload" => TRUE, "explanation" => LEAVEBLANKTOKEEP))."</div>";
			if ($numberofpreviewfiles) {
				echo "
                    <div class=\"form-group\">
                        <label for=\"uploadedpreviewfilename\">".ORCHOOSEPREVIOUSLY."</label>
                        <select class=\"form-control\" name=\"uploadedpreviewfilename\"><option value=\"\"></option>";
				for($i = 0; $i < $numberofpreviewfiles; $i++) {
					echo "<option value=\"$uploadedpreviewfiles[$i]\">$uploadedpreviewfiles[$i]</option>";
				}
				echo "</select></div>";
			}
			echo "</div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"upload\" value=\"".THEWORDDELETE."\">".THEWORDDELETE."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"upload\" value=\"".UPLOAD."\" onClick=\"uploadmessage()\">".UPLOAD."</button>
				</div>
                <input type=\"hidden\" name=\"edit\" value=\"True\">
                <input type=\"hidden\" name=\"edited\" value=\"True\">
                <input type=\"hidden\" name=\"";
			if ($add) echo "add";
			else echo "productid";
			echo "\" value=\"$productid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"search\" value=\"$search\">
                <input type=\"hidden\" name=\"pid\" value=\"$pid\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
            </form>
        </div>
		<div class=\"box box-primary\">
            <form action=\"editfiles.php\" method=\"post\" enctype=\"multipart/form-data\">
			    <div class=\"box-header with-border\">
				    <h3 class=\"box-title\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image12','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image12\" align=\"absmiddle\" onclick=\"return overlib('$tip12');\" onmouseout=\"return nd();\"></a> <a href=\"$help12\" class=\"helpnav2\" target=\"_blank\">".PRODUCTFILES."</a></h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
                </div>
                <div class=\"box-body\">";
			if (!empty($filename) && is_array($filename) && count($filename) > 0) foreach($filename as $thisfileid=>$thisfilename) {
				if ($fileurl["$thisfileid"]) echo "<div class=\"row\"><div class=\"col-md-6\"><b><a href=\"{$fileurl["$thisfileid"]}\">$thisfilename</a></b></div><div class=\"col-md-6\"><div class=\"form-group\">".admin_checkbox(array("label" => THEWORDDELETE, "name" => "deleteprodfile$thisfileid"))."</div>";
				else echo "<div class=\"row\"><div class=\"col-md-6\"><b><a href=\"editfiles.php?download=$thisfileid\">$thisfilename</a></b></div><div class=\"col-md-6\"><div class=\"form-group\">".admin_checkbox(array("label" => THEWORDDELETE, "name" => "deleteprodfile$thisfileid"))."</div>";
				if ($filepreviousorderno) echo " <a href=\"editfiles.php?thisordno=$fileordernumber[$thisfileid]&prevordno=$filepreviousorderno&thisfileid=$thisfileid&prevfileid=$previousfileid&filemoveup=true&productid=$productid\">".MOVEUP."</a>";
				echo "</div></div>";
				$filepreviousorderno = $fileordernumber[$thisfileid];
				$previousfileid = $thisfileid;
			}
			echo "
					<div class=\"form-group\">".admin_inputfield(array("name" => "prodfile", "fileupload" => TRUE))."</div>";
			if ($numberoffiles) {
				echo "
                    <div class=\"form-group\">
                        <label for=\"uploadedfilename\">".ORCHOOSEPREVIOUSLY."</label>
                        <select class=\"form-control\" name=\"uploadedfilename\"><option value=\"\"></option>";
				for($i = 0; $i < $numberoffiles; $i++) {
					echo "<option value=\"$uploadedfiles[$i]\">$uploadedfiles[$i]</option>";
				}
				echo "</select></div>";
			}
			echo "
                    <div class=\"form-group\">".admin_inputfield(array("label" => ORCOPYAFILE, "name" => "copyfrom"))."</div>
                    <div class=\"form-group\">".admin_inputfield(array("label" => ORENTERAURL, "name" => "uploadurl", "value" => "http://"))."</div>";
			echo "
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-default\" name=\"upload\" value=\"".THEWORDDELETE."\">".THEWORDDELETE."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"upload\" value=\"".UPLOAD."\" onClick=\"uploadmessage()\">".UPLOAD."</button>
				</div>
                <input type=\"hidden\" name=\"edit\" value=\"True\">
                <input type=\"hidden\" name=\"edited\" value=\"True\">
                <input type=\"hidden\" name=\"";
			if ($add) echo "add";
			else echo "productid";
			echo "\" value=\"$productid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"search\" value=\"$search\">
                <input type=\"hidden\" name=\"pid\" value=\"$pid\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
            </form>
            </div>
		<div class=\"box box-primary\">
            <form action=\"editfiles.php\" method=\"post\" enctype=\"multipart/form-data\">
			    <div class=\"box-header with-border\">
				    <h3 class=\"box-title\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image13','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image13\" align=\"absmiddle\" onclick=\"return overlib('$tip13');\" onmouseout=\"return nd();\"></a> <a href=\"$help13\" class=\"helpnav2\" target=\"_blank\">".UPLOADKEYCODES."</a></h3>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
                </div>
                <div class=\"box-body\">
					<div class=\"form-group\">".admin_inputfield(array("name" => "unlockkeys", "fileupload" => TRUE))."</div>
                </div>
				<div class=\"box-footer\">
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"upload\" value=\"".UPLOAD."\" onClick=\"uploadmessage()\">".UPLOAD."</button>
				</div>
                <input type=\"hidden\" name=\"edit\" value=\"True\">
                <input type=\"hidden\" name=\"edited\" value=\"True\">
                <input type=\"hidden\" name=\"";
			if ($add) echo "add";
			else echo "productid";
			echo "\" value=\"$productid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"search\" value=\"$search\">
                <input type=\"hidden\" name=\"pid\" value=\"$pid\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
            </form>
            </div>
            <form action=\"editfiles.php\" method=\"post\" enctype=\"multipart/form-data\">
					<button type=\"submit\" class=\"btn btn-primary btn-block pull-right\" name=\"finish\" value=\"".FINISH."\" onClick=\"uploadmessage()\">".FINISH."</button>
                <input type=\"hidden\" name=\"edit\" value=\"True\">
                <input type=\"hidden\" name=\"edited\" value=\"True\">
                <input type=\"hidden\" name=\"";
			if ($add) echo "add";
			else echo "productid";
			echo "\" value=\"$productid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"search\" value=\"$search\">
                <input type=\"hidden\" name=\"pid\" value=\"$pid\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
            </form>
            </div>
            </div>
            </section>
            $footer";
		} else {
			echo "
			    <div class=\"box-header with-border\">
				    <h3 class=\"box-title\"><a href=\"javascript:;\" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('Image12','','images/contexthelpicon_over.gif',1)\"><img src=\"images/contexthelpicon.gif\" width=\"14\" height=\"15\" border=\"0\" name=\"Image12\" align=\"absmiddle\" onclick=\"return overlib('$tip12');\" onmouseout=\"return nd();\"></a> <a href=\"$help12\" class=\"helpnav2\" target=\"_blank\">".COPYPRODUCTFILES."</a> ".FROM." $copyfromname</h3>
                    <p>".GIFORJPG."</p>
				<div class=\"box-tools pull-right\">
					<button class=\"btn btn-box-tool\" data-widget=\"collapse\"><i class=\"fa fa-minus\"></i></button>
				</div>
                </div>
                <div class=\"box-body\">
                    <div class=\"form-group\">
                        <select class=\"form-control\" name=\"copyfile\">";
			if (is_array($copyfiles)) foreach ($copyfiles as $fileid=>$filename) echo "<option value=\"$fileid\">$filename</option>";
			echo "
                        </select>
                    </div>
                </div>
				<div class=\"box-footer\">
					<button type=\"button\" class=\"btn btn-default\" name=\"upload\" value=\"".CANCEL."\" onClick=\"history.back();\">".CANCEL."</button>
					<button type=\"submit\" class=\"btn btn-primary pull-right\" name=\"upload\" value=\"".THEWORDCOPY."\" onClick=\"uploadmessage()\">".THEWORDCOPY."</button>
				</div>
                <input type=\"hidden\" name=\"edit\" value=\"True\">
                <input type=\"hidden\" name=\"edited\" value=\"True\">
                <input type=\"hidden\" name=\"";
			if ($add) echo "add";
			else echo "productid";
			echo "\" value=\"$productid\">
                <input type=\"hidden\" name=\"cat\" value=\"$cat\">
                <input type=\"hidden\" name=\"search\" value=\"$search\">
                <input type=\"hidden\" name=\"pid\" value=\"$pid\">
                <input type=\"hidden\" name=\"resultpage\" value=\"$resultpage\">
            </form>
            </div>
            </div>
            </div>
            </section>
            $footer";
		}
  } else {
	if ($copyfile) {
		$result = @mysqli_query($db, "SELECT filename FROM productfiles WHERE fileid='$copyfile'");
		$copiedfilename = @mysqli_result($result,0,"filename");
		$copiedfileurl = @mysqli_result($result,0,"url");
		@mysqli_query($db, "INSERT INTO productfiles (fileid, filename, url, productid) VALUES ('$copyfile','$copiedfilename','$copiedfileurl', '$productid')");
		$id = @mysqli_insert_id($db);
		@mysqli_query($db, "UPDATE productfiles SET ordernumber='$id' WHERE id='$id'");
	}
	if ($deletethumbnail == "on") {
		// Get product image info...
		$productimage = ashop_productimages($productid);
		if ($productimage["main"]) unlink("$ashoppath/prodimg/$productid/{$productimage["main"]}");
		if ($productimage["additionalimages"]) {
			for ($imgnumber = 1; $imgnumber <= $productimage["additionalimages"]; $imgnumber++) {
				$newproductimage = ashop_productimages($productid,$imgnumber);
				if ($imgnumber == 1) {
					if ($newproductimage["main"]) rename("$ashoppath/prodimg/$productid/$imgnumber/{$newproductimage["main"]}","$ashoppath/prodimg/$productid/{$newproductimage["main"]}");
				} else {
					$newimgnumber = $imgnumber-1;
					if ($newproductimage["main"]) rename("$ashoppath/prodimg/$productid/$imgnumber/{$newproductimage["main"]}","$ashoppath/prodimg/$productid/$newimgnumber/{$newproductimage["main"]}");
				}
			}
			$newimgnumber = $imgnumber-1;
			if ($newimgnumber > 0) ashop_deleteimages("$ashoppath/prodimg/$productid/$newimgnumber");
		} else ashop_deleteimages("$ashoppath/prodimg/$productid");
	}
	if (is_array($deletepreview)) {
		//if (file_exists("$ashoppath/previews/$productid/$deletepreview")) unlink("$ashoppath/previews/$productid/$deletepreview");
		if (is_dir("$ashoppath/previews/$productid")) {
			$findfile = opendir("$ashoppath/previews/$productid");
			$previewfilenumber = 0;
			while (false !== ($foundfile = readdir($findfile))) { 
				if($foundfile && $foundfile != "." && $foundfile != "..") {
					if ($deletepreview[$previewfilenumber]) unlink("$ashoppath/previews/$productid/$foundfile");
					$previewfilenumber++;
				}
				unset($foundfile);
			}
			closedir($findfile);
			//rmdir("$ashoppath/previews/$productid");
			unset($findfile);
		}
	}
	if (count($filename) > 0) {
		reset($filename);
		foreach($filename as $thisfileid=>$thisfilename) {
			$deleteprodfile = "off";
			eval ("if (\$deleteprodfile$thisfileid == \"on\") \$deleteprodfile = \"on\";");
			if ($deleteprodfile == "on") {
				$result = @mysqli_query($db, "SELECT * FROM productfiles WHERE fileid='$thisfileid' AND productid!='$productid'");
				if (!@mysqli_num_rows($result) && file_exists("$ashopspath/products/$thisfileid")) unlink("$ashopspath/products/$thisfileid");
				$sql="DELETE FROM productfiles WHERE fileid='$thisfileid' AND productid='$productid'";
				$result = @mysqli_query($db, $sql);
			}
		}
	}

	if (!is_writeable("$ashopspath/products")) $error = "products";

    if (is_uploaded_file($_FILES["prodfile"]["tmp_name"]) && $error != "products") {
	   $uploadfilename = preg_replace("/%28|%29|%2B/","",urlencode(basename($_FILES["prodfile"]["name"])));
       $uploadfilename = preg_replace("/%E5|%E4/","a",$uploadfilename);
       $uploadfilename = preg_replace("/%F6/","o",$uploadfilename);
       $uploadfilename = preg_replace("/%C5|%C4/","A",$uploadfilename);
       $uploadfilename = preg_replace("/%D6/","O",$uploadfilename);
       $uploadfilename = preg_replace("/\+\+\+|\+\+/","+",$uploadfilename);
	   $result = @mysqli_query($db, "SELECT MAX(fileid) AS maxfileid FROM productfiles");
	   $uploadfileid = @mysqli_result($result,0,"maxfileid")+1;
	   $result = @mysqli_query($db, "INSERT INTO productfiles (productid, filename, fileid) VALUES ('$productid', '$uploadfilename','$uploadfileid')");
	   $id = @mysqli_insert_id($db);
	   @mysqli_query($db, "UPDATE productfiles SET ordernumber='$id' WHERE id='$id'");
       if (file_exists("$ashopspath/products/$uploadfileid")) unlink("$ashopspath/products/$uploadfileid");
	   move_uploaded_file($_FILES["prodfile"]["tmp_name"], "$ashopspath/products/$uploadfileid");
	   @chmod("$ashopspath/products/$uploadfileid", 0666);
	} else if ($uploadedfilename) {
   	  $uploadfilename = preg_replace("/%28|%29|%2B/","",urlencode(basename($uploadedfilename)));
      $uploadfilename = preg_replace("/%E5|%E4/","a",$uploadfilename);
      $uploadfilename = preg_replace("/%F6/","o",$uploadfilename);
      $uploadfilename = preg_replace("/%C5|%C4/","A",$uploadfilename);
      $uploadfilename = preg_replace("/%D6/","O",$uploadfilename);
      $uploadfilename = preg_replace("/\+\+\+|\+\+/","+",$uploadfilename);
	  $result = @mysqli_query($db, "SELECT MAX(fileid) AS maxfileid FROM productfiles");
	  $uploadfileid = @mysqli_result($result,0,"maxfileid")+1;
	  $result = @mysqli_query($db, "INSERT INTO productfiles (productid, filename, fileid) VALUES ('$productid', '$uploadfilename','$uploadfileid')");
	  $id = @mysqli_insert_id($db);
	  @mysqli_query($db, "UPDATE productfiles SET ordernumber='$id' WHERE id='$id'");
      if (file_exists("$ashopspath/products/$uploadfileid")) unlink("$ashopspath/products/$uploadfileid");
      if ($userid == "1") rename("$ashopspath/products/$uploadedfilename", "$ashopspath/products/$uploadfileid");
	  else rename("$ashopspath/products/$username/$uploadedfilename", "$ashopspath/products/$uploadfileid");
	} else if (isset($uploadurl) && $uploadurl != "http://") {
	   $uploadfilename = substr($uploadurl, strrpos($uploadurl, "/")+1);
	   $result = @mysqli_query($db, "SELECT MAX(fileid) AS maxfileid FROM productfiles");
	   $uploadfileid = @mysqli_result($result,0,"maxfileid")+1;
	   $result = @mysqli_query($db, "INSERT INTO productfiles (productid, filename, fileid, url) VALUES ('$productid', '$uploadfilename','$uploadfileid','$uploadurl')");
	   $id = @mysqli_insert_id($db);
	   @mysqli_query($db, "UPDATE productfiles SET ordernumber='$id' WHERE id='$id'");
	}

	// Handle unlock code files...
	$unlockkeys = str_replace("\t","\\t",$unlockkeys);
	if (is_uploaded_file($_FILES["unlockkeys"]["tmp_name"])) {
		if (@move_uploaded_file($_FILES["unlockkeys"]["tmp_name"], "$ashopspath/products/unlockkeys$productid")) {
			$fp = fopen ("$ashopspath/products/unlockkeys$productid","r");
			if ($fp) {
				while (!feof ($fp)) {
					$keytext = fgets($fp, 4096);
					$keytext = trim($keytext);
					if ($keytext) {
						if (!empty($keycodeencryptionkey)) $keytext = ashop_encrypt($keytext, $keycodeencryptionkey);
						$sql = "INSERT INTO unlockkeys (productid, keytext) VALUES ($productid, '$keytext')";
						$result = @mysqli_query($db, $sql);
					}
				}
				fclose($fp);
				unlink ("$ashopspath/products/unlockkeys$productid");
				$msgstring = "&msg=3";
			} else $error = "keycodes";
		} else $error = "keycodes";
	}

	// Handle preview/demo files...
	if (!is_writeable("$ashoppath/previews")) $error = "previews";
	else {
		$demofile = str_replace("\t","\\t",$demofile);
		if (is_uploaded_file($_FILES["demofile"]["tmp_name"])) {
			//if (is_dir("$ashoppath/previews/$productid")) {
				//$findfile = opendir("$ashoppath/previews/$productid");
				//while (false !== ($foundfile = readdir($findfile))) { 
					//	if($foundfile && $foundfile != "." && $foundfile != "..") unlink("$ashoppath/previews/$productid/$foundfile");
					//	unset($foundfile);
				//}
				//closedir($findfile);
				//rmdir("$ashoppath/previews/$productid");
				//unset($findfile);
			//}
			if (!is_dir("$ashoppath/previews/$productid")) {
				mkdir("$ashoppath/previews/$productid");
				@chmod("$ashoppath/previews/$productid", 0777);
			}
			if (substr($_FILES["demofile"]["name"],0,2) == "..") $_FILES["demofile"]["name"] = substr($_FILES["demofile"]["name"],2);
			if (substr($_FILES["demofile"]["name"],0,1) == ".") $_FILES["demofile"]["name"] = substr($_FILES["demofile"]["name"],1);
			$demofile_name = str_replace("/","",$_FILES["demofile"]["name"]);
			$demofile_name = str_replace("\\","",$demofile_name);
			$demofile_name = str_replace(".php",".phpfile",$demofile_name);
			$demofile_name = str_replace(".asp",".aspfile",$demofile_name);
			$demofile_name = str_replace(".cgi",".cgifile",$demofile_name);
			$demofile_name = str_replace(".pl",".plfile",$demofile_name);
			@move_uploaded_file($_FILES["demofile"]["tmp_name"], "$ashoppath/previews/$productid/$demofile_name");
			@chmod("$ashoppath/previews/$productid/$demofile_name", 0777);
		} else if ($uploadedpreviewfilename) {
			//if (is_dir("$ashoppath/previews/$productid")) {
				//	$findfile = opendir("$ashoppath/previews/$productid");
				//	while (false !== ($foundfile = readdir($findfile))) { 
					//		if($foundfile && $foundfile != "." && $foundfile != "..") unlink("$ashoppath/previews/$productid/$foundfile");
					//		unset($foundfile);
				//	}
				//	closedir($findfile);
				//	rmdir("$ashoppath/previews/$productid");
				//	unset($findfile);
			//}
			if (!is_dir("$ashoppath/previews/$productid")) {
				mkdir("$ashoppath/previews/$productid");
				@chmod("$ashoppath/previews/$productid", 0777);
			}
			copy("$ashoppath/previews/$uploadedpreviewfilename", "$ashoppath/previews/$productid/$uploadedpreviewfilename");
			@chmod("$ashoppath/previews/$productid/$uploadedpreviewfilenam", 0777);
		}
	}


   // Handle image files...
   if (!is_writeable("$ashoppath/prodimg")) $error = "prodimg";
   $imgfile = str_replace("\t","\\t",$imgfile);
	if (is_uploaded_file($_FILES["imgfile"]["tmp_name"]) && $error != "prodimg") {
	   $originalimagekept = FALSE;
	   $thumbnailautosized = FALSE;
	   $imagefilename = preg_replace("/%28|%29|%2B/","",urlencode(basename($_FILES["imgfile"]["name"])));
       $imagefilename = preg_replace("/%E5|%E4/","a",$imagefilename);
       $imagefilename = preg_replace("/%F6/","o",$imagefilename);
       $imagefilename = preg_replace("/%C5|%C4/","A",$imagefilename);
       $imagefilename = preg_replace("/%D6/","O",$imagefilename);
       $imagefilename = preg_replace("/\+\+\+|\+\+/","+",$imagefilename);
	   $fileinfo = pathinfo($_FILES["imgfile"]["name"]);
	   $extension = $fileinfo["extension"];
	   $imagefilename = str_replace(".$extension","",$imagefilename);
	   $extension = strtolower($extension);
	   if ($extension == "jpeg") $extension = "jpg";
	   if ($extension != "gif" && $extension != "jpg") $error = "extension";
	   else {
		   // Make sure the product has a subdirectory for its images...
		   if (!file_exists("$ashoppath/prodimg/$productid")) {
			   @mkdir("$ashoppath/prodimg/$productid");
			   @chmod("$ashoppath/prodimg/$productid", 0755);
		   }

		   // Check for existing files...
		   $productimage = ashop_productimages($productid);
		   if ($productimage["thumbnail"]) {
			   $imagenumber = $productimage["additionalimages"]+1;
			   $imagenumberpath = "$imagenumber/";
			   if (!file_exists("$ashoppath/prodimg/$productid/$imagenumber")) {
				   @mkdir("$ashoppath/prodimg/$productid/$imagenumber");
				   @chmod("$ashoppath/prodimg/$productid/$imagenumber", 0755);
			   }
		   } else $imagenumberpath = "";
		   move_uploaded_file($_FILES["imgfile"]["tmp_name"], "$ashoppath/prodimg/$productid/{$imagenumberpath}$imagefilename.$extension");
		   @chmod("$ashoppath/prodimg/$productid/{$imagenumberpath}$imagefilename.$extension", 0666);

		   // Determine the new sizes...
		   $imagesize = getimagesize("$ashoppath/prodimg/$productid/{$imagenumberpath}$imagefilename.$extension");
           $largewidth = 600;
           $largeheight = 600;
		   if ($imagesize[0] == 600 && $imagesize[1] == 600) $resizeoriginal = FALSE;
           else $resizeoriginal = TRUE;
           $background = "#ffffff";

		   // If GD is available resample the image to fit the size set in layout config...
		   if (function_exists('imagecreatefromjpeg') && function_exists('imagecreatefromgif') && function_exists('imagecreatetruecolor') && $gdversion == 2) {

			   // Resize the large image...
			   if ($resizeoriginal == TRUE) {
				   // Give the server some time to copy the uploaded file to the right location...
				   $resampleimage = "$ashoppath/prodimg/$productid/{$imagenumberpath}$imagefilename.$extension";
				   $starttime = date("s", time());
				   while (!@getimagesize($resampleimage)) {
					   $now = date("s", time());
					   // Time out if this has taken more than 30 seconds to avoid eternal loops...
					   if ($now - $starttime >=30) break;
				   }
				   if ($extension == "jpg") {
					   $src_img = imagecreatefromjpeg($resampleimage);
				   } else if ($extension == "gif") {
					   $src_img = imagecreatefromgif($resampleimage);
				   }
				   $quality = 90;
				   $src_width = imagesx($src_img);
				   $src_height = imagesy($src_img);
				   $dest_ar = $largewidth / $largeheight;
				   $src_ar = $src_width / $src_height;
				   if ($src_ar < $dest_ar) {
					   $dest_height = $largeheight;
					   $dest_width = ($largeheight/$src_height) * $src_width;
                       $dest_x = floor(($largewidth - $dest_width)/2);
                       $dest_y = 0;
				   } else if ($src_ar > $dest_ar) {
					   $dest_width = $largewidth;
					   $dest_height = ($largewidth/$src_width) * $src_height;
                       $dest_y = floor(($largeheight - $dest_height)/2);
                       $dest_x = 0;
				   } else {
                       $dest_width = $largewidth;
                       $dest_height = $largeheight;
                       $dest_y = 0;
                       $dest_x = 0;
                   }
				   $dest_img = imagecreatetruecolor($largewidth,$largeheight);

				   // Fill with the background color...
				   if (substr($background, 0, 1) == "#") {
					   $redcomponent = substr($background, 1, 2);
					   $greencomponent = substr($background, 3, 2);
					   $bluecomponent = substr($background, 5, 2);
				   } else {
					   $redcomponent = substr($background, 0, 2);
					   $greencomponent = substr($background, 2, 2);
					   $bluecomponent = substr($background, 4, 2);
				   }
				   $fillcolor = imagecolorallocate ($dest_img, hexdec($redcomponent), hexdec($greencomponent), hexdec($bluecomponent));
				   imagefill ($dest_img, 0, 0, $fillcolor);
				   imagecopyresampled($dest_img, $src_img, $dest_x, $dest_y, 0 ,0, $dest_width, $dest_height, $src_width, $src_height);
				   if ($extension == "jpg") {
					   imagejpeg($dest_img, $resampleimage, $quality);
				   } else if ($extension == "gif") {
					   if (function_exists("imagegif")) {
						   imagetruecolortopalette($dest_img, TRUE, 256);
						   imagegif($dest_img, $resampleimage);
					   } else {
						   imagejpeg($dest_img, $resampleimage, $quality);
						   rename($resampleimage, "$ashoppath/prodimg/$productid/{$imagenumberpath}$imagefilename.jpg");
					   }
				   }
				   imagedestroy($src_img);
				   imagedestroy($dest_img);
			   }
		   }
	   }
    }
	if ($upload) {
		if ($add) $prodidstring = "&add=$add";
		else $prodidstring = "&productid=$productid";
		if ($error) $errorstring = "&error=$error";
		if ($thumbnailautosized) {
			if ($originalimagekept) $msgstring = "&msg=1";
			else $msgstring = "&msg=2";
		}
		header ("Location: editfiles.php?cat=$cat&search=$search&pid=$pid&resultpage=$resultpage$prodidstring$errorstring$msgstring");
	} 
	else if ($error) header ("Location: editcatalogue.php?cat=$cat&search=$search&pid=$pid&error=$error&resultpage=$resultpage");
    else if ($add && $userid == 1) header("Location: editshipping.php?productid=$productid&cat=$cat&resultpage=$resultpage&search=$search");
    else header("Location: editcatalogue.php?cat=$cat&search=$search&pid=$pid&resultpage=$resultpage");
  }
}
?>